/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;

public class JSPIllegalSyntaxCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkIllegalSyntax(fileName, content, "console.log(", "Do not use console.log");
        this._checkIllegalSyntax(fileName, content, "debugger.", "Do not use debugger");
        if (!fileName.endsWith("test.jsp")) {
            this._checkIllegalSyntax(fileName, content, "System.out.print", "Do not call \"System.out.print\"");
        }
        return content;
    }

    private void _checkIllegalSyntax(String fileName, String content, String syntax, String message) {
        int x = -1;
        while ((x = content.indexOf(syntax, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(content, x)) continue;
            this.addMessage(fileName, message, this.getLineNumber(content, x));
        }
        return;
    }
}

