/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaIOExceptionCheck
extends BaseFileCheck {
    private static final Pattern _ioExceptionPattern = Pattern.compile("\tthrow new IOException\\([\\s\\S]*?;\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _ioExceptionPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = StringUtil.removeSubstring(match, ".getMessage()");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

