/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaInitialRequestPortalInstanceLifecycleListenerCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        JavaClass javaClass = (JavaClass)javaTerm;
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (extendedClassNames.contains("InitialRequestPortalInstanceLifecycleListener")) {
            this._checkInitialRequestPortalInstanceLifecycleListener(fileName, javaClass);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkInitialRequestPortalInstanceLifecycleListener(String fileName, JavaClass javaClass) {
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            Pattern pattern;
            Matcher matcher;
            JavaParameter javaParameter;
            if (!childJavaTerm.isJavaMethod() || !Objects.equals(childJavaTerm.getName(), "activate") || !childJavaTerm.hasAnnotation("Activate")) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            JavaSignature javaSignature = javaMethod.getSignature();
            List<JavaParameter> javaParameters = javaSignature.getParameters();
            if (javaParameters.isEmpty() || !Objects.equals((javaParameter = javaParameters.get(0)).getParameterType(), "BundleContext")) break;
            if (!javaMethod.hasAnnotation("Override")) {
                this.addMessage(fileName, "The \"activate\" method is missing the \"@Override\" annotation", javaMethod.getLineNumber());
            }
            if (!(matcher = (pattern = Pattern.compile("super\\.activate\\(\\s*" + javaParameter.getParameterName())).matcher(javaMethod.getContent())).find()) {
                this.addMessage(fileName, StringBundler.concat("The \"activate\" method must call \"super.activate(", javaParameter.getParameterName(), ")\""), javaMethod.getLineNumber());
            }
            return;
        }
        this.addMessage(fileName, StringBundler.concat("Missing \"activate(BundleContext bundleContext)\" method ", "with \"@Activate\" annotation that calls ", "\"super.activate(bundleContext)\""));
    }
}

