/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModuleClassGetResourceCallCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/modules/sdk/")) {
            return content;
        }
        String className = JavaSourceUtil.getClassName(fileName);
        Pattern pattern = Pattern.compile(className + "\\.class\\.getResource(AsStream)?\\(");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String getResourceMethodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(getResourceMethodCall);
            if (parameterList.isEmpty()) {
                return content;
            }
            String parameter = parameterList.get(0);
            if (!parameter.startsWith("\"")) continue;
            String literalString = null;
            int x = 0;
            while (ToolsUtil.isInsideQuotes(parameter, x = parameter.indexOf(34, x + 1))) {
            }
            literalString = parameter.substring(1, x);
            if (literalString.length() <= 1 || literalString.equals("dependencies") || literalString.startsWith("dependencies/")) continue;
            this.addMessage(fileName, "Resource files should be in \"dependencies\" directory", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

