/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaToJSONArrayCheck
extends BaseFileCheck {
    private static final Pattern _toJSONArrayPattern = Pattern.compile("toJSONArray\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _toJSONArrayPattern.matcher(content);
        while (matcher.find()) {
            String newParameter;
            String parameter;
            List<String> parameterList = JavaSourceUtil.getParameterList(JavaSourceUtil.getMethodCall(content, matcher.start()));
            if (parameterList.size() != 1 || !(parameter = parameterList.get(0)).startsWith("\"['") || !parameter.endsWith("']\"") || parameter.equals(newParameter = StringUtil.replace(parameter, new String[]{"' ,'", "','"}, new String[]{"', '", "', '"}))) continue;
            return StringUtil.replaceFirst(content, parameter, newParameter, matcher.end());
        }
        return content;
    }
}

