/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeRejectedExecutionHandlerCheck
extends BaseFileCheck {
    private static final String _REJECTED_EXECUTION_HANDLER_IMPORT = "import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;";
    private static final Pattern _rejectedExecutionHandlerPattern = Pattern.compile("RejectedExecutionHandler\\s+\\w+\\s*=\\s*(\\s*new\\s*CallerRunsPolicy\\s*\\(\\))");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        if (content.contains(_REJECTED_EXECUTION_HANDLER_IMPORT)) {
            content = StringUtil.replace(content, _REJECTED_EXECUTION_HANDLER_IMPORT, "import java.util.concurrent.RejectedExecutionHandler;");
            content = this._replaceRejectedExecutionHandler(content);
        }
        return content;
    }

    private String _replaceRejectedExecutionHandler(String content) {
        String newContent = content;
        boolean replaced = false;
        Matcher matcher = _rejectedExecutionHandlerPattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group();
            newContent = com.liferay.petra.string.StringUtil.replace(newContent, methodCall, com.liferay.petra.string.StringUtil.replace(methodCall, matcher.group(1), "new ThreadPoolExecutor.CallerRunsPolicy()"));
            replaced = true;
        }
        if (replaced) {
            newContent = JavaSourceUtil.addImports(newContent, "java.util.concurrent.ThreadPoolExecutor");
        }
        return newContent;
    }
}

