/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class YMLSourceUtil {
    public static List<String> getDefinitions(String content, String indent) {
        ArrayList<String> definitions = new ArrayList<String>();
        String[] lines = content.split("\n");
        StringBundler sb = new StringBundler();
        for (String line : lines) {
            if (line.length() == 0) {
                sb.append("\n");
                continue;
            }
            if (line.matches(" +")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            if (!line.startsWith(indent)) continue;
            String s = line.substring(indent.length(), indent.length() + 1);
            if (!s.equals(" ") && sb.length() != 0) {
                sb.setIndex(sb.index() - 1);
                definitions.add(sb.toString());
                sb.setIndex(0);
            }
            sb.append(line);
            sb.append("\n");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        definitions.add(sb.toString());
        return definitions;
    }

    public static String getNestedDefinitionIndent(String definition) {
        String[] lines = StringUtil.splitLines(definition);
        if (lines.length <= 1) {
            return "";
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String indent = line.replaceFirst("^( +).+", "$1");
            if (indent.equals(line)) continue;
            return indent;
        }
        return "";
    }

    public static List<String> splitDirectives(String content) {
        ArrayList<String> directives = new ArrayList<String>();
        String[] lines = content.split("\n");
        StringBundler sb = new StringBundler();
        for (String line : lines) {
            if (!line.equals("---")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            if (sb.index() <= 0) continue;
            sb.setIndex(sb.index() - 1);
            directives.add(sb.toString());
            sb.setIndex(0);
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
            directives.add(sb.toString());
        }
        return directives;
    }
}

