/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.json"};
    private final Pattern _incorrectLineBreakPattern = Pattern.compile("\t[\\}\\]]{2}");
    private final Pattern _leadingSpacesPattern = Pattern.compile("(^[\t ]*)(  )([^ ])");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher;
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Matcher matcher2;
                line = this.trimLine(line, true);
                while ((matcher2 = this._leadingSpacesPattern.matcher(line)).find()) {
                    line = matcher2.replaceAll("$1\t$3");
                }
                line = StringUtil.replace(line, "  ", " ");
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        if ((matcher = this._incorrectLineBreakPattern.matcher(content)).find()) {
            this.processMessage(fileName, "line break", this.getLineCount(content, matcher.start()));
        } else {
            content = this.sort(content);
        }
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    protected String sort(String content) {
        Pattern pattern1;
        Matcher matcher1;
        String tabs = "";
        while ((matcher1 = (pattern1 = Pattern.compile("(\n|^)" + tabs + "[^\n\t]*[\\{\\[]\n")).matcher(content)).find()) {
            Pattern pattern2 = Pattern.compile("((\n|^)" + tabs + "[^\n\t]*\\{\n" + tabs + "\t[^\n\t][\\s\\S]*?)\n" + tabs + "\\}");
            Matcher matcher2 = pattern2.matcher(content);
            while (matcher2.find()) {
                Pattern pattern3 = Pattern.compile("(" + tabs + "\t[^\n\t]*?([^\\{\\[]|([\\{\\[]\n[\\s\\S]*?\n" + tabs + "\t[\\}\\]]))),?(\n|$)");
                String match = matcher2.group(1);
                Matcher matcher3 = pattern3.matcher(match);
                String previousProperty = null;
                while (matcher3.find()) {
                    String property = "\n" + matcher3.group(1);
                    if (Validator.isNotNull(previousProperty) && previousProperty.compareTo(property) > 0) {
                        String replacement = StringUtil.replaceFirst(match, previousProperty, property);
                        replacement = StringUtil.replaceLast(replacement, property, previousProperty);
                        return StringUtil.replace(content, match, replacement);
                    }
                    previousProperty = property;
                }
            }
            tabs = tabs + "\t";
        }
        return content;
    }
}

