/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.JSPImportsFormatter;
import com.liferay.source.formatter.JSPSourceTabCalculator;
import com.liferay.source.formatter.util.FileUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.jsp", "**/*.jspf", "**/*.vm"};
    private static final String[][] _LIFERAY_FRONTEND_DEFINE_OBJECTS = new String[][]{{"String", "currentURL", "currentURLObj.toString()"}, {"PortletURL", "currentURLObj", "PortletURLUtil.getCurrent(liferayPortletRequest, liferayPortletResponse)"}, {"ResourceBundle", "resourceBundle", "ResourceBundleUtil.getBundle(\"content.Language\", locale, getClass()"}, {"WindowState", "windowState", "liferayPortletRequest.getWindowState()"}};
    private static final String[][] _LIFERAY_THEME_DEFINE_OBJECTS = new String[][]{{"Account", "account", "themeDisplay.getAccount()"}, {"ColorScheme", "colorScheme", "themeDisplay.getColorScheme()"}, {"Company", "company", "themeDisplay.getCompany()"}, {"Contact", "contact", "themeDisplay.getContact()"}, {"Layout", "layout", "themeDisplay.getLayout()"}, {"List<Layout>", "layouts", "themeDisplay.getLayouts()"}, {"LayoutTypePortlet", "layoutTypePortlet", "themeDisplay.getLayoutTypePortlet()"}, {"Locale", "locale", "themeDisplay.getLocale()"}, {"PermissionChecker", "permissionChecker", "themeDisplay.getPermissionChecker()"}, {"long", "plid", "themeDisplay.getPlid()"}, {"PortletDisplay", "portletDisplay", "themeDisplay.getPortletDisplay()"}, {"User", "realUser", "themeDisplay.getRealUser()"}, {"long", "scopeGroupId", "themeDisplay.getScopeGroupId()"}, {"Theme", "theme", "themeDisplay.getTheme()"}, {"ThemeDisplay", "themeDisplay", "(ThemeDisplay)request.getAttribute(WebKeys.THEME_DISPLAY)"}, {"TimeZone", "timeZone", "themeDisplay.getTimeZone()"}, {"User", "user", "themeDisplay.getUser()"}, {"long", "portletGroupId", "themeDisplay.getScopeGroupId()"}};
    private static final String[][] _PORTLET_DEFINE_OBJECTS = new String[][]{{"PortletConfig", "portletConfig", "(PortletConfig)request.getAttribute(JavaConstants.JAVAX_PORTLET_CONFIG)"}, {"String", "portletName", "portletConfig.getPortletName()"}, {"LiferayPortletRequest", "liferayPortletRequest", "PortalUtil.getLiferayPortletRequest(portletRequest)"}, {"PortletRequest", "actionRequest", "(PortletRequest)request.getAttribute(JavaConstants.JAVAX_PORTLET_REQUEST)"}, {"PortletRequest", "eventRequest", "(PortletRequest)request.getAttribute(JavaConstants.JAVAX_PORTLET_REQUEST)"}, {"PortletRequest", "renderRequest", "(PortletRequest)request.getAttribute(JavaConstants.JAVAX_PORTLET_REQUEST)"}, {"PortletRequest", "resourceRequest", "(PortletRequest)request.getAttribute(JavaConstants.JAVAX_PORTLET_REQUEST)"}, {"PortletPreferences", "portletPreferences", "portletRequest.getPreferences()"}, {"Map<String, String[]>", "portletPreferencesValues", "portletPreferences.getMap()"}, {"PortletSession", "portletSession", "portletRequest.getPortletSession()"}, {"Map<String, Object>", "portletSessionScope", "portletSession.getAttributeMap()"}, {"LiferayPortletResponse", "liferayPortletResponse", "PortalUtil.getLiferayPortletResponse(portletResponse)"}, {"PortletResponse", "actionResponse", "(PortletResponse)request.getAttribute(JavaConstants.JAVAX_PORTLET_RESPONSE)"}, {"PortletResponse", "eventResponse", "(PortletResponse)request.getAttribute(JavaConstants.JAVAX_PORTLET_RESPONSE)"}, {"PortletResponse", "renderResponse", "(PortletResponse)request.getAttribute(JavaConstants.JAVAX_PORTLET_RESPONSE)"}, {"PortletResponse", "resourceResponse", "(PortletResponse)request.getAttribute(JavaConstants.JAVAX_PORTLET_RESPONSE)"}, {"SearchContainerReference", "searchContainerReference", "(SearchContainerReference)request.getAttribute(WebKeys.SEARCH_CONTAINER_REFERENCE)"}};
    private final Pattern _compressedJSPImportPattern = Pattern.compile("(<.*\n*page.import=\".*>\n*)+", 8);
    private final Pattern _compressedJSPTaglibPattern = Pattern.compile("(<.*\n*taglib uri=\".*>\n*)+", 8);
    private final Pattern _defineObjectsPattern = Pattern.compile("\n\t*(<.*:defineObjects />)(\n|$)");
    private final Pattern _directiveLinePattern = Pattern.compile("<%@\n?.*%>");
    private final List<String> _duplicateImportClassNames = new ArrayList<String>();
    private final Pattern _emptyJavaSourceTagPattern = Pattern.compile("\n\t*<%\n+\t*%>\n");
    private final Pattern _ifTagPattern = Pattern.compile("^<c:if test=('|\")<%= (.+) %>('|\")>$");
    private final List<String> _importClassNames = new ArrayList<String>();
    private final Map<String, Integer> _importCountMap = new HashMap<String, Integer>();
    private final Pattern _importsPattern = Pattern.compile("page import=\"(.+)\"");
    private final Pattern _includeFilePattern = Pattern.compile("\\s*@\\s*include\\s*file=['\"](.*)['\"]");
    private final Pattern _incorrectClosingTagPattern = Pattern.compile("\n(\t*)\t((?!<\\w).)* />\n");
    private final Pattern _incorrectEmptyLinePattern1 = Pattern.compile("[\n\t]<%\n\n(\t*)[^/\n\t]");
    private final Pattern _incorrectEmptyLinePattern2 = Pattern.compile("([\n\t])([^/\n\t])(.*)\n\n\t*%>");
    private Pattern _javaClassPattern = Pattern.compile("\n(private|protected|public).* class ([A-Za-z0-9]+) ([\\s\\S]*?)\n\\}\n");
    private final Map<String, String> _jspContents = new HashMap<String, String>();
    private final Pattern _jspIncludeFilePattern = Pattern.compile("/.*\\.(jsp[f]?|svg)");
    private final Pattern _jspTaglibPattern = Pattern.compile("<[-\\w]+:[-\\w]+ .");
    private final Pattern _logPattern = Pattern.compile("Log _log = LogFactoryUtil\\.getLog\\(\"(.*?)\"\\)");
    private final Pattern _missingEmptyLineBetweenDefineOjbectsPattern = Pattern.compile("<.*:defineObjects />\n<.*:defineObjects />\n");
    private final Pattern _missingEmptyLinePattern = Pattern.compile("[\n\t](catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private boolean _moveFrequentlyUsedImportsToCommonInit;
    private final Pattern _multilineTagPattern = Pattern.compile("(\\s+)<[-\\w]+:[-\\w]+\n.*?(/?>)(\n|$)", 32);
    private Set<String> _primitiveTagAttributeDataTypes;
    private final Pattern _redirectBackURLPattern = Pattern.compile("(String redirect = ParamUtil\\.getString\\(request, \"redirect\".*\\);)\n(String backURL = ParamUtil\\.getString\\(request, \"backURL\", redirect\\);)");
    private boolean _stripJSPImports = true;
    private final Map<String, JavaClass> _tagJavaClassesMap = new HashMap<String, JavaClass>();
    private final Pattern _taglibLanguageKeyPattern1 = Pattern.compile("(?:confirmation|label|(?:M|m)essage|message key|names|title)=\"[^A-Z<=%\\[\\s]+\"");
    private final Pattern _taglibLanguageKeyPattern2 = Pattern.compile("(aui:)(?:input|select|field-wrapper) (?!.*label=(?:'|\").*(?:'|\").*name=\"[^<=%\\[\\s]+\")(?!.*name=\"[^<=%\\[\\s]+\".*title=(?:'|\").+(?:'|\"))(?!.*name=\"[^<=%\\[\\s]+\".*type=\"hidden\").*name=\"([^<=%\\[\\s]+)\"");
    private final Pattern _taglibLanguageKeyPattern3 = Pattern.compile("(liferay-ui:)(?:input-resource) .*id=\"([^<=%\\[\\s]+)\"(?!.*title=(?:'|\").+(?:'|\"))");
    private final Pattern _taglibVariablePattern = Pattern.compile("(\n\t*String (taglib\\w+) = (.*);)\n\\s*%>\\s+(<[\\S\\s]*?>)\n");
    private final Pattern _uncompressedJSPImportPattern = Pattern.compile("(<.*page.import=\".*>\n*)+", 8);
    private final Pattern _uncompressedJSPTaglibPattern = Pattern.compile("(<.*taglib uri=\".*>\n*)+", 8);
    private List<String> _unusedVariablesExcludes;
    private String _utilTaglibSrcDirName;
    private final Pattern _xssPattern = Pattern.compile("\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    protected void addImportCounts(String content) {
        Matcher matcher = this._importsPattern.matcher(content);
        while (matcher.find()) {
            String importName = matcher.group(1);
            int count = 0;
            if (this._importCountMap.containsKey(importName)) {
                count = this._importCountMap.get(importName);
            } else {
                int pos = importName.lastIndexOf(46);
                String importClassName = importName.substring(pos + 1);
                if (this._importClassNames.contains(importClassName)) {
                    this._duplicateImportClassNames.add(importClassName);
                } else {
                    this._importClassNames.add(importClassName);
                }
            }
            this._importCountMap.put(importName, count + 1);
        }
    }

    protected List<String> addIncludedAndReferencedFileNames(List<String> fileNames, Set<String> checkedFileNames) {
        HashSet<String> includedAndReferencedFileNames = new HashSet<String>();
        for (String fileName : fileNames) {
            if (!checkedFileNames.add(fileName)) continue;
            fileName = StringUtil.replace(fileName, '\\', '/');
            includedAndReferencedFileNames.addAll(this.getJSPIncludeFileNames(fileName, fileNames));
            includedAndReferencedFileNames.addAll(this.getJSPReferenceFileNames(fileName, fileNames));
        }
        if (includedAndReferencedFileNames.isEmpty()) {
            return fileNames;
        }
        for (String fileName : includedAndReferencedFileNames) {
            if (fileNames.contains(fileName = StringUtil.replace(fileName, '/', '\\'))) continue;
            fileNames.add(fileName);
        }
        return this.addIncludedAndReferencedFileNames(fileNames, checkedFileNames);
    }

    protected void addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) {
        for (String importLine : importLines) {
            int x = importLine.indexOf(34);
            int y = importLine.indexOf(34, x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            className = className.substring(className.lastIndexOf(46) + 1);
            String regex = "[^A-Za-z0-9_\"]" + className + "[^A-Za-z0-9_\"]";
            if (!this.hasUnusedJSPTerm(fileName, regex, "class", checkedForIncludesFileNames, includeFileNames)) continue;
            unneededImports.add(importLine);
        }
    }

    protected String buildFullPathIncludeFileName(String fileName, String includeFileName) {
        String path = fileName;
        int y;
        while ((y = path.lastIndexOf(47)) != -1) {
            String fullPathIncludeFileName = path.substring(0, y) + includeFileName;
            if (this._jspContents.containsKey(fullPathIncludeFileName) && !fullPathIncludeFileName.equals(fileName)) {
                return fullPathIncludeFileName;
            }
            path = path.substring(0, y);
        }
        return "";
    }

    protected void checkDefineObjectsVariable(String line, String fileName, int lineCount, String objectType, String variableName, String value, String tag) {
        if (line.contains(objectType + " " + variableName + " = " + value)) {
            this.processMessage(fileName, "Use '" + tag + ":defineObjects' or rename var", lineCount);
        }
    }

    protected void checkDefineObjectsVariables(String line, String fileName, String absolutePath, int lineCount) {
        for (Object defineObject : _LIFERAY_THEME_DEFINE_OBJECTS) {
            this.checkDefineObjectsVariable(line, fileName, lineCount, defineObject[0], defineObject[1], defineObject[2], "liferay-theme");
        }
        for (Object defineObject : _PORTLET_DEFINE_OBJECTS) {
            this.checkDefineObjectsVariable(line, fileName, lineCount, defineObject[0], defineObject[1], defineObject[2], "portlet");
        }
        if (!portalSource) {
            return;
        }
        try {
            for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
                if (!absolutePath.contains(directoryName)) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Object defineObject : _LIFERAY_FRONTEND_DEFINE_OBJECTS) {
            this.checkDefineObjectsVariable(line, fileName, lineCount, defineObject[0], defineObject[1], defineObject[2], "liferay-frontend");
        }
    }

    protected void checkValidatorEquals(String fileName, String content) {
        Matcher matcher = validatorEqualsPattern.matcher(content);
        while (matcher.find()) {
            this.processMessage(fileName, "Use Objects.equals(Object, Object) instead of Validator.equals(Object, Object)", this.getLineCount(content, matcher.start()));
        }
    }

    protected String compressImportsOrTaglibs(String fileName, String content, String attributePrefix) {
        if (!fileName.endsWith("init.jsp") && !fileName.endsWith("init.jspf")) {
            return content;
        }
        int x = content.indexOf(attributePrefix);
        int y = content.lastIndexOf(attributePrefix);
        y = content.indexOf("%>", y);
        if (x == -1 || y == -1 || x > y) {
            return content;
        }
        String importsOrTaglibs = content.substring(x, y);
        importsOrTaglibs = StringUtil.replace(importsOrTaglibs, new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, new String[]{"%><%@\r\n", "%><%@\n"});
        return content.substring(0, x) + importsOrTaglibs + content.substring(y);
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        JSPSourceTabCalculator jspSourceTabCalculator;
        HashSet<String> checkedForIncludesFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        String newContent = this.formatJSP(fileName, absolutePath, content, checkedForIncludesFileNames, includeFileNames);
        newContent = StringUtil.replace(newContent, new String[]{"<br/>", "@page import", "\"%>", ")%>", "function (", "javascript: ", "){\n", ";;\n", "\n\n\n"}, new String[]{"<br />", "@ page import", "\" %>", ") %>", "function(", "javascript:", ") {\n", ";\n", "\n\n"});
        newContent = this.fixRedirectBackURL(newContent);
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        newContent = this.fixEmptyLinesInNestedTags(newContent);
        newContent = this.fixEmptyLinesBetweenTags(newContent);
        newContent = this.fixIncorrectClosingTag(newContent);
        newContent = this.fixEmptyJavaSourceTag(newContent);
        Matcher matcher = this._missingEmptyLinePattern.matcher(newContent = this.formatMultilineTagAttributes(fileName, newContent));
        if (matcher.find()) {
            newContent = StringUtil.replaceFirst(newContent, "\n", "", matcher.start(1));
        }
        matcher = this._directiveLinePattern.matcher(newContent);
        while (matcher.find()) {
            String directiveLine = matcher.group();
            String newDirectiveLine = this.formatIncorrectSyntax(directiveLine, " =", "=", false);
            if (directiveLine.equals(newDirectiveLine = this.formatIncorrectSyntax(newDirectiveLine, "= ", "=", false))) continue;
            newContent = StringUtil.replace(newContent, directiveLine, newDirectiveLine);
        }
        if (this._stripJSPImports && !this._jspContents.isEmpty()) {
            try {
                newContent = this.formatJSPImportsOrTaglibs(fileName, newContent, this._compressedJSPImportPattern, this._uncompressedJSPImportPattern, true, checkedForIncludesFileNames, includeFileNames);
                newContent = this.formatJSPImportsOrTaglibs(fileName, newContent, this._compressedJSPTaglibPattern, this._uncompressedJSPTaglibPattern, false, checkedForIncludesFileNames, includeFileNames);
            }
            catch (RuntimeException re) {
                this._stripJSPImports = false;
            }
        }
        if (portalSource && content.contains("page import=") && !fileName.contains("init.jsp") && !fileName.contains("init-ext.jsp") && !fileName.contains("/taglib/aui/") && !fileName.endsWith("touch.jsp") && (fileName.endsWith(".jspf") || content.contains("include file="))) {
            this.processMessage(fileName, "move imports to init.jsp");
        }
        newContent = this.fixCopyright(newContent, absolutePath, fileName, null);
        if ((newContent = StringUtil.replace(newContent, new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."})).contains("    ") && !fileName.matches(".*template.*\\.vm$")) {
            this.processMessage(fileName, "tab");
        }
        newContent = this.compressImportsOrTaglibs(fileName, newContent, "<%@ page import=");
        newContent = this.compressImportsOrTaglibs(fileName, newContent, "<%@ taglib uri=");
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = this.fixSessionKey(fileName, newContent, taglibSessionKeyPattern);
        this.checkLanguageKeys(fileName, absolutePath, newContent, languageKeyPattern);
        this.checkLanguageKeys(fileName, absolutePath, newContent, this._taglibLanguageKeyPattern1);
        this.checkLanguageKeys(fileName, absolutePath, newContent, this._taglibLanguageKeyPattern2);
        this.checkLanguageKeys(fileName, absolutePath, newContent, this._taglibLanguageKeyPattern3);
        newContent = this.sortPutOrSetCalls(newContent, jsonObjectPutBlockPattern, jsonObjectPutPattern);
        newContent = this.sortPutOrSetCalls(newContent, setAttributeBlockPattern, setAttributePattern);
        newContent = this.formatStringBundler(fileName, newContent, -1);
        newContent = this.formatTaglibVariable(fileName, newContent);
        newContent = this.fixXSSVulnerability(fileName, newContent);
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, true, fileName);
        newContent = this.checkPrincipalException(newContent);
        newContent = this.formatLogFileName(absolutePath, newContent);
        newContent = this.formatDefineObjects(newContent);
        if (portalSource && this.isModulesFile(absolutePath) && newContent.contains("import=\"com.liferay.registry.Registry")) {
            this.processMessage(fileName, "Do not use Registry in modules");
        }
        if (portalSource && this.isModulesFile(absolutePath) && newContent.contains("import=\"com.liferay.util.ContentUtil")) {
            this.processMessage(fileName, "Do not use com.liferay.util.ContentUtil in modules");
        }
        this.checkPropertyUtils(fileName, newContent);
        this.checkStringUtilReplace(fileName, newContent);
        this.checkGetterUtilGet(fileName, newContent);
        this.checkValidatorEquals(fileName, newContent);
        matcher = this._javaClassPattern.matcher(newContent);
        if (matcher.find()) {
            String javaClassContent = matcher.group();
            javaClassContent = javaClassContent.substring(1);
            String javaClassName = matcher.group(2);
            int javaClassLineCount = this.getLineCount(newContent, matcher.start() + 1);
            newContent = this.formatJavaTerms(javaClassName, null, file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, "", null, null, null, null);
        }
        if (!content.equals(newContent = (jspSourceTabCalculator = new JSPSourceTabCalculator()).calculateTabs(fileName, newContent, this))) {
            this._jspContents.put(fileName, newContent);
        }
        return newContent;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> fileNames = this.getFileNames(excludes, this.getIncludes());
        if (fileNames.isEmpty()) {
            return fileNames;
        }
        if (this.sourceFormatterArgs.isFormatCurrentBranch() || this.sourceFormatterArgs.isFormatLatestAuthor() || this.sourceFormatterArgs.isFormatLocalChanges()) {
            return this.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>());
        }
        return fileNames;
    }

    protected String fixEmptyJavaSourceTag(String content) {
        Matcher matcher = this._emptyJavaSourceTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replace(content, matcher.group(), "");
        }
        return content;
    }

    protected String fixIncorrectClosingTag(String content) {
        Matcher matcher = this._incorrectClosingTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, " />\n", "\n" + matcher.group(1) + "/>\n", matcher.end(1));
        }
        return content;
    }

    protected String fixRedirectBackURL(String content) {
        Matcher matcher = this._redirectBackURLPattern.matcher(content);
        String newContent = content;
        while (matcher.find()) {
            newContent = StringUtil.replaceFirst(newContent, matcher.group(), matcher.group(1) + "\n\n" + matcher.group(2), matcher.start());
        }
        return newContent;
    }

    protected String fixXSSVulnerability(String fileName, String content) {
        Matcher matcher1 = this._xssPattern.matcher(content);
        String jspVariable = null;
        int vulnerabilityPos = -1;
        while (matcher1.find()) {
            jspVariable = matcher1.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            String inputVulnerability = " value=\"<%= " + jspVariable + " %>";
            vulnerabilityPos = Math.max(this.getTaglibXSSVulnerabilityPos(content, anchorVulnerability), this.getTaglibXSSVulnerabilityPos(content, inputVulnerability));
            if (vulnerabilityPos != -1) break;
            Pattern pattern = Pattern.compile("('|\\(\"| \"|\\.)<%= " + jspVariable + " %>");
            Matcher matcher2 = pattern.matcher(content);
            if (!matcher2.find()) continue;
            vulnerabilityPos = matcher2.start();
            break;
        }
        if (vulnerabilityPos != -1) {
            return StringUtil.replaceFirst(content, "<%= " + jspVariable + " %>", "<%= HtmlUtil.escape(" + jspVariable + ") %>", vulnerabilityPos);
        }
        return content;
    }

    protected String formatDefineObjects(String content) {
        Matcher matcher = this._missingEmptyLineBetweenDefineOjbectsPattern.matcher(content);
        if (matcher.find()) {
            content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        String previousDefineObjectsTag = null;
        matcher = this._defineObjectsPattern.matcher(content);
        while (matcher.find()) {
            String defineObjectsTag = matcher.group(1);
            if (Validator.isNotNull(previousDefineObjectsTag) && previousDefineObjectsTag.compareTo(defineObjectsTag) > 0) {
                content = StringUtil.replaceFirst(content, previousDefineObjectsTag, defineObjectsTag);
                content = StringUtil.replaceLast(content, defineObjectsTag, previousDefineObjectsTag);
                return content;
            }
            previousDefineObjectsTag = defineObjectsTag;
        }
        return content;
    }

    protected String formatJSP(String fileName, String absolutePath, String content, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) throws Exception {
        StringBundler sb = new StringBundler();
        String currentException = null;
        String previousException = null;
        boolean hasUnsortedExceptions = false;
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            String previousLine = "";
            boolean javaSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String includeFileName;
                int y;
                int x;
                Matcher matcher;
                ++lineCount;
                if (portalSource && this.hasUnusedTaglib(fileName, line, checkedForIncludesFileNames, includeFileNames)) continue;
                if (!fileName.contains("jsonw") || !fileName.endsWith("action.jsp")) {
                    line = this.trimLine(line, false);
                }
                if (line.contains("<aui:button ") && line.contains("type=\"button\"")) {
                    this.processMessage(fileName, "aui:button", lineCount);
                }
                if (line.contains("debugger.")) {
                    this.processMessage(fileName, "debugger", lineCount);
                }
                String trimmedLine = StringUtil.trimLeading(line);
                if (line.matches(".*\\WgetClass\\(\\)\\..+")) {
                    this.processMessage(fileName, "chaining", lineCount);
                }
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                line = this.formatEmptyArray(line);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount, javaSource);
                if (javaSource && portalSource && !this.isExcludedPath(this._unusedVariablesExcludes, absolutePath, lineCount) && !this._jspContents.isEmpty() && this.hasUnusedVariable(fileName, trimmedLine, checkedForIncludesFileNames, includeFileNames)) continue;
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*")) {
                    line = this.formatIncorrectSyntax(line, "\t ", "\t", false);
                    if ((line = this.formatWhitespace(line, javaSource)).endsWith(">")) {
                        if (line.endsWith("/>")) {
                            if (!trimmedLine.equals("/>") && !line.endsWith(" />")) {
                                line = StringUtil.replaceLast(line, "/>", " />");
                            }
                        } else if (line.endsWith(" >")) {
                            line = StringUtil.replaceLast(line, " >", ">");
                        }
                    }
                }
                if (line.contains(".sendRedirect(") && !fileName.endsWith("_jsp.jsp")) {
                    this.processMessage(fileName, "Do not use sendRedirect in jsp", lineCount);
                }
                if (javaSource) {
                    line = StringUtil.replace(line, "LanguageUtil.get(locale,", "LanguageUtil.get(request,");
                } else {
                    matcher = javaSourceInsideJSPLinePattern.matcher(line);
                    while (matcher.find()) {
                        String match = matcher.group(1);
                        String replacement = StringUtil.replace(match, "LanguageUtil.get(locale,", "LanguageUtil.get(request,");
                        line = StringUtil.replace(line, match, replacement);
                    }
                }
                this.checkResourceUtil(line, fileName, lineCount);
                this.checkDefineObjectsVariables(line, fileName, absolutePath, lineCount);
                if (!fileName.endsWith("test.jsp") && line.contains("System.out.print")) {
                    this.processMessage(fileName, "System.out.print", lineCount);
                }
                if (!trimmedLine.equals("%>") && line.contains("%>") && !line.contains("--%>") && !line.contains(" %>")) {
                    line = StringUtil.replace(line, "%>", " %>");
                }
                if (line.contains("<%=") && !line.contains("<%= ")) {
                    line = StringUtil.replace(line, "<%=", "<%= ");
                }
                if (javaSource && (trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (")) && trimmedLine.endsWith(") {")) {
                    this.checkIfClauseParentheses(trimmedLine, fileName, lineCount);
                }
                if (javaSource && trimmedLine.matches("^\\} (catch|else|finally) .*")) {
                    this.processMessage(fileName, "line break", lineCount);
                }
                if ((matcher = this._ifTagPattern.matcher(trimmedLine)).find()) {
                    String ifClause = "if (" + matcher.group(2) + ") {";
                    this.checkIfClauseParentheses(ifClause, fileName, lineCount);
                }
                matcher = this._jspTaglibPattern.matcher(line);
                while (matcher.find()) {
                    line = this.formatAttributes(fileName, line, line.substring(matcher.start()), lineCount, false);
                }
                if (trimmedLine.matches("<\\w+ .*>.*")) {
                    line = this.formatAttributes(fileName, line, trimmedLine, lineCount, false);
                }
                if (!hasUnsortedExceptions) {
                    int y2;
                    int x2 = line.indexOf("<liferay-ui:error exception=\"<%=");
                    if (x2 != -1 && (y2 = line.indexOf(".class %>", x2)) != -1) {
                        currentException = line.substring(x2, y2);
                        if (Validator.isNotNull(previousException) && previousException.compareToIgnoreCase(currentException) > 0) {
                            currentException = line;
                            previousException = previousLine;
                            hasUnsortedExceptions = true;
                        }
                    }
                    if (!hasUnsortedExceptions) {
                        previousException = currentException;
                        currentException = null;
                    }
                }
                if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                    while (trimmedLine.contains("\t")) {
                        line = StringUtil.replaceLast(line, "\t", " ");
                        trimmedLine = StringUtil.replaceLast(trimmedLine, "\t", " ");
                    }
                    while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                        line = StringUtil.replaceLast(line, "  ", " ");
                        trimmedLine = StringUtil.replaceLast(trimmedLine, "  ", " ");
                    }
                }
                if (!fileName.endsWith("/touch.jsp") && (x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf(34, (x = line.indexOf(34, x)) + 1)) != -1 && !(matcher = this._jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                    this.processMessage(fileName, "include", lineCount);
                }
                line = this.replacePrimitiveWrapperInstantiation(line);
                if (lineCount > 1) {
                    sb.append(previousLine);
                    sb.append("\n");
                    if (this.addExtraEmptyLine(previousLine, line, javaSource)) {
                        sb.append("\n");
                    }
                }
                previousLine = line;
            }
            sb.append(previousLine);
        }
        content = sb.toString();
        while (true) {
            Matcher matcher;
            if ((matcher = this._incorrectEmptyLinePattern1.matcher(content)).find()) {
                content = StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
                continue;
            }
            matcher = this._incorrectEmptyLinePattern2.matcher(content);
            if (!matcher.find()) break;
            content = StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        if (hasUnsortedExceptions) {
            if (StringUtil.count(content, currentException) > 1 || StringUtil.count(content, previousException) > 1) {
                this.processMessage(fileName, "unsorted exceptions");
            } else {
                content = StringUtil.replaceFirst(content, previousException, currentException);
                content = StringUtil.replaceLast(content, currentException, previousException);
            }
        }
        return content;
    }

    protected String formatJSPImportsOrTaglibs(String fileName, String content, Pattern compressedPattern, Pattern uncompressedPattern, boolean checkUnusedImports, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) throws IOException {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = compressedPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        String newImports = StringUtil.replace(imports, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        if (checkUnusedImports) {
            ArrayList<String> importLines = new ArrayList<String>();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(newImports));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (!line.contains("import=")) continue;
                importLines.add(line);
            }
            List<String> unneededImports = this.getJSPDuplicateImports(fileName, content, importLines);
            this.addJSPUnusedImports(fileName, importLines, unneededImports, checkedForIncludesFileNames, includeFileNames);
            for (String unneededImport : unneededImports) {
                newImports = StringUtil.replace(newImports, unneededImport, "");
            }
        }
        content = StringUtil.replaceFirst(content, imports, newImports);
        JSPImportsFormatter importsFormatter = new JSPImportsFormatter();
        return importsFormatter.format(content, uncompressedPattern);
    }

    protected String formatLogFileName(String absolutePath, String content) {
        if (!this.isModulesFile(absolutePath) && !absolutePath.contains("/portal-web/")) {
            return content;
        }
        Matcher matcher = this._logPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String logFileName = StringUtil.replace(absolutePath, ".", "_");
        logFileName = StringUtil.replace(logFileName, "/", ".");
        int x = (logFileName = StringUtil.replace(logFileName, "-", "_")).lastIndexOf(".portal_web.");
        if (x != -1) {
            logFileName = logFileName.substring(x + 1);
        } else {
            x = logFileName.lastIndexOf(".docroot.");
            if (x == -1) {
                x = Math.max(logFileName.lastIndexOf(".src.main.resources.META_INF.resources."), logFileName.lastIndexOf(".src.META_INF.resources."));
            }
            if (x == -1) {
                return content;
            }
            x = logFileName.lastIndexOf(".", x - 1);
            logFileName = "com_liferay_" + logFileName.substring(x + 1);
            logFileName = StringUtil.replace(logFileName, new String[]{".docroot.", ".src.main.resources.META_INF.resources.", ".src.META_INF.resources."}, new String[]{".", ".", "."});
        }
        return StringUtil.replace(content, matcher.group(), "Log _log = LogFactoryUtil.getLog(\"" + logFileName + "\")");
    }

    protected String formatMultilineTagAttributes(String fileName, String content) throws Exception {
        Matcher matcher = this._multilineTagPattern.matcher(content);
        while (matcher.find()) {
            char beforeClosingTagChar = content.charAt(matcher.start(2) - 1);
            if (beforeClosingTagChar != '\n' && beforeClosingTagChar != '\t') {
                String closingTag = matcher.group(2);
                String whitespace = matcher.group(1);
                String tabs = StringUtil.removeChar(whitespace, '\n');
                return StringUtil.replaceFirst(content, closingTag, "\n" + tabs + closingTag, matcher.start(2));
            }
            String tag = matcher.group();
            String singlelineTag = StringUtil.removeChar(StringUtil.trim(tag), '\t');
            String newTag = this.formatAttributes(fileName, tag, singlelineTag = StringUtil.replace(singlelineTag, '\n', ' '), this.getLineCount(content, matcher.end(1)), false);
            if (tag.equals(newTag)) continue;
            return StringUtil.replace(content, tag, newTag);
        }
        return content;
    }

    @Override
    protected String formatTagAttributeType(String line, String tagName, String attributeAndValue) throws Exception {
        if (attributeAndValue.matches(".*=\"<%= Boolean\\.(FALSE|TRUE) %>\".*")) {
            String newAttributeAndValue = StringUtil.replace(attributeAndValue, new String[]{"=\"<%= Boolean.FALSE %>\"", "=\"<%= Boolean.TRUE %>\""}, new String[]{"=\"<%= false %>\"", "=\"<%= true %>\""});
            return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
        }
        if (!portalSource) {
            return line;
        }
        if (!attributeAndValue.endsWith("\"") || attributeAndValue.contains("\"<%=")) {
            return line;
        }
        JavaClass tagJavaClass = this._tagJavaClassesMap.get(tagName);
        if (tagJavaClass == null) {
            return line;
        }
        int pos = attributeAndValue.indexOf("=\"");
        String attribute = attributeAndValue.substring(0, pos);
        String setAttributeMethodName = "set" + TextFormatter.format(attribute, 6);
        for (String dataType : this.getPrimitiveTagAttributeDataTypes()) {
            Type javaType = new Type(dataType);
            JavaMethod setAttributeMethod = null;
            while (true) {
                try {
                    setAttributeMethod = tagJavaClass.getMethodBySignature(setAttributeMethodName, new Type[]{javaType}, true);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            if (setAttributeMethod == null) continue;
            String value = attributeAndValue.substring(pos + 2, attributeAndValue.length() - 1);
            if (!this.isValidTagAttributeValue(value, dataType)) {
                return line;
            }
            String newAttributeAndValue = StringUtil.replace(attributeAndValue, "\"" + value + "\"", "\"<%= " + value + " %>\"");
            return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
        }
        if (!attributeAndValue.matches(".*=\"(false|true)\".*")) {
            return line;
        }
        JavaMethod setAttributeMethod = tagJavaClass.getMethodBySignature(setAttributeMethodName, new Type[]{new Type("java.lang.String")}, true);
        if (setAttributeMethod == null) {
            return line;
        }
        String newAttributeAndValue = StringUtil.replace(attributeAndValue, new String[]{"=\"false\"", "=\"true\""}, new String[]{"=\"<%= Boolean.FALSE.toString() %>\"", "=\"<%= Boolean.TRUE.toString() %>\""});
        return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
    }

    protected String formatTaglibVariable(String fileName, String content) {
        Matcher matcher = this._taglibVariablePattern.matcher(content);
        while (matcher.find()) {
            String taglibValue = matcher.group(3);
            if (taglibValue.contains("\\\"") || taglibValue.contains("'") && taglibValue.contains("\"")) continue;
            String taglibName = matcher.group(2);
            String nextTag = matcher.group(4);
            if (!nextTag.contains(taglibName)) {
                this.processMessage(fileName, "No need to specify taglib variable", this.getLineCount(content, matcher.start()));
                continue;
            }
            content = StringUtil.replaceFirst(content, taglibName, taglibValue, matcher.start(4));
            content = StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
            return content;
        }
        return content;
    }

    protected List<String> getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !this.isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    protected Set<String> getJSPIncludeFileNames(String fileName, Collection<String> fileNames) {
        int y;
        HashSet<String> includeFileNames = new HashSet<String>();
        String content = this._jspContents.get(fileName);
        if (Validator.isNull(content)) {
            return includeFileNames;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf(34, x)) != -1 && (y = content.indexOf(34, x + 1)) != -1) {
            Matcher matcher;
            String includeFileName = content.substring(x + 1, y);
            if (!includeFileName.startsWith("/")) {
                includeFileName = "/" + includeFileName;
            }
            if (!(matcher = this._jspIncludeFilePattern.matcher(includeFileName)).find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String extension = matcher.group(1);
            if (extension.equals("svg")) {
                x = y;
                continue;
            }
            if (!(!(includeFileName = this.buildFullPathIncludeFileName(fileName, includeFileName)).endsWith("jsp") && !includeFileName.endsWith("jspf") || includeFileName.endsWith("html/common/init.jsp") || includeFileName.endsWith("html/portlet/init.jsp") || includeFileName.endsWith("html/taglib/init.jsp") || fileNames.contains(includeFileName))) {
                includeFileNames.add(includeFileName);
            }
            x = y;
        }
        return includeFileNames;
    }

    protected Set<String> getJSPReferenceFileNames(String fileName, Collection<String> fileNames) {
        HashSet<String> referenceFileNames = new HashSet<String>();
        if (!(fileName.endsWith("init.jsp") || fileName.endsWith("init.jspf") || fileName.contains("init-ext.jsp"))) {
            return referenceFileNames;
        }
        block0: for (Map.Entry<String, String> entry : this._jspContents.entrySet()) {
            String sharedPath;
            String referenceFileName = entry.getKey();
            if (fileNames.contains(referenceFileName) || Validator.isNull(sharedPath = fileName.substring(0, StringUtil.startsWithWeight(referenceFileName, fileName))) || !sharedPath.contains("/")) continue;
            if (!sharedPath.endsWith("/")) {
                sharedPath = sharedPath.substring(0, sharedPath.lastIndexOf(47) + 1);
            }
            String content = null;
            int x = -1;
            while ((x = sharedPath.indexOf(47, x + 1)) != -1) {
                if (content == null) {
                    content = entry.getValue();
                }
                if (!content.contains("<%@ include file=\"" + fileName.substring(x)) && !content.contains("<%@ include file=\"" + fileName.substring(x + 1))) continue;
                referenceFileNames.add(referenceFileName);
                continue block0;
            }
        }
        return referenceFileNames;
    }

    protected Set<String> getPrimitiveTagAttributeDataTypes() {
        if (this._primitiveTagAttributeDataTypes != null) {
            return this._primitiveTagAttributeDataTypes;
        }
        Set<String> primitiveTagAttributeDataTypes = SetUtil.fromArray(new String[]{"boolean", "double", "int", "long"});
        this._primitiveTagAttributeDataTypes = primitiveTagAttributeDataTypes;
        return this._primitiveTagAttributeDataTypes;
    }

    protected int getTaglibXSSVulnerabilityPos(String content, String vulnerability) {
        String tagContent;
        int x = -1;
        do {
            if ((x = content.indexOf(vulnerability, x + 1)) == -1) {
                return x;
            }
            tagContent = null;
            int y = x;
            do {
                if ((y = content.lastIndexOf(60, y - 1)) != -1) continue;
                return -1;
            } while (content.charAt(y + 1) == '%' || this.getLevel(tagContent = content.substring(y, x), "<", ">") != 1);
        } while (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:"));
        return x;
    }

    protected String getUtilTaglibSrcDirName() {
        if (this._utilTaglibSrcDirName != null) {
            return this._utilTaglibSrcDirName;
        }
        File utilTaglibDir = this.getFile("util-taglib/src", 7);
        String utilTaglibSrcDirName = null;
        if (utilTaglibDir != null) {
            utilTaglibSrcDirName = utilTaglibDir.getAbsolutePath();
            utilTaglibSrcDirName = StringUtil.replace(utilTaglibSrcDirName, "\\", "/");
            utilTaglibSrcDirName = utilTaglibSrcDirName + "/";
        } else {
            utilTaglibSrcDirName = "";
        }
        this._utilTaglibSrcDirName = utilTaglibSrcDirName;
        return this._utilTaglibSrcDirName;
    }

    protected String getVariableName(String line) {
        if (!line.endsWith(";") || line.startsWith("//")) {
            return null;
        }
        String variableName = null;
        int x = line.indexOf(" = ");
        if (x == -1) {
            int y = line.lastIndexOf(32);
            if (y != -1) {
                variableName = line.substring(y + 1, line.length() - 1);
            }
        } else {
            int y = (line = line.substring(0, x)).lastIndexOf(32);
            if (y != -1) {
                variableName = line.substring(y + 1);
            }
        }
        if (Validator.isVariableName(variableName)) {
            return variableName;
        }
        return null;
    }

    protected boolean hasUnusedJSPTerm(String fileName, String regex, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) {
        includeFileNames.add(fileName);
        HashSet<String> checkedForUnusedJSPTerm = new HashSet<String>();
        return !this.isJSPTermRequired(fileName, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames);
    }

    protected boolean hasUnusedTaglib(String fileName, String line, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) {
        if (!line.startsWith("<%@ taglib uri=")) {
            return false;
        }
        int x = line.indexOf(" prefix=");
        if (x == -1) {
            return false;
        }
        x = line.indexOf(34, x);
        int y = line.indexOf(34, x + 1);
        if (x == -1 || y == -1) {
            return false;
        }
        String taglibPrefix = line.substring(x + 1, y);
        String regex = "<" + taglibPrefix + ":";
        return this.hasUnusedJSPTerm(fileName, regex, "taglib", checkedForIncludesFileNames, includeFileNames);
    }

    protected boolean hasUnusedVariable(String fileName, String line, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) {
        if (line.contains(": ")) {
            return false;
        }
        String variableName = this.getVariableName(line);
        if (Validator.isNull(variableName) || variableName.equals("false") || variableName.equals("true")) {
            return false;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("((/)|(\\*)|(\\+(\\+)?)|(-(-)?)|\\(|=)?( )?");
        sb.append(variableName);
        sb.append("( )?(\\.");
        sb.append("|(((\\+)|(-)|(\\*)|(/)|(%)|(\\|)|(&)|(\\^))?(=))");
        sb.append("|(\\+(\\+)?)|(-(-)?)");
        sb.append("|(\\)))?");
        return this.hasUnusedJSPTerm(fileName, sb.toString(), "variable", checkedForIncludesFileNames, includeFileNames);
    }

    protected boolean isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = this._jspContents.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf(34, y)) == -1) {
            return false;
        }
        int z = content.indexOf(34, y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        includeFileName = this.buildFullPathIncludeFileName(fileName, includeFileName);
        return this.isJSPDuplicateImport(includeFileName, importLine, true);
    }

    protected boolean isJSPTermRequired(String fileName, String regex, String type, Set<String> checkedForUnusedJSPTerm, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames) {
        String[] includeFileNamesArray;
        if (checkedForUnusedJSPTerm.contains(fileName)) {
            return false;
        }
        checkedForUnusedJSPTerm.add(fileName);
        String content = this._jspContents.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find() && (!type.equals("variable") || checkedForUnusedJSPTerm.size() > 1 || matcher.find())) {
            return true;
        }
        if (!checkedForIncludesFileNames.contains(fileName)) {
            includeFileNames.addAll(this.getJSPIncludeFileNames(fileName, includeFileNames));
            includeFileNames.addAll(this.getJSPReferenceFileNames(fileName, includeFileNames));
        }
        checkedForIncludesFileNames.add(fileName);
        for (String includeFileName : includeFileNamesArray = includeFileNames.toArray(new String[includeFileNames.size()])) {
            if (checkedForUnusedJSPTerm.contains(includeFileName) || !this.isJSPTermRequired(includeFileName, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidTagAttributeValue(String value, String dataType) {
        if (dataType.equals("boolean")) {
            return Validator.isBoolean(value);
        }
        if (dataType.equals("double")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }
        if (dataType.equals("int") || dataType.equals("long")) {
            return Validator.isNumber(value);
        }
        return false;
    }

    protected void moveFrequentlyUsedImportsToCommonInit(int minCount) throws IOException {
        if (this._importCountMap.isEmpty()) {
            return;
        }
        String commonInitFileName = "portal-web/docroot/html/common/init.jsp";
        File commonInitFile = null;
        String commonInitFileContent = null;
        int x = -1;
        for (Map.Entry<String, Integer> importCount : this._importCountMap.entrySet()) {
            int y;
            String importName;
            String importClassName;
            Integer count = importCount.getValue();
            if (count < minCount || this._duplicateImportClassNames.contains(importClassName = (importName = importCount.getKey()).substring((y = importName.lastIndexOf(46)) + 1))) continue;
            if (commonInitFileContent == null) {
                commonInitFile = new File(commonInitFileName);
                commonInitFileContent = FileUtil.read(commonInitFile);
                x = commonInitFileContent.indexOf("<%@ page import");
            }
            commonInitFileContent = StringUtil.insert(commonInitFileContent, "<%@ page import=\"" + importName + "\" %>\n", x);
        }
        if (commonInitFileContent != null) {
            FileUtil.write(commonInitFile, commonInitFileContent);
            this._jspContents.put(commonInitFileName, commonInitFileContent);
        }
    }

    @Override
    protected void preFormat() throws Exception {
        this._moveFrequentlyUsedImportsToCommonInit = GetterUtil.getBoolean(this.getProperty("move.frequently.used.imports.to.common.init"));
        this._unusedVariablesExcludes = this.getPropertyList("jsp.unused.variables.excludes");
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> allFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, excludes, this.getIncludes());
        try {
            for (String fileName : allFileNames) {
                File file = new File(fileName);
                fileName = StringUtil.replace(fileName, "\\", "/");
                String absolutePath = this.getAbsolutePath(file);
                String content = FileUtil.read(file);
                Matcher matcher = this._includeFilePattern.matcher(content);
                String newContent = content;
                while (matcher.find()) {
                    newContent = StringUtil.replaceFirst(newContent, matcher.group(), "@ include file=\"" + matcher.group(1) + "\"", matcher.start());
                }
                this.processFormattedFile(file, fileName, content, newContent);
                if (portalSource && this._moveFrequentlyUsedImportsToCommonInit && fileName.endsWith("/init.jsp") && !this.isModulesFile(absolutePath, true) && !fileName.endsWith("/common/init.jsp")) {
                    this.addImportCounts(content);
                }
                this._jspContents.put(fileName, newContent);
            }
            if (portalSource && this._moveFrequentlyUsedImportsToCommonInit) {
                this.moveFrequentlyUsedImportsToCommonInit(4);
            }
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
        if (portalSource) {
            this._populateTagJavaClasses();
        }
    }

    @Override
    protected String sortHTMLAttributes(String line, String value, String attributeAndValue) {
        if (!value.matches("([-a-z0-9]+ )+[-a-z0-9]+")) {
            return line;
        }
        List<String> htmlAttributes = ListUtil.fromArray(StringUtil.split(value, " "));
        Collections.sort(htmlAttributes);
        String newValue = StringUtil.merge(htmlAttributes, " ");
        if (value.equals(newValue)) {
            return line;
        }
        String newAttributeAndValue = StringUtil.replace(attributeAndValue, value, newValue);
        return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
    }

    private void _populateTagJavaClasses() throws Exception {
        List<String> tldFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, new String[]{"**/dependencies/**", "**/util-taglib/**"}, new String[]{"**/*.tld"});
        block0: for (String tldFileName : tldFileNames) {
            tldFileName = StringUtil.replace(tldFileName, "\\", "/");
            File tldFile = new File(tldFileName);
            String content = FileUtil.read(tldFile);
            Document document = this.readXML(content);
            Element rootElement = document.getRootElement();
            Element shortNameElement = rootElement.element("short-name");
            String shortName = shortNameElement.getStringValue();
            List tagElements = rootElement.elements("tag");
            String srcDir = null;
            for (Element tagElement : tagElements) {
                Element tagClassElement = tagElement.element("tag-class");
                String tagClassName = tagClassElement.getStringValue();
                if (!tagClassName.startsWith("com.liferay")) continue;
                if (srcDir == null) {
                    if (tldFileName.contains("/src/")) {
                        srcDir = tldFile.getAbsolutePath();
                        srcDir = StringUtil.replace(srcDir, "\\", "/");
                        srcDir = srcDir.substring(0, srcDir.lastIndexOf("/src/")) + "/src/main/java/";
                    } else {
                        srcDir = this.getUtilTaglibSrcDirName();
                        if (Validator.isNull(srcDir)) continue block0;
                    }
                }
                StringBundler sb = new StringBundler(3);
                sb.append(srcDir);
                sb.append(StringUtil.replace(tagClassName, '.', '/'));
                sb.append(".java");
                File tagJavaFile = new File(sb.toString());
                if (!tagJavaFile.exists()) continue;
                JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
                javaDocBuilder.addSource(tagJavaFile);
                JavaClass tagJavaClass = javaDocBuilder.getClassByName(tagClassName);
                Element tagNameElement = tagElement.element("name");
                String tagName = tagNameElement.getStringValue();
                this._tagJavaClassesMap.put(shortName + ":" + tagName, tagJavaClass);
            }
        }
    }
}

