/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JavaSourceTabCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPSourceTabCalculator {
    private JSPSourceProcessor _jspSourceProcessor;

    public String calculateTabs(String fileName, String content, JSPSourceProcessor jspSourceProcessor) throws Exception {
        if (!fileName.endsWith(".jsp") && !fileName.endsWith(".jspf")) {
            return content;
        }
        this._jspSourceProcessor = jspSourceProcessor;
        String originalContent = content;
        String newContent;
        while (!(newContent = this._calculateTabs(fileName, content, originalContent)).equals(content) && !newContent.equals(originalContent)) {
            content = newContent;
        }
        return newContent;
    }

    private int _calculateTabLevel(String text, boolean javaSource) {
        if (javaSource) {
            return this._jspSourceProcessor.getLevel(text, new String[]{"{", "("}, new String[]{"}", ")"});
        }
        if (text.matches("(--)?%>")) {
            return -1;
        }
        text = this._stripJavaSource(text);
        text = this._jspSourceProcessor.stripQuotes(text);
        int level = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                if (i + 1 < text.length() && text.charAt(i + 1) == '!') continue;
                if (i + 1 < text.length() && text.charAt(i + 1) == '/') {
                    --level;
                    continue;
                }
                ++level;
                continue;
            }
            if (c == '>' && i > 0 && text.charAt(i - 1) == '/') {
                --level;
                continue;
            }
            if (c == '{') {
                ++level;
                continue;
            }
            if (c != '}') continue;
            --level;
        }
        return level;
    }

    private String _calculateTabs(String fileName, String content, String originalContent) throws Exception {
        List<JSPLine> jspLines = this._getJSPLines(content);
        if (jspLines == null) {
            return originalContent;
        }
        for (int i = 0; i < jspLines.size(); ++i) {
            JSPLine jspLine = jspLines.get(i);
            if (jspLine.isCloseTag()) {
                if (jspLine.isClosed()) continue;
                return originalContent;
            }
            String line = jspLine.getLine();
            if (!jspLine.isOpenTag()) {
                if (jspLine.isJavaSource()) continue;
                int actualTabCount = jspLine.getLeadingTabCount();
                int expectedTabCount = jspLine.getTabLevel();
                String trimmedLine = StringUtil.trim(line);
                if (trimmedLine.equals(">")) {
                    --expectedTabCount;
                }
                if (expectedTabCount == actualTabCount) continue;
                return this._fixTabs(content, jspLine.getLineCount(), actualTabCount - expectedTabCount);
            }
            JSPLine closeTagJSPLine = this._getCloseTagJSPLine(jspLine, jspLines, i);
            if (closeTagJSPLine == null) {
                return originalContent;
            }
            String closeTagName = closeTagJSPLine.getTagName();
            String openTagName = jspLine.getTagName();
            if (Validator.isNotNull(closeTagName) && !closeTagName.equals(openTagName)) {
                return originalContent;
            }
            int expectedTabCount = this._getExpectedTabCount(jspLine, closeTagJSPLine, jspLines, i);
            int actualCloseTagTabCount = closeTagJSPLine.getLeadingTabCount();
            int actualOpenTagTabCount = jspLine.getLeadingTabCount();
            if (expectedTabCount != actualOpenTagTabCount) {
                int diff = actualOpenTagTabCount - expectedTabCount;
                if (actualOpenTagTabCount == actualCloseTagTabCount) {
                    return this._fixTabs(content, jspLine.getLineCount(), closeTagJSPLine.getLineCount(), diff);
                }
                return this._fixTabs(content, jspLine.getLineCount(), diff);
            }
            if (expectedTabCount != actualCloseTagTabCount) {
                return this._fixTabs(content, closeTagJSPLine.getLineCount(), actualCloseTagTabCount - expectedTabCount);
            }
            if (line.matches("\t*<%!?")) {
                content = this._checkTabsJavaSourceBlock(fileName, content, expectedTabCount, jspLine.getLineCount() + 1, closeTagJSPLine.getLineCount() - 1, jspLine.getTabLevel());
            }
            closeTagJSPLine.setClosed(true);
        }
        return content;
    }

    private String _checkTabsJavaSourceBlock(String fileName, String content, int tabCount, int startLine, int endLine, int tabLevel) throws Exception {
        int minLeadingTabCount = -1;
        for (int i = startLine; i <= endLine; ++i) {
            String line = this._jspSourceProcessor.getLine(content, i);
            if (Validator.isNull(line)) continue;
            int leadingTabCount = this._jspSourceProcessor.getLeadingTabCount(line);
            minLeadingTabCount = minLeadingTabCount == -1 ? leadingTabCount : Math.min(minLeadingTabCount, leadingTabCount);
        }
        if (tabCount != minLeadingTabCount) {
            return this._fixTabs(content, startLine, endLine, minLeadingTabCount - tabCount);
        }
        int startPos = this._jspSourceProcessor.getLineStartPos(content, startLine);
        int endPos = this._jspSourceProcessor.getLineStartPos(content, endLine + 1);
        JavaSourceTabCalculator javaSourceTabCalculator = new JavaSourceTabCalculator();
        javaSourceTabCalculator.calculateTabs(fileName, content.substring(startPos, endPos), startLine - 1, tabLevel, this._jspSourceProcessor);
        return content;
    }

    private String _fixTabs(String content, int lineCount, int diff) {
        return this._fixTabs(content, lineCount, lineCount, diff);
    }

    private String _fixTabs(String content, int startLine, int endLine, int diff) {
        boolean insideUnformattedTextTag = false;
        for (int i = startLine; i <= endLine; ++i) {
            String line = this._jspSourceProcessor.getLine(content, i);
            if (Validator.isNull(line)) continue;
            String trimmedLine = StringUtil.trimLeading(line);
            if (insideUnformattedTextTag) {
                if (!trimmedLine.matches(".*</(pre|textarea)>")) continue;
                insideUnformattedTextTag = false;
                if (trimmedLine.matches(".+</(pre|textarea)>")) continue;
            }
            int lineStartPos = this._jspSourceProcessor.getLineStartPos(content, i);
            content = diff < 0 ? content.substring(0, lineStartPos) + "\t" + content.substring(lineStartPos) : content.substring(0, lineStartPos) + content.substring(lineStartPos + 1);
            if (insideUnformattedTextTag || !trimmedLine.matches("<(pre|textarea).*")) continue;
            insideUnformattedTextTag = true;
        }
        return content;
    }

    private JSPLine _getCloseTagJSPLine(JSPLine openTagJSPLine, List<JSPLine> jspLines, int index) {
        String line;
        String openTagLine;
        JSPLine jspLine;
        do {
            if (++index < jspLines.size()) continue;
            return null;
        } while (!(jspLine = jspLines.get(index)).isCloseTag() || !((openTagLine = openTagJSPLine.getLine()).matches("\t*<%!?") ? (line = jspLine.getLine()).matches("\t*%>") : jspLine.isCloseTag() && openTagJSPLine.getTabLevel() == jspLine.getLineTabLevel() + jspLine.getTabLevel()));
        return jspLine;
    }

    private int _getExpectedTabCount(JSPLine startTagJSPLine, JSPLine closeTagJSPLine, List<JSPLine> jspLines, int index) {
        JSPLine jspLine;
        String startTagLine = startTagJSPLine.getLine();
        if (!startTagLine.matches("\t*<%!?")) {
            return startTagJSPLine.getTabLevel();
        }
        int minJavaSourceLevel = startTagJSPLine.getTabLevel();
        do {
            jspLine = jspLines.get(++index);
            minJavaSourceLevel = Math.min(minJavaSourceLevel, jspLine.getTabLevel() - 1);
        } while (!jspLine.equals(closeTagJSPLine));
        return minJavaSourceLevel;
    }

    private List<JSPLine> _getJSPLines(String content) throws Exception {
        ArrayList<JSPLine> jspLines = new ArrayList<JSPLine>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            int tabLevel = 0;
            boolean javaSource = false;
            boolean scriptSource = false;
            boolean multiLineComment = false;
            boolean insideUnformattedTextTag = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int lineTabLevel;
                ++lineCount;
                if (Validator.isNull(line)) continue;
                String trimmedLine = StringUtil.trimLeading(line);
                if (insideUnformattedTextTag) {
                    if (!trimmedLine.matches(".*</(pre|textarea)>")) continue;
                    insideUnformattedTextTag = false;
                    if (trimmedLine.matches(".+</(pre|textarea)>")) continue;
                }
                if (javaSource) {
                    if (trimmedLine.equals("%>")) {
                        javaSource = false;
                    }
                    if (trimmedLine.startsWith("/*") && !trimmedLine.startsWith("/**")) {
                        multiLineComment = true;
                        continue;
                    }
                    if (line.endsWith("*/")) {
                        multiLineComment = false;
                        continue;
                    }
                    if (multiLineComment || trimmedLine.startsWith("*") || trimmedLine.startsWith("/*") || trimmedLine.startsWith("//")) {
                        continue;
                    }
                } else if (!scriptSource && line.endsWith("--%>")) {
                    multiLineComment = false;
                }
                if (scriptSource && trimmedLine.matches("</(aui:)?script>")) {
                    scriptSource = false;
                }
                if (trimmedLine.equals("AUI.add(")) {
                    ArrayList<JSPLine> arrayList = jspLines;
                    return arrayList;
                }
                if (!scriptSource && !multiLineComment) {
                    lineTabLevel = this._calculateTabLevel(trimmedLine, javaSource);
                    if (!javaSource && Math.abs(lineTabLevel) > 1) {
                        List<JSPLine> list = null;
                        return list;
                    }
                    JSPLine jspLine = new JSPLine(line, lineCount, tabLevel, lineTabLevel, javaSource);
                    jspLines.add(jspLine);
                    tabLevel += lineTabLevel;
                }
                if (!javaSource && trimmedLine.matches("<%!?")) {
                    javaSource = true;
                    continue;
                }
                if (scriptSource) continue;
                if (trimmedLine.matches("<(aui:)?script.*")) {
                    lineTabLevel = this._calculateTabLevel(trimmedLine, javaSource);
                    if (lineTabLevel <= 0) continue;
                    scriptSource = true;
                    continue;
                }
                if (trimmedLine.startsWith("<%--")) {
                    multiLineComment = true;
                    continue;
                }
                if (!trimmedLine.matches("<(pre|textarea).*")) continue;
                insideUnformattedTextTag = true;
            }
        }
        return jspLines;
    }

    private String _stripJavaSource(String text) {
        int x;
        while ((x = text.indexOf("<%")) != -1) {
            int y = text.indexOf("%>", x);
            if (y == -1) {
                return text;
            }
            text = text.substring(0, x) + text.substring(y + 2);
        }
        return text;
    }

    private class JSPLine {
        private boolean _closed;
        private final Pattern _closeTagNamePattern = Pattern.compile("</([\\-:\\w]+?)>");
        private final boolean _javaSource;
        private final String _line;
        private final int _lineCount;
        private int _lineTabLevel;
        private final Pattern _openTagNamePattern = Pattern.compile("<([\\-:\\w]+?)([ >\n].*|$)");
        private final int _tabLevel;

        public JSPLine(String line, int lineCount, int tabLevel, int lineTabLevel, boolean javaSource) {
            this._line = line;
            this._lineCount = lineCount;
            this._tabLevel = tabLevel;
            this._lineTabLevel = lineTabLevel;
            this._javaSource = javaSource;
        }

        public int getLeadingTabCount() {
            return JSPSourceTabCalculator.this._jspSourceProcessor.getLeadingTabCount(this._line);
        }

        public String getLine() {
            return this._line;
        }

        public int getLineCount() {
            return this._lineCount;
        }

        public int getLineTabLevel() {
            return this._lineTabLevel;
        }

        public int getTabLevel() {
            return this._tabLevel;
        }

        public String getTagName() {
            Matcher matcher = null;
            if (this.isCloseTag()) {
                matcher = this._closeTagNamePattern.matcher(this._line);
            } else if (this.isOpenTag()) {
                matcher = this._openTagNamePattern.matcher(this._line);
            } else {
                return null;
            }
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }

        public boolean isClosed() {
            return this._closed;
        }

        public boolean isCloseTag() {
            return !this._javaSource && this._lineTabLevel == -1;
        }

        public boolean isJavaSource() {
            return this._javaSource;
        }

        public boolean isOpenTag() {
            return !this._javaSource && this._lineTabLevel == 1;
        }

        public void setClosed(boolean closed) {
            this._closed = closed;
        }
    }
}

