/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BNDSourceProcessor;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.CSSSourceProcessor;
import com.liferay.source.formatter.FTLSourceProcessor;
import com.liferay.source.formatter.GradleSourceProcessor;
import com.liferay.source.formatter.GroovySourceProcessor;
import com.liferay.source.formatter.JSONSourceProcessor;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JSSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.SHSourceProcessor;
import com.liferay.source.formatter.SQLSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.TLDSourceProcessor;
import com.liferay.source.formatter.XMLSourceProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SourceFormatter {
    private volatile SourceMismatchException _firstSourceMismatchException;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private final SourceFormatterArgs _sourceFormatterArgs;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new ConcurrentSkipListSet<SourceFormatterMessage>();

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            boolean autoFix = ArgumentsUtil.getBoolean(arguments, "source.auto.fix", true);
            sourceFormatterArgs.setAutoFix(autoFix);
            String baseDirName = ArgumentsUtil.getString(arguments, "source.base.dir", "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            boolean formatCurrentBranch = ArgumentsUtil.getBoolean(arguments, "format.current.branch", false);
            sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
            boolean formatLatestAuthor = ArgumentsUtil.getBoolean(arguments, "format.latest.author", false);
            sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
            boolean formatLocalChanges = ArgumentsUtil.getBoolean(arguments, "format.local.changes", false);
            sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
            if (formatCurrentBranch) {
                String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
                sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName));
            } else if (formatLatestAuthor) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName));
            } else if (formatLocalChanges) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName));
            }
            String copyrightFileName = ArgumentsUtil.getString(arguments, "source.copyright.file", "copyright.txt");
            sourceFormatterArgs.setCopyrightFileName(copyrightFileName);
            String fileNamesString = ArgumentsUtil.getString(arguments, "source.files", "");
            Object[] fileNames = StringUtil.split(fileNamesString, ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            }
            int maxLineLength = ArgumentsUtil.getInteger(arguments, "max.line.length", 80);
            sourceFormatterArgs.setMaxLineLength(maxLineLength);
            boolean printErrors = ArgumentsUtil.getBoolean(arguments, "source.print.errors", true);
            sourceFormatterArgs.setPrintErrors(printErrors);
            int processorThreadCount = ArgumentsUtil.getInteger(arguments, "processor.thread.count", 5);
            sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
            boolean throwException = ArgumentsUtil.getBoolean(arguments, "source.throw.exception", false);
            sourceFormatterArgs.setThrowException(throwException);
            boolean useProperties = ArgumentsUtil.getBoolean(arguments, "source.use.properties", false);
            sourceFormatterArgs.setUseProperties(useProperties);
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
    }

    public void format() throws Exception {
        ArrayList<BaseSourceProcessor> sourceProcessors = new ArrayList<BaseSourceProcessor>();
        sourceProcessors.add(new BNDSourceProcessor());
        sourceProcessors.add(new CSSSourceProcessor());
        sourceProcessors.add(new FTLSourceProcessor());
        sourceProcessors.add(new GradleSourceProcessor());
        sourceProcessors.add(new GroovySourceProcessor());
        sourceProcessors.add(new JavaSourceProcessor());
        sourceProcessors.add(new JSONSourceProcessor());
        sourceProcessors.add(new JSPSourceProcessor());
        sourceProcessors.add(new JSSourceProcessor());
        sourceProcessors.add(new PropertiesSourceProcessor());
        sourceProcessors.add(new SHSourceProcessor());
        sourceProcessors.add(new SQLSourceProcessor());
        sourceProcessors.add(new TLDSourceProcessor());
        sourceProcessors.add(new XMLSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException ee1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee2) {
                if (ee1 == null) {
                    ee1 = ee2;
                    continue;
                }
                ee1.addSuppressed(ee2);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (ee1 != null) {
            throw ee1;
        }
        if (this._sourceFormatterArgs.isThrowException()) {
            if (!this._sourceFormatterMessages.isEmpty()) {
                StringBundler stringBundler = new StringBundler(this._sourceFormatterMessages.size() * 2);
                for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
                    stringBundler.append(sourceFormatterMessage.toString());
                    stringBundler.append("\n");
                }
                throw new Exception(stringBundler.toString());
            }
            if (this._firstSourceMismatchException != null) {
                throw this._firstSourceMismatchException;
            }
        }
    }

    public List<SourceFormatterMessage> getSourceFormatterMessages() {
        return new ArrayList<SourceFormatterMessage>(this._sourceFormatterMessages);
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public SourceMismatchException getSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.format();
        this._sourceFormatterMessages.addAll(sourceProcessor.getSourceFormatterMessages());
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
        if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = sourceProcessor.getFirstSourceMismatchException();
        }
    }
}

