/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SourceFormatterHelper {
    private final Properties _properties = new Properties();
    private String _propertiesContent = "";
    private File _propertiesFile;
    private final boolean _useProperties;

    public SourceFormatterHelper(boolean useProperties) {
        this._useProperties = useProperties;
    }

    public void close() throws IOException {
        if (!this._useProperties) {
            return;
        }
        String newPropertiesContent = PropertiesUtil.toString(this._properties);
        if (!this._propertiesContent.equals(newPropertiesContent)) {
            FileUtil.write(this._propertiesFile, newPropertiesContent);
        }
    }

    public List<String> getFileNames(String baseDir, List<String> recentChangesFileNames, String[] excludes, String[] includes) throws Exception {
        ArrayList<PathMatcher> excludeDirPathMatchers = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> excludeFilePathMatchers = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> includeFilePathMatchers = new ArrayList<PathMatcher>();
        FileSystem fileSystem = FileSystems.getDefault();
        for (String exclude : excludes) {
            if (exclude.endsWith("/**")) {
                exclude = exclude.substring(0, exclude.length() - 3);
                excludeDirPathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
                continue;
            }
            excludeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
        }
        for (String include : includes) {
            includeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + include));
        }
        if (recentChangesFileNames == null) {
            return this.scanForFiles(baseDir, excludeDirPathMatchers, excludeFilePathMatchers, includeFilePathMatchers);
        }
        return this.getFileNames(baseDir, recentChangesFileNames, excludeDirPathMatchers, excludeFilePathMatchers, includeFilePathMatchers);
    }

    public void init() throws IOException {
        if (!this._useProperties) {
            return;
        }
        File basedirFile = new File("./");
        String basedirAbsolutePath = StringUtil.replace(basedirFile.getAbsolutePath(), new char[]{'.', ':', '/', '\\'}, new char[]{'_', '_', '_', '_'});
        String propertiesFileName = System.getProperty("java.io.tmpdir") + "/SourceFormatter." + basedirAbsolutePath;
        this._propertiesFile = new File(propertiesFileName);
        if (this._propertiesFile.exists()) {
            this._propertiesContent = FileUtil.read(this._propertiesFile);
            PropertiesUtil.load(this._properties, this._propertiesContent);
        }
    }

    public void printError(String fileName, File file) {
        this.printError(fileName, file.toString());
    }

    public void printError(String fileName, String message) {
        if (this._useProperties) {
            String encodedFileName = StringUtil.replace(fileName, "\\", "/");
            this._properties.remove(encodedFileName);
        }
        System.out.println(message);
    }

    protected Path getCanonicalPath(Path path) {
        try {
            File file = path.toFile();
            File canonicalFile = file.getCanonicalFile();
            return canonicalFile.toPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected List<String> getFileNames(String baseDir, List<String> recentChangesFileNames, List<PathMatcher> excludeDirPathMatchers, List<PathMatcher> excludeFilePathMatchers, List<PathMatcher> includeFilePathMatchers) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        block0: for (String fileName : recentChangesFileNames) {
            fileName = baseDir.concat(fileName);
            File file = new File(fileName);
            File canonicalFile = file.getCanonicalFile();
            Path filePath = canonicalFile.toPath();
            for (PathMatcher pathMatcher : excludeFilePathMatchers) {
                if (!pathMatcher.matches(filePath)) continue;
                continue block0;
            }
            File dir = file.getParentFile();
            do {
                File canonicalDir = dir.getCanonicalFile();
                Path dirPath = canonicalDir.toPath();
                for (PathMatcher pathMatcher : excludeDirPathMatchers) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    continue block0;
                }
                if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) continue block0;
            } while ((dir = dir.getParentFile()) != null);
            for (PathMatcher pathMatcher : includeFilePathMatchers) {
                if (!pathMatcher.matches(filePath)) continue;
                fileName = StringUtil.replace(fileName, "/", "\\");
                fileNames.add(fileName);
                this.updateProperties(fileName);
                continue block0;
            }
        }
        return fileNames;
    }

    protected List<String> scanForFiles(String baseDir, final List<PathMatcher> excludeDirPathMatchers, final List<PathMatcher> excludeFilePathMatchers, final List<PathMatcher> includeFilePathMatchers) throws Exception {
        final ArrayList<String> fileNames = new ArrayList<String>();
        Files.walkFileTree(Paths.get(baseDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                dirPath = SourceFormatterHelper.this.getCanonicalPath(dirPath);
                for (PathMatcher pathMatcher : excludeDirPathMatchers) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                Path canonicalPath = SourceFormatterHelper.this.getCanonicalPath(filePath);
                for (PathMatcher pathMatcher : excludeFilePathMatchers) {
                    if (!pathMatcher.matches(canonicalPath)) continue;
                    return FileVisitResult.CONTINUE;
                }
                for (PathMatcher pathMatcher : includeFilePathMatchers) {
                    if (!pathMatcher.matches(canonicalPath)) continue;
                    String fileName = filePath.toString();
                    fileNames.add(fileName);
                    SourceFormatterHelper.this.updateProperties(fileName);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileNames;
    }

    protected void updateProperties(String fileName) {
        if (!this._useProperties) {
            return;
        }
        File file = new File(fileName);
        String encodedFileName = StringUtil.replace(fileName, "\\", "/");
        long timestamp = GetterUtil.getLong(this._properties.getProperty(encodedFileName));
        if (timestamp < file.lastModified()) {
            this._properties.setProperty(encodedFileName, String.valueOf(file.lastModified()));
        }
    }
}

