/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CheckStyleUtil {
    private static List<SourceFormatterMessage> _sourceFormatterMessages = new ArrayList<SourceFormatterMessage>();

    public static List<SourceFormatterMessage> process(String configurationFileName, List<File> files, String baseDirAbsolutePath) throws Exception {
        Checker checker = CheckStyleUtil._getChecker(configurationFileName, baseDirAbsolutePath);
        checker.process(files);
        return _sourceFormatterMessages;
    }

    private static Checker _getChecker(String configurationFileName, String baseDirAbsolutePath) {
        try {
            Checker checker = new Checker();
            checker.setModuleClassLoader(CheckStyleUtil.class.getClassLoader());
            Configuration configuration = ConfigurationLoader.loadConfiguration((String)configurationFileName, (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
            checker.configure(configuration);
            SourceFormatterLogger listener = new SourceFormatterLogger(new UnsyncByteArrayOutputStream(), true, baseDirAbsolutePath);
            checker.addListener((AuditListener)listener);
            return checker;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class SourceFormatterLogger
    extends DefaultLogger {
        private final String _baseDirAbsolutePath;

        public SourceFormatterLogger(OutputStream outputStream, boolean closeStreamsAfterUse, String baseDirAbsolutePath) {
            super(outputStream, closeStreamsAfterUse);
            this._baseDirAbsolutePath = baseDirAbsolutePath;
        }

        public void addError(AuditEvent auditEvent) {
            String fileName = StringUtil.replace(auditEvent.getFileName(), "\\", "/");
            if (fileName.startsWith(this._baseDirAbsolutePath + "/")) {
                fileName = StringUtil.replaceFirst(fileName, this._baseDirAbsolutePath + "/", "");
            }
            _sourceFormatterMessages.add(new SourceFormatterMessage(fileName, auditEvent.getMessage(), auditEvent.getLine()));
            super.addError(auditEvent);
        }
    }
}

