/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import aQute.bnd.osgi.Constants;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.BNDImportsFormatter;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDE_RESOURCE_DIRS_BLACKLIST = new String[]{"classes", "META-INF/resources=src/main/resources/META-INF/resources", "META-INF/resources/content=src/main/resources/content", "WEB-INF=src/main/resources/WEB-INF"};
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};
    private final Pattern _bundleClassPathPattern = Pattern.compile("^Bundle-ClassPath:[\\s\\S]*?([^\\\\]\n|\\Z)", 8);
    private final Pattern _bundleNamePattern = Pattern.compile("^Bundle-Name: (.*)\n", 8);
    private final Pattern _bundleSymbolicNamePattern = Pattern.compile("^Bundle-SymbolicName: (.*)\n", 8);
    private Map<String, String> _definitionKeysMap;
    private final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )(.*?\n|\\Z)[^\t]", 40);
    private Map<String, Map<String, String>> _fileSpecificDefinitionKeysMap;
    private final Pattern _importsPattern = Pattern.compile("\nImport-Package:(\\\\\n| )(.*?\n|\\Z)[^\t]", 40);
    private final Pattern _includeResourcePattern = Pattern.compile("^(-includeresource|Include-Resource):[\\s\\S]*?([^\\\\]\n|\\Z)", 8);
    private final Pattern _incorrectTabPattern = Pattern.compile("\n[^\t].*:\\\\\n(\t{2,})[^\t]");
    private final Pattern _singleValueOnMultipleLinesPattern = Pattern.compile("\n.*:(\\\\\n\t).*(\n[^\t]|\\Z)");
    private final Pattern _webContextPathNamePattern = Pattern.compile("^Web-ContextPath: (.*)\n", 8);
    private final Pattern _wilcardImportPattern = Pattern.compile("(\\S+\\*)(,\\\\\n|\n|\\Z)");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    protected void checkDirectoryAndBundleName(String fileName, String absolutePath, String content) {
        String webContextPath;
        String expectedBundleSymbolicName;
        String bundleSymbolicName;
        Matcher matcher;
        if (!portalSource || !this.isModulesFile(absolutePath) || !fileName.endsWith("/bnd.bnd") || absolutePath.contains("/testIntegration/") || absolutePath.contains("/third-party/")) {
            return;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String dirName = absolutePath.substring(y + 1, x);
        if (dirName.endsWith("-taglib-web")) {
            String newDirName = dirName.substring(0, dirName.length() - 4);
            this.processMessage(fileName, "Rename module '" + dirName + "' to '" + newDirName + "'");
        }
        if ((matcher = this._bundleNamePattern.matcher(content)).find()) {
            String expectedBundleName;
            String bundleName = matcher.group(1);
            String strippedBundleName = StringUtil.removeChars(bundleName, '-', ' ');
            strippedBundleName = strippedBundleName.replaceAll("Implementation$", "Impl");
            if (!StringUtil.equalsIgnoreCase(strippedBundleName = strippedBundleName.replaceAll("Utilities$", "Util"), expectedBundleName = "liferay" + StringUtil.removeChars(dirName, '-'))) {
                this.processMessage(fileName, "Incorrect Bundle-Name '" + bundleName + "'");
            }
        }
        if (dirName.contains("-import-") || dirName.contains("-private-")) {
            return;
        }
        matcher = this._bundleSymbolicNamePattern.matcher(content);
        if (matcher.find() && !StringUtil.equalsIgnoreCase(bundleSymbolicName = matcher.group(1), expectedBundleSymbolicName = "com.liferay." + StringUtil.replace(dirName, '-', '.'))) {
            this.processMessage(fileName, "Incorrect Bundle-SymbolicName '" + bundleSymbolicName + "'");
        }
        if ((matcher = this._webContextPathNamePattern.matcher(content)).find() && !(webContextPath = matcher.group(1)).equals("/" + dirName)) {
            this.processMessage(fileName, "Incorrect Web-ContextPath '" + webContextPath + "'");
        }
    }

    protected void checkWildcardImports(String fileName, String absolutePath, String content, Pattern pattern) {
        if (absolutePath.contains("/portal-kernel/") || absolutePath.contains("/util-bridges/") || absolutePath.contains("/util-java/") || absolutePath.contains("/util-taglib/") || fileName.endsWith("/system.packages.extra.bnd")) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String imports = matcher.group(2);
        matcher = this._wilcardImportPattern.matcher(imports);
        while (matcher.find()) {
            String wildcardImport = matcher.group(1);
            if (!wildcardImport.matches("^!?com\\.liferay\\..+")) continue;
            this.processMessage(fileName, "Do not use wildcard in Export-Package '" + wildcardImport + "'");
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher;
        content = this.trimContent(content, false);
        content = StringUtil.replace(content, new String[]{"/\n", "/,\\\n"}, new String[]{"\n", ",\\\n"});
        if (fileName.endsWith("-web/bnd.bnd") && content.contains("Liferay-Require-SchemaVersion: 1.0.0")) {
            this.processMessage(fileName, "Do not include the header Liferay-Require-SchemaVersion in web modules");
        }
        if ((matcher = this._incorrectTabPattern.matcher(content = StringUtil.replace(content, " \\\n", "\\\n"))).find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), "\t", matcher.start());
        }
        if ((matcher = this._singleValueOnMultipleLinesPattern.matcher(content)).find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start());
        }
        this.checkWildcardImports(fileName, absolutePath, content, this._exportsPattern);
        BNDImportsFormatter importsFormatter = new BNDImportsFormatter();
        content = importsFormatter.format(content, this._exportsPattern);
        content = importsFormatter.format(content, this._importsPattern);
        this.checkDirectoryAndBundleName(fileName, absolutePath, content);
        content = this.formatBundleClassPath(content);
        if (portalSource && this.isModulesFile(absolutePath) && !fileName.endsWith("test-bnd.bnd")) {
            content = this.formatIncludeResource(content);
        }
        return this.sortDefinitions(fileName, content, new DefinitionComparator());
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    protected String formatBundleClassPath(String content) {
        Matcher matcher = this._bundleClassPathPattern.matcher(content);
        if (matcher.find()) {
            return this.sortDefinitionProperties(content, matcher.group(), new NaturalOrderStringComparator());
        }
        return content;
    }

    @Override
    protected String formatDefinitionKey(String fileName, String content, String definitionKey) {
        String lowerCaseDefinitionKey;
        Map<String, String> generalDefinitionKeysMap = this.getDefinitionKeysMap();
        String correctKey = generalDefinitionKeysMap.get(lowerCaseDefinitionKey = StringUtil.toLowerCase(definitionKey));
        if (correctKey == null) {
            int pos = fileName.lastIndexOf("/");
            String shortFileName = fileName.substring(pos + 1);
            Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = this.getFileSpecificDefinitionKeysMap();
            Map<String, String> definitionKeysMap = fileSpecificDefinitionKeysMap.get(shortFileName);
            if (definitionKeysMap != null) {
                correctKey = definitionKeysMap.get(lowerCaseDefinitionKey);
            }
        }
        if (correctKey == null) {
            this.processMessage(fileName, "Unknown key \"" + definitionKey + "\"");
            return content;
        }
        if (correctKey.equals(definitionKey)) {
            return content;
        }
        if (content.startsWith(definitionKey)) {
            return StringUtil.replaceFirst(content, definitionKey, correctKey);
        }
        return StringUtil.replace(content, "\n" + definitionKey + ":", "\n" + correctKey + ":");
    }

    protected String formatIncludeResource(String content) {
        Matcher matcher = this._includeResourcePattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String includeResources = matcher.group();
        for (String includeResourceDir : _INCLUDE_RESOURCE_DIRS_BLACKLIST) {
            Pattern includeResourceDirPattern = Pattern.compile("(\t|: )" + includeResourceDir + "(,\\\\\n|\n||\\Z)");
            Matcher matcher2 = includeResourceDirPattern.matcher(includeResources);
            if (!matcher2.find()) continue;
            String beforeIncludeResourceDir = matcher2.group(1);
            if (!beforeIncludeResourceDir.equals("\t")) {
                return StringUtil.replace(content, includeResources, "");
            }
            String afterIncludeResourceDir = matcher2.group(2);
            int x = includeResources.lastIndexOf("\\", matcher2.start());
            int y = matcher2.end();
            String replacement = null;
            if (afterIncludeResourceDir.equals(",\\\n")) {
                replacement = includeResources.substring(0, x + 1) + includeResources.substring(y - 1);
            } else {
                replacement = includeResources.substring(0, x - 1);
                if (afterIncludeResourceDir.equals("\n")) {
                    replacement = replacement + "\n";
                }
            }
            return StringUtil.replace(content, includeResources, replacement);
        }
        return this.sortDefinitionProperties(content, includeResources, new IncludeResourceComparator());
    }

    protected Map<String, String> getDefinitionKeysMap() {
        if (this._definitionKeysMap != null) {
            return this._definitionKeysMap;
        }
        Map<Object, Object> definitionKeysMap = new HashMap();
        definitionKeysMap = this.populateDefinitionKeysMap(ArrayUtil.append(Constants.BUNDLE_SPECIFIC_HEADERS, Constants.headers, Constants.options));
        this._definitionKeysMap = definitionKeysMap;
        return this._definitionKeysMap;
    }

    protected Map<String, Map<String, String>> getFileSpecificDefinitionKeysMap() {
        if (this._fileSpecificDefinitionKeysMap != null) {
            return this._fileSpecificDefinitionKeysMap;
        }
        HashMap<String, Map<String, String>> fileSpecificDefinitionKeysMap = new HashMap<String, Map<String, String>>();
        fileSpecificDefinitionKeysMap.put("app.bnd", this.populateDefinitionKeysMap("Liferay-Releng-App-Description", "Liferay-Releng-App-Title", "Liferay-Releng-Bundle", "Liferay-Releng-Category", "Liferay-Releng-Demo-Url", "Liferay-Releng-Deprecated", "Liferay-Releng-Labs", "Liferay-Releng-Marketplace", "Liferay-Releng-Portal-Required", "Liferay-Releng-Public", "Liferay-Releng-Restart-Required", "Liferay-Releng-Support-Url", "Liferay-Releng-Supported"));
        fileSpecificDefinitionKeysMap.put("bnd.bnd", this.populateDefinitionKeysMap("-metatype-inherit", "Can-Redefine-Classes", "Can-Retransform-Classes", "Implementation-Version", "JPM-Command", "Liferay-Export-JS-Submodules", "Liferay-JS-Config", "Liferay-Releng-App-Description", "Liferay-Releng-Module-Group-Description", "Liferay-Releng-Module-Group-Title", "Liferay-Require-SchemaVersion", "Liferay-Service", "Liferay-Theme-Contributor-Type", "Liferay-Theme-Contributor-Weight", "Main-Class", "Premain-Class", "Web-ContextPath"));
        fileSpecificDefinitionKeysMap.put("common.bnd", this.populateDefinitionKeysMap("Git-Descriptor", "Git-SHA", "Javac-Compiler", "Javac-Debug", "Javac-Deprecation", "Javac-Encoding", "Liferay-Portal-Build-Date", "Liferay-Portal-Build-Number", "Liferay-Portal-Build-Time", "Liferay-Portal-Code-Name", "Liferay-Portal-Parent-Build-Number", "Liferay-Portal-Release-Info", "Liferay-Portal-Server-Info", "Liferay-Portal-Version"));
        this._fileSpecificDefinitionKeysMap = fileSpecificDefinitionKeysMap;
        return this._fileSpecificDefinitionKeysMap;
    }

    protected Map<String, String> populateDefinitionKeysMap(String ... keys) {
        HashMap<String, String> definitionKeysMap = new HashMap<String, String>();
        for (String key : keys) {
            definitionKeysMap.put(StringUtil.toLowerCase(key), key);
        }
        return definitionKeysMap;
    }

    protected String sortDefinitionProperties(String content, String properties, Comparator<String> comparator) {
        String[] lines = StringUtil.splitLines(properties);
        if (lines.length == 1) {
            return content;
        }
        String previousProperty = null;
        for (int i = 1; i < lines.length; ++i) {
            int value;
            String property = StringUtil.trim(lines[i]);
            if (property.endsWith(",\\")) {
                property = property.substring(0, property.length() - 2);
            }
            if (previousProperty != null && (value = comparator.compare(previousProperty, property)) > 0) {
                String replacement = StringUtil.replaceFirst(properties, previousProperty, property);
                replacement = StringUtil.replaceLast(replacement, property, previousProperty);
                return StringUtil.replace(content, properties, replacement);
            }
            previousProperty = property;
        }
        return content;
    }

    private static class IncludeResourceComparator
    implements Comparator<String> {
        private IncludeResourceComparator() {
        }

        @Override
        public int compare(String includeResource1, String includeResource2) {
            String jarFileName2;
            if (includeResource1.startsWith("@") ^ includeResource2.startsWith("@")) {
                if (includeResource1.startsWith("@")) {
                    return 1;
                }
                return -1;
            }
            int pos1 = includeResource1.indexOf(".jar!/");
            int pos2 = includeResource2.indexOf(".jar!/");
            if (pos1 == -1 || pos2 == -1) {
                return includeResource1.compareToIgnoreCase(includeResource2);
            }
            String jarFileName1 = includeResource1.substring(0, pos1);
            if (!jarFileName1.equals(jarFileName2 = includeResource1.substring(0, pos2))) {
                return includeResource1.compareToIgnoreCase(includeResource2);
            }
            ImportPackage importPackage1 = new ImportPackage(includeResource1.substring(pos1 + 6), false, includeResource1);
            ImportPackage importPackage2 = new ImportPackage(includeResource2.substring(pos2 + 6), false, includeResource2);
            return importPackage1.compareTo(importPackage2);
        }
    }

    private static class DefinitionComparator
    implements Comparator<String> {
        private DefinitionComparator() {
        }

        @Override
        public int compare(String definition1, String definition2) {
            if (definition1.startsWith("-") ^ definition2.startsWith("-")) {
                return -definition1.compareTo(definition2);
            }
            return definition1.compareTo(definition2);
        }
    }
}

