/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class MissingEmptyLineCheck
extends AbstractCheck {
    public static final String MSG_MISSING_EMPTY_LINE = "empty.line.missing";

    public int[] getDefaultTokens() {
        return new int[]{80};
    }

    public void visitToken(DetailAST detailAST) {
        this.checkMissingLine(detailAST);
    }

    protected void checkMissingLine(DetailAST detailAST) {
        int startLineNextExpression;
        DetailAST firstChildAST = detailAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() == 59) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        DetailAST nextSibling = parentAST.getNextSibling();
        if (nextSibling == null || nextSibling.getType() != 45) {
            return;
        }
        if ((nextSibling = nextSibling.getNextSibling()) == null) {
            return;
        }
        DetailAST nameAST = null;
        if (parentAST.getType() == 28) {
            nameAST = detailAST.findFirstToken(58);
        } else if (parentAST.getType() == 10) {
            nameAST = parentAST.findFirstToken(58);
        }
        if (nameAST == null) {
            return;
        }
        int endLine = DetailASTUtil.getEndLine(detailAST);
        if (endLine + 1 != (startLineNextExpression = DetailASTUtil.getStartLine(nextSibling))) {
            return;
        }
        String name = nameAST.getText();
        if (this._isExpressionAssignsVariable(nextSibling, name)) {
            return;
        }
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSibling, 58, true);
        for (DetailAST identAST : identASTList) {
            String identName = identAST.getText();
            if (!identName.equals(name)) continue;
            this.log(startLineNextExpression, MSG_MISSING_EMPTY_LINE, new Object[]{name});
        }
    }

    private boolean _isExpressionAssignsVariable(DetailAST detailAST, String name) {
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST childAST = detailAST.getFirstChild();
        if (childAST.getType() != 80) {
            return false;
        }
        DetailAST expressionNameAST = childAST.findFirstToken(58);
        if (expressionNameAST == null) {
            return false;
        }
        String expressionName = expressionNameAST.getText();
        return expressionName.equals(name);
    }
}

