/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class UnusedParameterCheck
extends AbstractCheck {
    public static final String MSG_UNUSED_PARAMETER = "parameter.unused";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (!modifiersAST.branchContains(61)) {
            return;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        if (name.equals("readObject") || name.equals("writeObject")) {
            return;
        }
        List<String> parameterNames = DetailASTUtil.getParameterNames(detailAST);
        if (parameterNames.isEmpty()) {
            return;
        }
        DetailAST statementsAST = detailAST.findFirstToken(7);
        List<DetailAST> allIdentsAST = DetailASTUtil.getAllChildTokens(statementsAST, 58, true);
        block0: for (String parameterName : DetailASTUtil.getParameterNames(detailAST)) {
            for (DetailAST identAST : allIdentsAST) {
                if (!parameterName.equals(identAST.getText())) continue;
                continue block0;
            }
            this.log(detailAST.getLineNo(), MSG_UNUSED_PARAMETER, new Object[]{parameterName});
        }
    }
}

