/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class DetailASTUtil {
    public static final int ALL_TYPES = -1;

    public static DetailAST findTypeAST(DetailAST methodAST, String name) {
        List<DetailAST> localVariableDefASTList = DetailASTUtil.getAllChildTokens(methodAST, 10, true);
        DetailAST typeAST = DetailASTUtil._findTypeAST(localVariableDefASTList, name);
        if (typeAST != null) {
            return typeAST;
        }
        List<DetailAST> parameterDefASTList = DetailASTUtil.getParameterDefs(methodAST);
        typeAST = DetailASTUtil._findTypeAST(parameterDefASTList, name);
        if (typeAST != null) {
            return typeAST;
        }
        for (DetailAST classAST = methodAST.getParent(); classAST != null; classAST = classAST.getParent()) {
            List<DetailAST> globalVariableDefASTList = DetailASTUtil.getAllChildTokens(classAST, 10, false);
            typeAST = DetailASTUtil._findTypeAST(globalVariableDefASTList, name);
            if (typeAST == null) continue;
            return typeAST;
        }
        return null;
    }

    public static List<DetailAST> getAllChildTokens(DetailAST detailAST, int tokenType, boolean recursive) {
        return DetailASTUtil._getAllChildTokens(detailAST, tokenType, recursive, null);
    }

    public static int getEndLine(DetailAST detailAST) {
        int endLine = detailAST.getLineNo();
        for (DetailAST childAST : DetailASTUtil.getAllChildTokens(detailAST, -1, true)) {
            if (childAST.getLineNo() <= endLine) continue;
            endLine = childAST.getLineNo();
        }
        return endLine;
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String className, String methodName) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, 27, true);
        for (DetailAST methodCallAST : methodCallASTList) {
            List<DetailAST> nameASTList;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST == null || (nameASTList = DetailASTUtil.getAllChildTokens(dotAST, 58, false)).size() != 2) continue;
            DetailAST classNameAST = nameASTList.get(0);
            DetailAST methodNameAST = nameASTList.get(1);
            String methodCallClassName = classNameAST.getText();
            String methodCallMethodName = methodNameAST.getText();
            if (!methodCallClassName.equals(className) || !methodCallMethodName.equals(methodName)) continue;
            list.add(methodCallAST);
        }
        return list;
    }

    public static String getMethodName(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return null;
        }
        DetailAST dotAST = detailAST.findFirstToken(59);
        if (dotAST == null) {
            DetailAST nameAST = detailAST.findFirstToken(58);
            return nameAST.getText();
        }
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(dotAST, 58, false);
        DetailAST methodNameAST = nameASTList.get(nameASTList.size() - 1);
        return methodNameAST.getText();
    }

    public static List<DetailAST> getParameterDefs(DetailAST detailAST) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return list;
        }
        DetailAST parametersAST = detailAST.findFirstToken(20);
        return DetailASTUtil.getAllChildTokens(parametersAST, 21, false);
    }

    public static List<String> getParameterNames(DetailAST detailAST) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (DetailAST parameterDefinitionAST : DetailASTUtil.getParameterDefs(detailAST)) {
            DetailAST identAST = parameterDefinitionAST.findFirstToken(58);
            parameterNames.add(identAST.getText());
        }
        return parameterNames;
    }

    public static int getStartLine(DetailAST detailAST) {
        int startLine = detailAST.getLineNo();
        for (DetailAST childAST : DetailASTUtil.getAllChildTokens(detailAST, -1, true)) {
            if (childAST.getLineNo() >= startLine) continue;
            startLine = childAST.getLineNo();
        }
        return startLine;
    }

    public static boolean isCollection(DetailAST detailAST) {
        if (detailAST.getType() != 10) {
            return false;
        }
        DetailAST typeAST = detailAST.findFirstToken(13);
        DetailAST typeArgumentsAST = typeAST.findFirstToken(163);
        if (typeArgumentsAST == null) {
            return false;
        }
        DetailAST nameAST = typeAST.findFirstToken(58);
        String name = nameAST.getText();
        return name.matches(".*(Collection|List|Map|Set)");
    }

    private static DetailAST _findTypeAST(List<DetailAST> defASTList, String name) {
        for (DetailAST defAST : defASTList) {
            DetailAST nameAST = defAST.findFirstToken(58);
            String curName = nameAST.getText();
            if (!curName.equals(name)) continue;
            return defAST.findFirstToken(13);
        }
        return null;
    }

    private static List<DetailAST> _getAllChildTokens(DetailAST detailAST, int tokenType, boolean recursive, List<DetailAST> list) {
        if (list == null) {
            list = new ArrayList<DetailAST>();
        }
        for (DetailAST childAST = detailAST.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (tokenType == childAST.getType() || tokenType == -1) {
                list.add(childAST);
            }
            if (!recursive) continue;
            list = DetailASTUtil._getAllChildTokens(childAST, tokenType, recursive, list);
        }
        return list;
    }
}

