/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**\\*.css"};
    private final Pattern _commentPattern = Pattern.compile("/\\* -+(.+)-+ \\*/");
    private final Pattern _hexColorPattern = Pattern.compile("#([0-9a-f]+)[\\( ;,]");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = this.trimContent(content, false);
        newContent = this.fixComments(newContent);
        return this.fixHexColors(newContent);
    }

    @Override
    protected List<String> doGetFileNames() {
        String[] excludes = new String[]{"**\\.ivy\\**", "**\\.sass-cache\\**", "**\\__MACOSX\\**", "**\\aui_deprecated.css", "**\\expected\\**", "**\\js\\aui\\**", "**\\js\\editor\\**", "**\\js\\misc\\**", "**\\VAADIN\\**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    protected String fixComments(String content) {
        Matcher matcher = this._commentPattern.matcher(content);
        while (matcher.find()) {
            String[] words = StringUtil.split(matcher.group(1), ' ');
            for (int i = 1; i < words.length; ++i) {
                String word;
                String previousWord = words[i - 1];
                if (previousWord.endsWith(".") || previousWord.equals("/") || (word = words[i]).length() <= 1 || !Character.isUpperCase(word.charAt(0)) || !StringUtil.isLowerCase(word.substring(1))) continue;
                content = StringUtil.replaceFirst(content, word, StringUtil.toLowerCase(word), matcher.start());
            }
        }
        return content;
    }

    protected String fixHexColors(String content) {
        Matcher matcher = this._hexColorPattern.matcher(content);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            if (Validator.isNumber(hexColor) || hexColor.length() < 3) continue;
            content = StringUtil.replace(content, hexColor, StringUtil.toUpperCase(hexColor));
        }
        return content;
    }
}

