/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.ImportPackage;
import com.liferay.source.formatter.ImportsFormatter;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaImportsFormatter
extends ImportsFormatter {
    private static final Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);
    private static final Pattern _javaImportPattern = Pattern.compile("import( static)? ([^;]+);");

    public static String getImports(String content) {
        Matcher matcher = _importsPattern.matcher(content);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String stripJavaImports(String content, String packageDir, String className) throws IOException {
        String imports = JavaImportsFormatter.getImports(content);
        if (Validator.isNull(imports)) {
            return content;
        }
        Set<String> classes = ClassUtil.getClasses(new UnsyncStringReader(content), className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String importClass;
            int y;
            String importPackage;
            int x = line.indexOf("import ");
            if (x == -1 || (importPackage = line.substring(x + 7, y = line.lastIndexOf("."))).equals(packageDir) || importPackage.equals("java.lang") || !(importClass = line.substring(y + 1, line.length() - 1)).equals("*") && !classes.contains(importClass)) continue;
            sb.append(line);
            sb.append("\n");
        }
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        String newImports = importsFormatter.format(sb.toString());
        if (!imports.equals(newImports)) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        Matcher matcher = _javaImportPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        boolean isStatic = false;
        if (Validator.isNotNull(matcher.group(1))) {
            isStatic = true;
        }
        String importString = matcher.group(2);
        return new ImportPackage(importString, isStatic, line);
    }
}

