/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ProviderType
public class FriendlyURLResolverRegistryUtil {
    private static final Map<String, FriendlyURLResolver> _friendlyURLResolvers = new ConcurrentHashMap<String, FriendlyURLResolver>();
    private static final ServiceRegistrationMap<FriendlyURLResolver> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private static final ServiceTracker<FriendlyURLResolver, FriendlyURLResolver> _serviceTracker;

    public static FriendlyURLResolver getFriendlyURLResolver(String urlSeparator) {
        return _friendlyURLResolvers.get(urlSeparator);
    }

    @Deprecated
    public static List<FriendlyURLResolver> getFriendlyURLResolvers() {
        return ListUtil.fromMapValues(_friendlyURLResolvers);
    }

    public static Collection<FriendlyURLResolver> getFriendlyURLResolversAsCollection() {
        return _friendlyURLResolvers.values();
    }

    public static String[] getURLSeparators() {
        Set<String> urlSeparators = _friendlyURLResolvers.keySet();
        return urlSeparators.toArray(new String[urlSeparators.size()]);
    }

    public static void register(FriendlyURLResolver friendlyURLResolver) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(FriendlyURLResolver.class, (Object)friendlyURLResolver);
        _serviceRegistrations.put((Object)friendlyURLResolver, (Object)serviceRegistration);
    }

    public static void unregister(FriendlyURLResolver friendlyURLResolver) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)_serviceRegistrations.remove((Object)friendlyURLResolver);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(FriendlyURLResolver.class, (ServiceTrackerCustomizer)new FriendlyURLResolverServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class FriendlyURLResolverServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FriendlyURLResolver, FriendlyURLResolver> {
        private FriendlyURLResolverServiceTrackerCustomizer() {
        }

        public FriendlyURLResolver addingService(ServiceReference<FriendlyURLResolver> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)registry.getService(serviceReference);
            _friendlyURLResolvers.put(friendlyURLResolver.getURLSeparator(), friendlyURLResolver);
            return friendlyURLResolver;
        }

        public void modifiedService(ServiceReference<FriendlyURLResolver> serviceReference, FriendlyURLResolver friendlyURLResolver) {
        }

        public void removedService(ServiceReference<FriendlyURLResolver> serviceReference, FriendlyURLResolver friendlyURLResolver) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _friendlyURLResolvers.remove(friendlyURLResolver.getURLSeparator());
        }
    }
}

