/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.StringUtil;

public class PrincipalException
extends PortalException {
    private static final Class<?>[] _NESTED_CLASSES = new Class[]{PrincipalException.class, MustBeAuthenticated.class, MustBeCompanyAdmin.class, MustBeEnabled.class, MustBeInvokedUsingPost.class, MustBeOmniadmin.class, MustBePortletStrutsPath.class, MustHavePermission.class};

    public static Class<?>[] getNestedClasses() {
        return _NESTED_CLASSES;
    }

    public PrincipalException() {
    }

    public PrincipalException(String msg) {
        super(msg);
    }

    public PrincipalException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public PrincipalException(Throwable cause) {
        super(cause);
    }

    public static class MustHavePermission
    extends PrincipalException {
        public final String[] actionId;
        public final long resourceId;
        public final String resourceName;
        public final long userId;

        public MustHavePermission(long userId, String ... actionIds) {
            super(String.format("User %s must have permission to perform action %s", userId, StringUtil.merge(actionIds, ",")));
            this.userId = userId;
            this.actionId = actionIds;
            this.resourceId = 0L;
            this.resourceName = null;
        }

        public MustHavePermission(long userId, String resourceName, long resourceId, String ... actionIds) {
            super(String.format("User %s must have %s permission for %s %s", userId, StringUtil.merge(actionIds, ","), resourceName, resourceId));
            this.userId = userId;
            this.resourceName = resourceName;
            this.resourceId = resourceId;
            this.actionId = actionIds;
        }

        public MustHavePermission(PermissionChecker permissionChecker, String ... actionIds) {
            this(permissionChecker.getUserId(), actionIds);
        }

        public MustHavePermission(PermissionChecker permissionChecker, String resourceName, long resourceId, String ... actionIds) {
            this(permissionChecker.getUserId(), resourceName, resourceId, actionIds);
        }
    }

    public static class MustBePortletStrutsPath
    extends PrincipalException {
        public final String portletId;
        public final String strutsPath;

        public MustBePortletStrutsPath(String strutsPath, String portletId) {
            super(String.format("Struts path %s must be struts path of portlet %s", strutsPath, portletId));
            this.strutsPath = strutsPath;
            this.portletId = portletId;
        }
    }

    public static class MustBeOmniadmin
    extends PrincipalException {
        public final long userId;

        public MustBeOmniadmin(long userId) {
            super(String.format("User %s must be a universal administrator to perform the action", userId));
            this.userId = userId;
        }

        public MustBeOmniadmin(PermissionChecker permissionChecker) {
            this(permissionChecker.getUserId());
        }
    }

    public static class MustBeInvokedUsingPost
    extends PrincipalException {
        public final String url;

        public MustBeInvokedUsingPost(String url) {
            super(String.format("URL %s must be invoked using POST", url));
            this.url = url;
        }
    }

    public static class MustBeEnabled
    extends PrincipalException {
        public final long companyId;
        public final String[] resourceName;

        public MustBeEnabled(long companyId, String ... resourceName) {
            super(String.format("%s must be enabled for company %s", StringUtil.merge(resourceName, ","), companyId));
            this.companyId = companyId;
            this.resourceName = resourceName;
        }
    }

    public static class MustBeCompanyAdmin
    extends PrincipalException {
        public final long userId;

        public MustBeCompanyAdmin(long userId) {
            super(String.format("User %s must be the company administrator to perform the action", userId));
            this.userId = userId;
        }

        public MustBeCompanyAdmin(PermissionChecker permissionChecker) {
            this(permissionChecker.getUserId());
        }
    }

    public static class MustBeAuthenticated
    extends PrincipalException {
        public final String login;

        public MustBeAuthenticated(long userId) {
            this(String.valueOf(userId));
        }

        public MustBeAuthenticated(String login) {
            super(String.format("User %s must be authenticated", login));
            this.login = login;
        }
    }
}

