/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.ui;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorCategoryUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorEntry;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class FormNavigatorEntryUtil {
    private static final FormNavigatorEntryUtil _instance = new FormNavigatorEntryUtil();
    private final ServiceTrackerMap<String, List<FormNavigatorEntry>> _formNavigatorEntries = ServiceTrackerCollections.openMultiValueMap(FormNavigatorEntry.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, FormNavigatorEntry>(){

        public void map(ServiceReference<FormNavigatorEntry> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            FormNavigatorEntry formNavigatorEntry = (FormNavigatorEntry)registry.getService(serviceReference);
            emitter.emit((Object)FormNavigatorEntryUtil._getKey(formNavigatorEntry.getFormNavigatorId(), formNavigatorEntry.getCategoryKey()));
            registry.ungetService(serviceReference);
        }
    }, new PropertyServiceReferenceComparator("form.navigator.entry.order"));

    public static <T> List<FormNavigatorEntry<T>> getFormNavigatorEntries(String formNavigatorId, String categoryKey, User user, T formModelBean) {
        List formNavigatorEntries = (List)FormNavigatorEntryUtil._instance._formNavigatorEntries.getService((Object)FormNavigatorEntryUtil._getKey(formNavigatorId, categoryKey));
        return FormNavigatorEntryUtil.filterVisibleFormNavigatorEntries(formNavigatorEntries, user, formModelBean);
    }

    public static <T> List<FormNavigatorEntry<T>> getFormNavigatorEntries(String formNavigatorId, User user, T formModelBean) {
        String[] categoryKeys;
        ArrayList<FormNavigatorEntry<T>> formNavigatorEntries = new ArrayList<FormNavigatorEntry<T>>();
        for (String categoryKey : categoryKeys = FormNavigatorCategoryUtil.getKeys(formNavigatorId)) {
            List curFormNavigatorEntries = (List)FormNavigatorEntryUtil._instance._formNavigatorEntries.getService((Object)FormNavigatorEntryUtil._getKey(formNavigatorId, categoryKey));
            if (curFormNavigatorEntries == null) continue;
            formNavigatorEntries.addAll(curFormNavigatorEntries);
        }
        return FormNavigatorEntryUtil.filterVisibleFormNavigatorEntries(formNavigatorEntries, user, formModelBean);
    }

    public static <T> String[] getKeys(String formNavigatorId, String categoryKey, User user, T formModelBean) {
        ArrayList<String> keys = new ArrayList<String>();
        List<FormNavigatorEntry<T>> formNavigatorEntries = FormNavigatorEntryUtil.getFormNavigatorEntries(formNavigatorId, categoryKey, user, formModelBean);
        for (FormNavigatorEntry<T> formNavigatorEntry : formNavigatorEntries) {
            String key = formNavigatorEntry.getKey();
            if (!Validator.isNotNull(key)) continue;
            keys.add(key);
        }
        return keys.toArray(new String[keys.size()]);
    }

    public static <T> String[] getLabels(String formNavigatorId, String categoryKey, User user, T formModelBean, Locale locale) {
        ArrayList<String> labels = new ArrayList<String>();
        List<FormNavigatorEntry<T>> formNavigatorEntries = FormNavigatorEntryUtil.getFormNavigatorEntries(formNavigatorId, categoryKey, user, formModelBean);
        for (FormNavigatorEntry<T> formNavigatorEntry : formNavigatorEntries) {
            String label = formNavigatorEntry.getLabel(locale);
            if (!Validator.isNotNull(label)) continue;
            labels.add(label);
        }
        return labels.toArray(new String[labels.size()]);
    }

    protected static <T> List<FormNavigatorEntry<T>> filterVisibleFormNavigatorEntries(List<FormNavigatorEntry<T>> formNavigatorEntries, User user, T formModelBean) {
        ArrayList<FormNavigatorEntry<T>> filterFormNavigatorEntries = new ArrayList<FormNavigatorEntry<T>>();
        if (ListUtil.isEmpty(formNavigatorEntries)) {
            return filterFormNavigatorEntries;
        }
        for (FormNavigatorEntry<T> formNavigatorEntry : formNavigatorEntries) {
            if (!formNavigatorEntry.isVisible(user, formModelBean)) continue;
            filterFormNavigatorEntries.add(formNavigatorEntry);
        }
        return filterFormNavigatorEntries;
    }

    private static String _getKey(String formNavigatorId, String categoryKey) {
        return formNavigatorId + "." + categoryKey;
    }

    private FormNavigatorEntryUtil() {
    }

    private class PropertyServiceReferenceComparator<T>
    implements Comparator<ServiceReference<T>>,
    Serializable {
        private final String _propertyKey;

        public PropertyServiceReferenceComparator(String propertyKey) {
            this._propertyKey = propertyKey;
        }

        @Override
        public int compare(ServiceReference<T> serviceReference1, ServiceReference<T> serviceReference2) {
            if (serviceReference1 == null) {
                if (serviceReference2 == null) {
                    return 0;
                }
                return 1;
            }
            if (serviceReference2 == null) {
                return -1;
            }
            Object propertyValue1 = serviceReference1.getProperty(this._propertyKey);
            Object propertyValue2 = serviceReference2.getProperty(this._propertyKey);
            if (propertyValue1 == null) {
                if (propertyValue2 == null) {
                    return 0;
                }
                return 1;
            }
            if (propertyValue2 == null) {
                return -1;
            }
            if (!(propertyValue2 instanceof Comparable)) {
                return serviceReference2.compareTo(serviceReference1);
            }
            Comparable propertyValueComparable2 = (Comparable)propertyValue2;
            return propertyValueComparable2.compareTo(propertyValue1);
        }
    }
}

