/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.settings.BaseSettings;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.LocationVariableResolver;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.GetterUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ConfigurationBeanSettings
extends BaseSettings
implements Settings {
    private final Object _configurationBean;
    private final LocationVariableResolver _locationVariableResolver;

    public ConfigurationBeanSettings(LocationVariableResolver locationVariableResolver, Object configurationBean, Settings parentSettings) {
        super(parentSettings);
        if (locationVariableResolver == null) {
            throw new NullPointerException("Location variable resolver is null");
        }
        if (configurationBean == null) {
            throw new NullPointerException("Configuration bean is null");
        }
        this._locationVariableResolver = locationVariableResolver;
        this._configurationBean = configurationBean;
    }

    @Override
    protected String doGetValue(String key) {
        Object object = this._getProperty(key);
        if (object == null) {
            return null;
        }
        String value = null;
        value = object instanceof LocalizedValuesMap ? ((LocalizedValuesMap)object).getDefaultValue() : object.toString();
        if (this._locationVariableResolver.isLocationVariable(value)) {
            return this._locationVariableResolver.resolve(value);
        }
        return value;
    }

    @Override
    protected String[] doGetValues(String key) {
        Object object = this._getProperty(key);
        if (object == null) {
            return null;
        }
        return GetterUtil.getStringValues(object);
    }

    private Object _getProperty(String key) {
        Class<?> clazz = this._configurationBean.getClass();
        try {
            Method method = clazz.getMethod(key, new Class[0]);
            return method.invoke(this._configurationBean, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (InvocationTargetException ite) {
            throw new SystemException("Unable to read property " + key, ite);
        }
        catch (IllegalAccessException iae) {
            throw new SystemException("Unable to read property " + key, iae);
        }
    }
}

