/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.theme;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class NavItem
implements Serializable {
    private List<NavItem> _browsableChildren;
    private List<NavItem> _children;
    private final Map<String, Object> _contextObjects;
    private final Layout _layout;
    private final HttpServletRequest _request;
    private final ThemeDisplay _themeDisplay;

    public static List<NavItem> fromLayouts(HttpServletRequest request, List<Layout> layouts, Map<String, Object> contextObjects) {
        if (layouts == null) {
            return null;
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(layouts.size());
        for (Layout layout : layouts) {
            navItems.add(new NavItem(request, layout, contextObjects));
        }
        return navItems;
    }

    public NavItem(HttpServletRequest request, Layout layout, Map<String, Object> contextObjects) {
        this._request = request;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._layout = layout;
        this._contextObjects = contextObjects;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NavItem)) {
            return false;
        }
        NavItem navItem = (NavItem)obj;
        return this.getLayoutId() == navItem.getLayoutId();
    }

    public List<NavItem> getBrowsableChildren() throws Exception {
        if (this._browsableChildren == null) {
            List<NavItem> children = this.getChildren();
            this._browsableChildren = ListUtil.filter(children, new PredicateFilter<NavItem>(){

                @Override
                public boolean filter(NavItem navItem) {
                    return navItem.isBrowsable();
                }
            });
        }
        return this._browsableChildren;
    }

    public List<NavItem> getChildren() throws Exception {
        if (this._children == null) {
            List<Layout> layouts = this._layout.getChildren(this._themeDisplay.getPermissionChecker());
            this._children = NavItem.fromLayouts(this._request, layouts, this._contextObjects);
        }
        return this._children;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public long getLayoutId() {
        return this._layout.getLayoutId();
    }

    public String getName() {
        return HtmlUtil.escape(this.getUnescapedName());
    }

    public String getRegularFullURL() throws Exception {
        String portalURL = PortalUtil.getPortalURL(this._request);
        String regularURL = this.getRegularURL();
        if (StringUtil.startsWith(regularURL, portalURL) || Validator.isUrl(regularURL)) {
            return regularURL;
        }
        return portalURL.concat(regularURL);
    }

    public String getRegularURL() throws Exception {
        return this._layout.getRegularURL(this._request);
    }

    public String getResetLayoutURL() throws Exception {
        return this._layout.getResetLayoutURL(this._request);
    }

    public String getResetMaxStateURL() throws Exception {
        return this._layout.getResetMaxStateURL(this._request);
    }

    public String getTarget() {
        return this._layout.getTarget();
    }

    public String getTitle() {
        return this._layout.getTitle(this._themeDisplay.getLocale());
    }

    public String getUnescapedName() {
        return this._layout.getName(this._themeDisplay.getLocale());
    }

    public String getURL() throws Exception {
        return HtmlUtil.escapeHREF(this.getRegularFullURL());
    }

    public boolean hasBrowsableChildren() throws Exception {
        List<NavItem> browsableChildren = this.getBrowsableChildren();
        return !browsableChildren.isEmpty();
    }

    public boolean hasChildren() throws Exception {
        List<NavItem> children = this.getChildren();
        return !children.isEmpty();
    }

    public int hashCode() {
        return this._layout.hashCode();
    }

    public String iconURL() throws Exception {
        if (this._layout == null || !this._layout.isIconImage()) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(this._themeDisplay.getPathImage());
        sb.append("/layout_icon?img_id");
        sb.append(this._layout.getIconImageId());
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken(this._layout.getIconImageId()));
        return sb.toString();
    }

    public boolean isBrowsable() {
        LayoutType layoutType = this._layout.getLayoutType();
        return layoutType.isBrowsable();
    }

    public boolean isChildSelected() throws PortalException {
        return this._layout.isChildSelected(this._themeDisplay.isTilesSelectable(), this._themeDisplay.getLayout());
    }

    public boolean isInNavigation(List<NavItem> navItems) {
        if (navItems == null) {
            return false;
        }
        return navItems.contains(this);
    }

    public boolean isSelected() throws Exception {
        return this._layout.isSelected(this._themeDisplay.isTilesSelectable(), this._themeDisplay.getLayout(), this._themeDisplay.getLayout().getAncestorPlid());
    }
}

