/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.InvalidJavaTermException;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.JavaTerm;
import com.liferay.source.formatter.JavaTermComparator;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.ThreadSafeClassLibrary;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClass {
    private static final String _ACCESS_MODIFIER_PRIVATE = "private";
    private static final String _ACCESS_MODIFIER_PROTECTED = "protected";
    private static final String _ACCESS_MODIFIER_PUBLIC = "public";
    private static final String _ACCESS_MODIFIER_UNKNOWN = "unknown";
    private static final String[] _ACCESS_MODIFIERS = new String[]{"private", "protected", "public"};
    private static final Map<String, String> _defaultPrimitiveValues = MapUtil.fromArray("boolean", "false", "char", "'\\\\0'", "byte", "0", "double", "0\\.0", "float", "0\\.0", "int", "0", "long", "0", "short", "0");
    private final String _absolutePath;
    private final Pattern _booleanPattern = Pattern.compile("\n(\t+)boolean (\\w+) =(.*?);\n", 32);
    private String _classContent;
    private final Pattern _classPattern = Pattern.compile("(private|protected|public) ((abstract|static) )*(class|enum|interface) ([\\s\\S]*?) \\{\n");
    private String _cleanUpMethodContent;
    private int _constructorCount;
    private final String _content;
    private String _customSQLContent;
    private final Pattern _enumTypePattern = Pattern.compile("\t[A-Z0-9]+[ _,;\\(\n]");
    private final File _file;
    private final String _fileName;
    private final String _indent;
    private final List<JavaClass> _innerClasses = new ArrayList<JavaClass>();
    private final JavaSourceProcessor _javaSourceProcessor;
    private Set<JavaTerm> _javaTerms;
    private final Pattern _lineBreakPattern = Pattern.compile("\n(.*)\\(\n((.+,\n)*.*\\)) \\+\n");
    private final int _lineCount;
    private final Pattern _missingEmptyLinePattern = Pattern.compile("[^\n{](\n)\t*\\}\n*$");
    private final String _name;
    private final JavaClass _outerClass;
    private String _packagePath;
    private final Pattern _relationalOperatorPattern = Pattern.compile(".* (==|!=|<|>|>=|<=)[ \n].*");
    private final Pattern _returnPattern = Pattern.compile("\n(\t+)return (.*?);\n", 32);

    public JavaClass(String name, String packagePath, File file, String fileName, String absolutePath, String content, String classContent, int lineCount, String indent, JavaClass outerClass, JavaSourceProcessor javaSourceProcessor) throws Exception {
        this._name = name;
        this._packagePath = packagePath;
        this._file = file;
        this._fileName = fileName;
        this._absolutePath = absolutePath;
        this._content = content;
        this._classContent = classContent;
        this._lineCount = lineCount;
        this._indent = indent;
        this._outerClass = outerClass;
        this._javaSourceProcessor = javaSourceProcessor;
    }

    public String formatJavaTerms(Set<String> annotationsExclusions, Set<String> immutableFieldTypes, String checkJavaFieldTypesExcludesProperty, String javaTermSortExcludesProperty, String testAnnotationsExcludesProperty) throws Exception {
        Set<Object> javaTerms = Collections.emptySet();
        try {
            javaTerms = this.getJavaTerms();
        }
        catch (InvalidJavaTermException ijte) {
            if (!this._javaSourceProcessor.isExcludedPath(javaTermSortExcludesProperty, this._absolutePath)) {
                this._javaSourceProcessor.processMessage(this._fileName, "Parsing error", ijte.getLineCount());
            }
            return this._classContent;
        }
        if (javaTerms.isEmpty()) {
            return this._classContent;
        }
        String originalContent = this._classContent;
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (javaTerm.isConstructor()) {
                this.checkConstructor(javaTerm);
            }
            if (javaTerm.isClass()) {
                this._formatMissingLineBreak(javaTerm);
            }
            this._formatBooleanStatements(javaTerm);
            this._formatReturnStatements(javaTerm);
            if (javaTerm.isMethod() || javaTerm.isConstructor()) {
                this.checkLineBreak(javaTerm);
            }
            if (this._fileName.endsWith("Comparator.java") && javaTerm.isMethod()) {
                this.checkLocalSensitiveComparison(javaTerm);
            }
            if (this._fileName.endsWith("LocalServiceImpl.java") && javaTerm.hasAnnotation("Indexable") && !javaTerm.hasReturnType()) {
                this._javaSourceProcessor.processMessage(this._fileName, "Missing return type for method with @Indexable", javaTerm.getLineCount());
            }
            if (this._name.endsWith("ServiceImpl")) {
                this.checkServiceImpl(javaTerm);
            }
            if (!this._javaSourceProcessor.isExcludedPath(checkJavaFieldTypesExcludesProperty, this._absolutePath)) {
                this.checkJavaFieldType(javaTerms, javaTerm, annotationsExclusions, immutableFieldTypes);
            }
            if (!originalContent.equals(this._classContent)) {
                return this._classContent;
            }
            this.sortJavaTerms(previousJavaTerm, javaTerm, javaTermSortExcludesProperty);
            this.fixTabsAndIncorrectEmptyLines(javaTerm);
            this.formatAnnotations(javaTerm, testAnnotationsExcludesProperty);
            if (!originalContent.equals(this._classContent)) {
                return this._classContent;
            }
            previousJavaTerm = javaTerm;
        }
        for (JavaClass innerClass : this._innerClasses) {
            String newInnerClassContent;
            String innerClassContent = innerClass.getContent();
            if (innerClassContent.equals(newInnerClassContent = innerClass.formatJavaTerms(annotationsExclusions, immutableFieldTypes, checkJavaFieldTypesExcludesProperty, javaTermSortExcludesProperty, testAnnotationsExcludesProperty))) continue;
            this._classContent = StringUtil.replace(this._classContent, innerClassContent, newInnerClassContent);
            return this._classContent;
        }
        this.fixJavaTermsDividers(javaTerms, javaTermSortExcludesProperty);
        return this._classContent;
    }

    public String getClassName() {
        if (this._outerClass != null) {
            return this._outerClass.getClassName() + "$" + this._name;
        }
        return this._packagePath + "." + this._name;
    }

    public String getContent() {
        return this._classContent;
    }

    protected void checkAnnotationForMethod(JavaTerm javaTerm, String annotation, String requiredMethodNameRegex, int requiredMethodType) {
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        if (javaTerm.hasAnnotation(annotation)) {
            if (!matcher.find()) {
                this._javaSourceProcessor.processMessage(this._fileName, "Incorrect method name '" + methodName + "', see LPS-36303");
            } else if (javaTerm.getType() != requiredMethodType) {
                this._javaSourceProcessor.processMessage(this._fileName, "Incorrect method type for '" + methodName + "', see LPS-36303");
            }
        } else if (matcher.find() && !javaTerm.hasAnnotation("Override")) {
            this._javaSourceProcessor.processMessage(this._fileName, "Annotation @" + annotation + " required for '" + methodName + "', see LPS-36303");
        }
    }

    protected void checkCleanUpMethodValue(String cleanUpMethodContent, JavaTerm javaTerm, String defaultValue) {
        int x;
        String javaTermName = javaTerm.getName();
        if (!cleanUpMethodContent.contains(javaTermName + " =")) {
            return;
        }
        Pattern pattern = Pattern.compile(javaTermName + " =\\s+[a-z]\\w*\\.");
        Matcher matcher = pattern.matcher(cleanUpMethodContent);
        if (matcher.find()) {
            return;
        }
        String javaTermContent = javaTerm.getContent();
        String setVariableCommand = javaTermContent.substring(x = javaTermContent.indexOf(javaTermName));
        if (!setVariableCommand.contains(" =")) {
            setVariableCommand = StringUtil.replaceLast(setVariableCommand, ';', " = " + defaultValue + ";");
        }
        setVariableCommand = StringUtil.replace(setVariableCommand, new String[]{"\t", "\n"}, new String[]{"", " "});
        String setVariableCommandRegex = StringUtil.replace(setVariableCommand, new String[]{")", "(", " ", "0\\.0"}, new String[]{"\\)", "\\(", "\\s*", "0(\\.0)?"});
        pattern = Pattern.compile(setVariableCommandRegex);
        matcher = pattern.matcher(cleanUpMethodContent);
        if (!matcher.find()) {
            this._javaSourceProcessor.processMessage(this._fileName, "Initial value differs from value in cleanUp method, see LPS-66242", javaTerm.getLineCount());
        }
    }

    protected void checkConstructor(JavaTerm javaTerm) throws Exception {
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains("\tsuper();")) {
            String newJavaTermContent = StringUtil.replace(javaTermContent, "\tsuper();", "");
            this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
            return;
        }
        if (!ListUtil.isEmpty(javaTerm.getParameterTypes())) {
            this.checkConstructorParameterOrder(javaTerm);
            return;
        }
        if (this._packagePath == null || this._constructorCount > 1 || !javaTermContent.contains("{\n" + this._indent + "}\n")) {
            return;
        }
        String accessModifier = this.getAccessModifier();
        if (javaTerm.isPrivate() && !accessModifier.equals(_ACCESS_MODIFIER_PRIVATE) || javaTerm.isProtected() && !accessModifier.equals(_ACCESS_MODIFIER_PRIVATE) && !accessModifier.equals(_ACCESS_MODIFIER_PROTECTED)) {
            return;
        }
        Pattern pattern = Pattern.compile("class " + this._name + "[ \t\n]+extends");
        Matcher matcher = pattern.matcher(this._classContent);
        if (!matcher.find()) {
            return;
        }
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder((DocletTagFactory)new DefaultDocletTagFactory(), (ClassLibrary)new ThreadSafeClassLibrary());
        javaDocBuilder.addSource(this._file);
        com.thoughtworks.qdox.model.JavaClass javaClass = javaDocBuilder.getClassByName(this.getClassName());
        com.thoughtworks.qdox.model.JavaClass superJavaClass = javaClass.getSuperJavaClass();
        JavaMethod superJavaClassConstructor = superJavaClass.getMethodBySignature(superJavaClass.getName(), null);
        if (superJavaClassConstructor != null && ArrayUtil.isEmpty(superJavaClassConstructor.getExceptions())) {
            this._classContent = StringUtil.replace(this._classContent, javaTermContent, "");
        }
    }

    protected void checkConstructorParameterOrder(JavaTerm javaTerm) {
        String previousParameterName = null;
        int previousPos = -1;
        for (String parameterName : javaTerm.getParameterNames()) {
            String beforeParameter;
            Pattern pattern = Pattern.compile("\\{\n([\\s\\S]*?)(_" + parameterName + " =[ \t\n]+" + parameterName + ";)");
            Matcher matcher = pattern.matcher(javaTerm.getContent());
            if (!matcher.find() || (beforeParameter = matcher.group(1)).contains(parameterName + " =")) continue;
            int pos = matcher.start(2);
            if (previousPos < pos) {
                previousParameterName = parameterName;
                previousPos = pos;
                continue;
            }
            StringBundler sb = new StringBundler(9);
            sb.append("'_");
            sb.append(previousParameterName);
            sb.append(" = ");
            sb.append(previousParameterName);
            sb.append(";' should come before '_");
            sb.append(parameterName);
            sb.append(" = ");
            sb.append(parameterName);
            sb.append(";' to match order of constructor parameters");
            this._javaSourceProcessor.processMessage(this._fileName, sb.toString(), javaTerm.getLineCount() - 1 + this._javaSourceProcessor.getLineCount(javaTerm.getContent(), matcher.start(2)));
            return;
        }
    }

    protected void checkFinalableFieldType(JavaTerm javaTerm, Set<String> annotationsExclusions, String modifierDefinition) throws Exception {
        for (String annotation : annotationsExclusions) {
            if (!javaTerm.hasAnnotation(annotation)) continue;
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("(((\\+\\+( ?))|(--( ?)))");
        sb.append(javaTerm.getName());
        sb.append(")|((\\b|\\.)");
        sb.append(javaTerm.getName());
        sb.append("((( )((=)|(\\+=)|(-=)|(\\*=)|(/=)|(%=)))");
        sb.append("|(\\+\\+)|(--)|(( )((\\|=)|(&=)|(^=)))))");
        Pattern pattern = Pattern.compile(sb.toString());
        if (!this.isFinalableField(javaTerm, this._name, pattern, true)) {
            return;
        }
        String javaTermContent = javaTerm.getContent();
        String newJavaTermContent = StringUtil.replaceFirst(javaTermContent, modifierDefinition, modifierDefinition + " final");
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    protected void checkJavaFieldType(Set<JavaTerm> javaTerms, JavaTerm javaTerm, Set<String> annotationsExclusions, Set<String> immutableFieldTypes) throws Exception {
        String javaTermContent;
        block15: {
            block14: {
                block13: {
                    if (JavaSourceProcessor.portalSource) break block13;
                    if (!JavaSourceProcessor.subrepository) break block14;
                }
                if (javaTerm.isVariable()) break block15;
            }
            return;
        }
        String javaTermName = javaTerm.getName();
        Pattern pattern = Pattern.compile("\t(private|protected|public)\\s+(((final|static|transient|volatile)( |\n))*)([\\s\\S]*?)" + javaTermName);
        Matcher matcher = pattern.matcher(javaTermContent = javaTerm.getContent());
        if (!matcher.find()) {
            return;
        }
        String modifierDefinition = StringUtil.trim(javaTermContent.substring(matcher.start(1), matcher.start(6)));
        boolean isFinal = modifierDefinition.contains("final");
        String javaFieldType = StringUtil.trim(matcher.group(6));
        if (!(isFinal || javaTerm.isPublic() || this._fileName.endsWith("ObjectGraphUtilTest.java"))) {
            Pattern isDefaultValuePattern;
            String defaultValue = null;
            defaultValue = StringUtil.isLowerCase(javaFieldType) ? _defaultPrimitiveValues.get(javaFieldType) : "null";
            if (defaultValue != null && (matcher = (isDefaultValuePattern = Pattern.compile(" =\\s+" + defaultValue + ";(\\s+)$")).matcher(javaTermContent)).find()) {
                this._classContent = StringUtil.replace(this._classContent, javaTermContent, matcher.replaceFirst(";$1"));
            }
            if (this._fileName.endsWith("Tag.java")) {
                this.checkCleanUpMethodValue(this.getCleanUpMethodContent(javaTerms), javaTerm, defaultValue);
            }
        }
        if (!javaTerm.isPrivate()) {
            return;
        }
        if (isFinal) {
            if (!modifierDefinition.contains("static") && immutableFieldTypes.contains(javaFieldType)) {
                this.checkStaticableFieldType(javaTerm.getContent());
            }
        } else if (!modifierDefinition.contains("volatile")) {
            this.checkFinalableFieldType(javaTerm, annotationsExclusions, modifierDefinition);
        }
    }

    protected void checkLineBreak(JavaTerm javaTerm) {
        Matcher matcher = this._lineBreakPattern.matcher(javaTerm.getContent());
        while (matcher.find()) {
            if (this._javaSourceProcessor.getLevel(matcher.group(2)) >= 0) continue;
            int lineCount = javaTerm.getLineCount() + this._javaSourceProcessor.getLineCount(javaTerm.getContent(), matcher.end(1));
            this._javaSourceProcessor.processMessage(this._fileName, "Create a new var for '" + StringUtil.trim(matcher.group(1)) + "' for better readability", lineCount);
        }
    }

    protected void checkLocalSensitiveComparison(JavaTerm javaTerm) {
        String javaTermName = javaTerm.getName();
        if (!javaTermName.equals("compare")) {
            return;
        }
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains("_locale") && javaTermContent.contains(".compareTo") && !javaTermContent.contains("Collator")) {
            this._javaSourceProcessor.processMessage(this._fileName, "Use Collator for locale-sensitive String comparison, see LPS-65690");
        }
    }

    protected void checkServiceImpl(JavaTerm javaTerm) {
        String superMethodCall;
        String javaTermName = javaTerm.getName();
        if (!javaTermName.equals("afterPropertiesSet") && !javaTermName.equals("destroy") || !javaTerm.hasAnnotation("Override")) {
            return;
        }
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains(superMethodCall = "super." + javaTermName + "();")) {
            return;
        }
        String newJavaTermContent = StringUtil.replaceFirst(javaTermContent, "{\n", "{\n" + javaTerm.getIndent() + "\t" + superMethodCall + "\n\n");
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    protected void checkStaticableFieldType(String javaTermContent) {
        if (!javaTermContent.contains("=")) {
            return;
        }
        String newJavaTermContent = StringUtil.replaceFirst(javaTermContent, "private final", "private static final");
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    protected void checkTestAnnotations(JavaTerm javaTerm) {
        int methodType = javaTerm.getType();
        if (methodType != 5 && methodType != 3) {
            return;
        }
        this.checkAnnotationForMethod(javaTerm, "After", "\\btearDown(?!Class)", 5);
        this.checkAnnotationForMethod(javaTerm, "AfterClass", "\\btearDownClass", 3);
        this.checkAnnotationForMethod(javaTerm, "Before", "\\bsetUp(?!Class)", 5);
        this.checkAnnotationForMethod(javaTerm, "BeforeClass", "\\bsetUpClass", 3);
        this.checkAnnotationForMethod(javaTerm, "Test", "^.*test", 5);
    }

    protected boolean combineStaticBlocks(List<JavaTerm> staticBlocks) {
        for (int i = 0; i < staticBlocks.size(); ++i) {
            JavaTerm staticBlock1 = staticBlocks.get(i);
            for (int j = i + 1; j < staticBlocks.size(); ++j) {
                JavaTerm staticBlock2 = staticBlocks.get(j);
                if (staticBlock1.getType() != staticBlock2.getType()) continue;
                this._classContent = StringUtil.replaceFirst(this._classContent, staticBlock2.getContent(), "");
                this._classContent = StringUtil.replaceFirst(this._classContent, staticBlock1.getContent(), this.getCombinedStaticBlocks(staticBlock1.getContent(), staticBlock2.getContent()));
                return true;
            }
        }
        return false;
    }

    protected void fixJavaTermsDividers(Set<JavaTerm> javaTerms, String javaTermSortExcludesProperty) {
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermContent = javaTerm.getContent();
            if (javaTermContent.startsWith(this._indent + "//")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermContent = previousJavaTerm.getContent();
            if (previousJavaTermContent.startsWith(this._indent + "//")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermName = javaTerm.getName();
            if (this._javaSourceProcessor.isExcludedPath(javaTermSortExcludesProperty, this._absolutePath, javaTerm.getLineCount(), javaTermName)) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermName = previousJavaTerm.getName();
            boolean requiresEmptyLine = false;
            if (previousJavaTerm.getType() != javaTerm.getType()) {
                requiresEmptyLine = true;
            } else if (!javaTerm.isVariable()) {
                requiresEmptyLine = true;
            } else if (StringUtil.isUpperCase(javaTermName) && !StringUtil.isLowerCase(javaTermName) || StringUtil.isUpperCase(previousJavaTermName) && !StringUtil.isLowerCase(previousJavaTermName)) {
                requiresEmptyLine = true;
            } else if (this.hasAnnotationCommentOrJavadoc(javaTermContent) || this.hasAnnotationCommentOrJavadoc(previousJavaTermContent)) {
                requiresEmptyLine = true;
            } else if (previousJavaTerm.getType() == 20 && (previousJavaTermName.equals("_instance") || previousJavaTermName.equals("_log") || previousJavaTermName.equals("_logger"))) {
                requiresEmptyLine = true;
            } else if (previousJavaTermContent.contains("\n\n\t") || javaTermContent.contains("\n\n\t")) {
                requiresEmptyLine = true;
            }
            if (requiresEmptyLine) {
                if (!this._classContent.contains("\n\n" + javaTermContent)) {
                    this._classContent = StringUtil.replace(this._classContent, "\n" + javaTermContent, "\n\n" + javaTermContent);
                    return;
                }
            } else if (this._classContent.contains("\n\n" + javaTermContent)) {
                this._classContent = StringUtil.replace(this._classContent, "\n\n" + javaTermContent, "\n" + javaTermContent);
                return;
            }
            previousJavaTerm = javaTerm;
        }
        String lastJavaTermContent = previousJavaTerm.getContent();
        if (!lastJavaTermContent.endsWith("\n\n")) {
            int x = this._classContent.lastIndexOf(125);
            this._classContent = StringUtil.insert(this._classContent, "\n", x - this._indent.length() + 1);
        }
    }

    protected String fixLeadingTabs(String content, String line, int expectedTabCount) {
        int leadingTabCount = this._javaSourceProcessor.getLeadingTabCount(line);
        String newLine = line;
        while (leadingTabCount != expectedTabCount) {
            if (leadingTabCount > expectedTabCount) {
                newLine = StringUtil.replaceFirst(newLine, '\t', "");
                --leadingTabCount;
                continue;
            }
            newLine = "\t" + newLine;
            ++leadingTabCount;
        }
        return StringUtil.replace(content, line, newLine);
    }

    protected void fixTabsAndIncorrectEmptyLines(JavaTerm javaTerm) {
        if (!javaTerm.isConstructor() && !javaTerm.isMethod()) {
            return;
        }
        String javaTermContent = "\n" + javaTerm.getContent();
        Pattern methodNameAndParametersPattern = Pattern.compile("\n" + this._indent + "(private |protected |public ).*?(\\{|;)\n", 32);
        Matcher matcher = methodNameAndParametersPattern.matcher(javaTermContent);
        if (!matcher.find()) {
            return;
        }
        String methodNameAndParameters = matcher.group();
        String[] lines = StringUtil.splitLines(methodNameAndParameters);
        if (lines.length == 1) {
            String trimmedJavaTermContent;
            if (methodNameAndParameters.endsWith("{\n") && javaTermContent.contains(methodNameAndParameters + "\n") && !javaTermContent.contains(methodNameAndParameters + "\n" + this._indent + "\t" + "/*") && !javaTermContent.contains(methodNameAndParameters + "\n" + this._indent + "\t" + "// ") && !(trimmedJavaTermContent = StringUtil.trimTrailing(javaTermContent)).endsWith("\n\n" + this._indent + "}")) {
                this._classContent = StringUtil.replace(this._classContent, methodNameAndParameters + "\n", methodNameAndParameters);
            }
            return;
        }
        if (methodNameAndParameters.endsWith("{\n") && !javaTermContent.contains(methodNameAndParameters + "\n") && !javaTermContent.contains(methodNameAndParameters + this._indent + "}")) {
            this._classContent = StringUtil.replace(this._classContent, methodNameAndParameters, methodNameAndParameters + "\n");
        }
        boolean throwsException = methodNameAndParameters.contains(this._indent + "throws ");
        String newMethodNameAndParameters = methodNameAndParameters;
        int expectedTabCount = -1;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.contains(this._indent + "throws ")) {
                newMethodNameAndParameters = this.fixLeadingTabs(newMethodNameAndParameters, line, this._indent.length() + 1);
                break;
            }
            if (expectedTabCount == -1) {
                if (!line.endsWith("(")) continue;
                expectedTabCount = Math.max(this._javaSourceProcessor.getLeadingTabCount(line), this._indent.length()) + 1;
                if (!throwsException || expectedTabCount != this._indent.length() + 1) continue;
                ++expectedTabCount;
                continue;
            }
            String previousLine = lines[i - 1];
            newMethodNameAndParameters = previousLine.endsWith(",") || previousLine.endsWith("(") ? this.fixLeadingTabs(newMethodNameAndParameters, line, expectedTabCount) : this.fixLeadingTabs(newMethodNameAndParameters, line, this._javaSourceProcessor.getLeadingTabCount(previousLine) + 1);
        }
        this._classContent = StringUtil.replace(this._classContent, methodNameAndParameters, newMethodNameAndParameters);
    }

    protected void formatAnnotations(JavaTerm javaTerm, String testAnnotationsExcludesProperty) throws Exception {
        String newJavaTermContent;
        String javaTermContent;
        if (this._indent.length() == 1 && !this._javaSourceProcessor.isExcludedPath(testAnnotationsExcludesProperty, this._absolutePath) && this._fileName.endsWith("Test.java")) {
            this.checkTestAnnotations(javaTerm);
        }
        if (!(javaTermContent = javaTerm.getContent()).equals(newJavaTermContent = this._javaSourceProcessor.formatAnnotations(this._fileName, javaTerm.getName(), javaTermContent, this._indent, true))) {
            this._classContent = this._classContent.replace(javaTermContent, newJavaTermContent);
        }
    }

    protected String getAccessModifier() {
        String accessModifier;
        Matcher matcher = this._classPattern.matcher(this._classContent);
        if (matcher.find() && ((accessModifier = matcher.group(1)).equals(_ACCESS_MODIFIER_PRIVATE) || accessModifier.equals(_ACCESS_MODIFIER_PROTECTED) || accessModifier.equals(_ACCESS_MODIFIER_PUBLIC))) {
            return accessModifier;
        }
        return _ACCESS_MODIFIER_UNKNOWN;
    }

    protected String getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf(123);
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf(60)) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(32);
        return line.substring(pos + 1);
    }

    protected String getCleanUpMethodContent(Set<JavaTerm> javaTerms) {
        if (this._cleanUpMethodContent != null) {
            return this._cleanUpMethodContent;
        }
        String cleanUpMethodContent = "";
        for (JavaTerm javaTerm : javaTerms) {
            String javaTermName;
            if (!javaTerm.isMethod() || !(javaTermName = javaTerm.getName()).equals("cleanUp")) continue;
            cleanUpMethodContent = javaTerm.getContent();
            break;
        }
        this._cleanUpMethodContent = cleanUpMethodContent;
        return this._cleanUpMethodContent;
    }

    protected String getCombinedStaticBlocks(String staticBlock1, String staticBlock2) {
        int x = staticBlock1.lastIndexOf("}");
        x = staticBlock1.lastIndexOf("\n", x - 1);
        int y = staticBlock2.indexOf("{") + 1;
        return staticBlock1.substring(0, x + 1) + staticBlock2.substring(y);
    }

    protected String getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(32);
        return line.substring(x + 1);
    }

    protected String getCustomSQLContent() throws Exception {
        if (JavaSourceProcessor.portalSource && !this._javaSourceProcessor.isModulesFile(this._absolutePath)) {
            return this._javaSourceProcessor.getPortalCustomSQLContent();
        }
        if (this._customSQLContent != null) {
            return this._customSQLContent;
        }
        int i = this._fileName.lastIndexOf("/src/");
        if (i == -1) {
            return null;
        }
        File customSQLFile = new File(this._fileName.substring(0, i) + "/src/custom-sql/default.xml");
        if (!customSQLFile.exists()) {
            customSQLFile = new File(this._fileName.substring(0, i) + "/src/main/resources/META-INF/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            customSQLFile = new File(this._fileName.substring(0, i) + "/src/main/resources/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            return null;
        }
        this._customSQLContent = FileUtil.read(customSQLFile);
        return this._customSQLContent;
    }

    protected JavaTerm getJavaTerm(String name, int type, int startPos, int endPos) throws Exception {
        String javaTermContent = this._classContent.substring(startPos, endPos);
        int lineCount = this._lineCount + this._javaSourceProcessor.getLineCount(this._classContent, startPos) - 1;
        if (Validator.isNull(name) || !this.isValidJavaTerm(javaTermContent)) {
            throw new InvalidJavaTermException(lineCount);
        }
        JavaTerm javaTerm = new JavaTerm(name, type, javaTermContent, this._fileName, lineCount, this._indent);
        if (this._fileName.contains("persistence") && this._fileName.endsWith("FinderImpl.java")) {
            javaTerm.setCustomSQLContent(this.getCustomSQLContent());
        }
        if (javaTerm.isConstructor()) {
            ++this._constructorCount;
        }
        if (!javaTerm.isClass()) {
            return javaTerm;
        }
        JavaClass innerClass = new JavaClass(name, this._packagePath, this._file, this._fileName, this._absolutePath, this._content, javaTermContent, lineCount, this._indent + "\t", this, this._javaSourceProcessor);
        this._innerClasses.add(innerClass);
        return javaTerm;
    }

    protected int getJavaTermCount(Set<JavaTerm> javaTerms, String javaTermName) {
        int count = 0;
        for (JavaTerm javaTerm : javaTerms) {
            String curJavaTermName = javaTerm.getName();
            if (!curJavaTermName.equals(javaTermName)) continue;
            ++count;
        }
        return count;
    }

    protected Set<JavaTerm> getJavaTerms() throws Exception {
        if (this._javaTerms != null) {
            return this._javaTerms;
        }
        TreeSet<JavaTerm> javaTerms = new TreeSet<JavaTerm>(new JavaTermComparator());
        List<JavaTerm> staticBlocks = new ArrayList<JavaTerm>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(this._classContent));
        int index = 0;
        String line = null;
        String javaTermName = null;
        int javaTermStartPosition = -1;
        int javaTermType = -1;
        int lastCommentOrAnnotationPos = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String insideClass;
            Matcher matcher;
            if (this._javaSourceProcessor.getLeadingTabCount(line) != this._indent.length()) {
                index = index + line.length() + 1;
                continue;
            }
            if (line.startsWith(this._indent + "private ") || line.equals(this._indent + _ACCESS_MODIFIER_PRIVATE) || line.startsWith(this._indent + "protected ") || line.equals(this._indent + _ACCESS_MODIFIER_PROTECTED) || line.startsWith(this._indent + "public ") || line.equals(this._indent + _ACCESS_MODIFIER_PUBLIC) || line.equals(this._indent + "static {")) {
                Tuple tuple = this.getJavaTermTuple(line, this._classContent, index);
                int javaTermEndPosition = 0;
                javaTermEndPosition = lastCommentOrAnnotationPos == -1 ? index : lastCommentOrAnnotationPos;
                if (javaTermStartPosition != -1 && javaTermEndPosition < this._classContent.length()) {
                    JavaTerm javaTerm = this.getJavaTerm(javaTermName, javaTermType, javaTermStartPosition, javaTermEndPosition);
                    if (javaTermType == 22) {
                        staticBlocks.add(javaTerm);
                    } else if (!javaTerms.add(javaTerm)) {
                        this._javaSourceProcessor.processMessage(this._fileName, "Duplicate " + javaTermName);
                        this._javaTerms = Collections.emptySet();
                        return this._javaTerms;
                    }
                }
                javaTermName = (String)tuple.getObject(0);
                javaTermType = (Integer)tuple.getObject(1);
                if (javaTermType != 22 && !Validator.isVariableName(javaTermName)) {
                    return Collections.emptySet();
                }
                javaTermStartPosition = javaTermEndPosition;
                lastCommentOrAnnotationPos = -1;
            } else if (this.hasAnnotationCommentOrJavadoc(line)) {
                if (lastCommentOrAnnotationPos == -1) {
                    lastCommentOrAnnotationPos = index;
                }
            } else if (!(line.startsWith(this._indent + "}") || line.startsWith(this._indent + ")") || line.startsWith(this._indent + "extends") || line.startsWith(this._indent + "implements") || !(matcher = this._classPattern.matcher(this._classContent)).find() || !(insideClass = this._classContent.substring(matcher.end())).contains(line) || this.isEnumType(line, matcher.group(4)))) {
                return Collections.emptySet();
            }
            index = index + line.length() + 1;
        }
        if (javaTermStartPosition != -1) {
            int javaTermEndPosition = this._classContent.lastIndexOf(125) - this._indent.length() + 1;
            JavaTerm javaTerm = this.getJavaTerm(javaTermName, javaTermType, javaTermStartPosition, javaTermEndPosition);
            if (javaTermType == 22) {
                staticBlocks.add(javaTerm);
            } else if (!javaTerms.add(javaTerm)) {
                this._javaSourceProcessor.processMessage(this._fileName, "Duplicate " + javaTermName);
                this._javaTerms = Collections.emptySet();
                return this._javaTerms;
            }
        }
        if (this.combineStaticBlocks(staticBlocks = this.processStaticBlocks(javaTerms, staticBlocks))) {
            return this.getJavaTerms();
        }
        javaTerms.addAll(staticBlocks);
        this._javaTerms = javaTerms;
        return this._javaTerms;
    }

    protected Tuple getJavaTermTuple(String line, String accessModifier) {
        if (!line.startsWith(this._indent + accessModifier + " ")) {
            return null;
        }
        int x = line.indexOf(61);
        int y = line.indexOf(40);
        if (line.startsWith(this._indent + accessModifier + " static ")) {
            if (line.contains(" class ") || line.contains(" enum ")) {
                return this.getJavaTermTuple(this.getClassName(line), accessModifier, 24, 15, 7);
            }
            if (x > 0 && (y == -1 || y > x) || line.endsWith(";") && y == -1) {
                return this.getJavaTermTuple(this.getVariableName(line), accessModifier, 20, 12, 1);
            }
            if (y != -1) {
                return this.getJavaTermTuple(this.getConstructorOrMethodName(line, y), accessModifier, 17, 9, 3);
            }
            return null;
        }
        if (line.contains(" @interface ") || line.contains(" class ") || line.contains(" enum ") || line.contains(" interface ")) {
            return this.getJavaTermTuple(this.getClassName(line), accessModifier, 25, 16, 8);
        }
        if (x > 0 && (y == -1 || y > x) || line.endsWith(";") && y == -1) {
            return this.getJavaTermTuple(this.getVariableName(line), accessModifier, 23, 14, 6);
        }
        if (y != -1) {
            int spaceCount = StringUtil.count(line.substring(0, y), ' ');
            if (spaceCount == 1) {
                return this.getJavaTermTuple(this.getConstructorOrMethodName(line, y), accessModifier, 18, 10, 4);
            }
            if (spaceCount > 1) {
                return this.getJavaTermTuple(this.getConstructorOrMethodName(line, y), accessModifier, 19, 11, 5);
            }
        }
        return null;
    }

    protected Tuple getJavaTermTuple(String line, String content, int index) throws Exception {
        int posStartNextLine = index;
        while (!line.endsWith("{") && !line.endsWith(";")) {
            posStartNextLine = content.indexOf(10, posStartNextLine) + 1;
            int posEndNextline = content.indexOf(10, posStartNextLine);
            String nextLine = content.substring(posStartNextLine, posEndNextline);
            nextLine = StringUtil.trimLeading(nextLine);
            if (line.endsWith("(")) {
                line = line + nextLine;
                continue;
            }
            line = line + " " + nextLine;
        }
        line = StringUtil.replace(line, " synchronized ", " ");
        for (String accessModifier : _ACCESS_MODIFIERS) {
            Tuple tuple = this.getJavaTermTuple(line, accessModifier);
            if (tuple == null) continue;
            return tuple;
        }
        if (!line.startsWith(this._indent + "static {")) {
            int lineCount = this._lineCount + this._javaSourceProcessor.getLineCount(content, index) - 1;
            throw new InvalidJavaTermException(lineCount);
        }
        return new Tuple("static", 22);
    }

    protected Tuple getJavaTermTuple(String javaTermName, String accessModifier, int privateJavaTermType, int protectedJavaTermType, int publicJavaTermType) {
        if (accessModifier.equals(_ACCESS_MODIFIER_PRIVATE)) {
            return new Tuple(javaTermName, privateJavaTermType);
        }
        if (accessModifier.equals(_ACCESS_MODIFIER_PROTECTED)) {
            return new Tuple(javaTermName, protectedJavaTermType);
        }
        return new Tuple(javaTermName, publicJavaTermType);
    }

    protected String getVariableName(String line) {
        int x = line.indexOf(61);
        int y = line.lastIndexOf(32);
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim(line);
            y = line.lastIndexOf(32);
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    protected boolean hasAnnotationCommentOrJavadoc(String s) {
        return s.startsWith(this._indent + "@") || s.startsWith(this._indent + "/") || s.startsWith(this._indent + " *");
    }

    protected boolean isEnumType(String line, String javaClassType) {
        if (!javaClassType.equals("enum")) {
            return false;
        }
        Matcher matcher = this._enumTypePattern.matcher(line + "\n");
        return matcher.find();
    }

    protected boolean isFinalableField(JavaTerm javaTerm, String javaTermClassName, Pattern pattern, boolean checkOuterClass) throws Exception {
        if (checkOuterClass && this._outerClass != null) {
            return this._outerClass.isFinalableField(javaTerm, javaTermClassName, pattern, true);
        }
        for (JavaTerm curJavaTerm : this.getJavaTerms()) {
            String content = curJavaTerm.getContent();
            if (!curJavaTerm.isMethod() && (!curJavaTerm.isConstructor() || javaTermClassName.equals(this._name)) && (!curJavaTerm.isVariable() || !content.contains("{\n\n"))) continue;
            Matcher matcher = pattern.matcher(content);
            if (!content.contains(javaTerm.getName()) || !matcher.find()) continue;
            return false;
        }
        for (JavaClass innerClass : this._innerClasses) {
            if (innerClass.isFinalableField(javaTerm, javaTermClassName, pattern, false)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidJavaTerm(String content) {
        if (content.startsWith(this._indent + "static {")) {
            return true;
        }
        while (!(content.startsWith(this._indent + _ACCESS_MODIFIER_PRIVATE) || content.startsWith(this._indent + _ACCESS_MODIFIER_PROTECTED) || content.startsWith(this._indent + _ACCESS_MODIFIER_PUBLIC))) {
            content = content.substring(content.indexOf(10) + 1);
        }
        int indentLinesCount = StringUtil.count(content, "\n" + this._indent) - StringUtil.count(content, "\n" + this._indent + "\t");
        if ((content = StringUtil.trim(content)).endsWith("}") && (indentLinesCount == 1 || (indentLinesCount == 2 || indentLinesCount == 3) && content.contains("\n" + this._indent + "static {"))) {
            return true;
        }
        return content.endsWith("};") && indentLinesCount == 1 || content.endsWith(";") && indentLinesCount == 0;
    }

    protected List<JavaTerm> processStaticBlocks(TreeSet<JavaTerm> javaTerms, List<JavaTerm> staticBlocks) {
        block0: for (int i = 0; i < staticBlocks.size(); ++i) {
            JavaTerm staticBlock = staticBlocks.get(i);
            String staticBlockContent = staticBlock.getContent();
            Iterator<JavaTerm> javaTermsIterator = javaTerms.descendingIterator();
            while (javaTermsIterator.hasNext()) {
                JavaTerm javaTerm = javaTermsIterator.next();
                if (!javaTerm.isStatic() || !javaTerm.isVariable() || !staticBlockContent.matches("[\\s\\S]*\\W" + javaTerm.getName() + "\\W[\\s\\S]*")) continue;
                staticBlock.setType(javaTerm.getType() + 1);
                staticBlocks.set(i, staticBlock);
                continue block0;
            }
        }
        return staticBlocks;
    }

    protected void sortJavaTerms(JavaTerm previousJavaTerm, JavaTerm javaTerm, String javaTermSortExcludesProperty) {
        if (previousJavaTerm == null || this._content.contains("@Meta.OCD(")) {
            return;
        }
        String javaTermName = javaTerm.getName();
        if (this._javaSourceProcessor.isExcludedPath(javaTermSortExcludesProperty, this._absolutePath, -1, javaTermName)) {
            return;
        }
        if (previousJavaTerm.getLineCount() > javaTerm.getLineCount()) {
            this._classContent = StringUtil.replaceFirst(this._classContent, "\n" + javaTerm.getContent(), "\n" + previousJavaTerm.getContent());
            this._classContent = StringUtil.replaceLast(this._classContent, "\n" + previousJavaTerm.getContent(), "\n" + javaTerm.getContent());
        }
    }

    private void _formatBooleanStatement(String javaTermContent, String booleanStatement, String tabs, String variableName, String ifCondition, String trueValue, String falseValue) {
        StringBundler sb = new StringBundler(19);
        sb.append("\n\n");
        sb.append(tabs);
        sb.append("boolean ");
        sb.append(variableName);
        sb.append(" = ");
        sb.append(falseValue);
        sb.append(";\n\n");
        sb.append(tabs);
        sb.append("if (");
        sb.append(ifCondition);
        sb.append(") {\n\n");
        sb.append(tabs);
        sb.append("\t");
        sb.append(variableName);
        sb.append(" = ");
        sb.append(trueValue);
        sb.append(";\n");
        sb.append(tabs);
        sb.append("}\n");
        String newJavaTermContent = StringUtil.replace(javaTermContent, booleanStatement, sb.toString());
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    private void _formatBooleanStatements(JavaTerm javaTerm) {
        String javaTermContent = javaTerm.getContent();
        Matcher matcher1 = this._booleanPattern.matcher(javaTermContent);
        while (matcher1.find()) {
            String booleanStatement = matcher1.group();
            if (booleanStatement.contains("\t//") || booleanStatement.contains(" {\n")) continue;
            String criteria = matcher1.group(3);
            String[] ternaryOperatorParts = this._getTernaryOperatorParts(criteria);
            if (ternaryOperatorParts != null) {
                String falseValue = ternaryOperatorParts[2];
                String ifCondition = ternaryOperatorParts[0];
                String trueValue = ternaryOperatorParts[1];
                this._formatBooleanStatement(javaTermContent, booleanStatement, matcher1.group(1), matcher1.group(2), ifCondition, trueValue, falseValue);
                return;
            }
            String strippedCriteria = this._stripQuotesAndMethodParameters(criteria);
            if (this._javaSourceProcessor.getLevel(strippedCriteria) == 0 && (strippedCriteria.contains("|") || strippedCriteria.contains("&") || strippedCriteria.contains("^"))) {
                this._formatBooleanStatement(javaTermContent, booleanStatement, matcher1.group(1), matcher1.group(2), criteria, "true", "false");
                return;
            }
            Matcher matcher2 = this._relationalOperatorPattern.matcher(strippedCriteria);
            if (!matcher2.find()) continue;
            this._formatBooleanStatement(javaTermContent, booleanStatement, matcher1.group(1), matcher1.group(2), criteria, "true", "false");
            return;
        }
    }

    private void _formatMissingLineBreak(JavaTerm javaTerm) {
        String javaTermContent = javaTerm.getContent();
        Matcher matcher = this._missingEmptyLinePattern.matcher(javaTermContent);
        if (matcher.find()) {
            String newJavaTermContent = StringUtil.insert(javaTermContent, "\n", matcher.start(1));
            this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
        }
    }

    private void _formatReturnStatement(String javaTermContent, String returnStatement, String tabs, String ifCondition, String trueValue, String falseValue) {
        StringBundler sb = new StringBundler(15);
        sb.append("\n");
        sb.append(tabs);
        sb.append("if (");
        sb.append(ifCondition);
        sb.append(") {\n\n");
        sb.append(tabs);
        sb.append("\treturn ");
        sb.append(trueValue);
        sb.append(";\n");
        sb.append(tabs);
        sb.append("}\n\n");
        sb.append(tabs);
        sb.append("return ");
        sb.append(falseValue);
        sb.append(";\n");
        String newJavaTermContent = StringUtil.replace(javaTermContent, returnStatement, sb.toString());
        this._classContent = StringUtil.replace(this._classContent, javaTermContent, newJavaTermContent);
    }

    private void _formatReturnStatements(JavaTerm javaTerm) {
        String javaTermContent = javaTerm.getContent();
        String returnType = javaTerm.getReturnType();
        Matcher matcher1 = this._returnPattern.matcher(javaTermContent);
        while (matcher1.find()) {
            String returnStatement = matcher1.group();
            if (returnStatement.contains("\t//") || returnStatement.contains(" {\n")) continue;
            String[] ternaryOperatorParts = this._getTernaryOperatorParts(matcher1.group(2));
            if (ternaryOperatorParts != null) {
                String falseValue = ternaryOperatorParts[2];
                String ifCondition = ternaryOperatorParts[0];
                String trueValue = ternaryOperatorParts[1];
                this._formatReturnStatement(javaTermContent, returnStatement, matcher1.group(1), ifCondition, trueValue, falseValue);
                return;
            }
            if (!returnType.equals("boolean")) continue;
            String strippedReturnStatement = this._javaSourceProcessor.stripQuotes(returnStatement);
            if (strippedReturnStatement.contains("|") || strippedReturnStatement.contains("&") || strippedReturnStatement.contains("^")) {
                this._formatReturnStatement(javaTermContent, returnStatement, matcher1.group(1), matcher1.group(2), "true", "false");
                return;
            }
            Matcher matcher2 = this._relationalOperatorPattern.matcher(returnStatement);
            if (!matcher2.find() || ToolsUtil.isInsideQuotes(returnStatement, matcher2.start(1))) continue;
            this._formatReturnStatement(javaTermContent, returnStatement, matcher1.group(1), matcher1.group(2), "true", "false");
            return;
        }
    }

    private String[] _getTernaryOperatorParts(String operator) {
        int x = -1;
        do {
            if ((x = operator.indexOf("?", x + 1)) != -1) continue;
            return null;
        } while (ToolsUtil.isInsideQuotes(operator, x) || this._javaSourceProcessor.getLevel(operator.substring(0, x), "<", ">") != 0);
        int y = x;
        do {
            if ((y = operator.indexOf(":", y + 1)) != -1) continue;
            return null;
        } while (ToolsUtil.isInsideQuotes(operator, y));
        String falseValue = StringUtil.trim(operator.substring(y + 1));
        String ifCondition = StringUtil.trim(operator.substring(0, x));
        String trueValue = StringUtil.trim(operator.substring(x + 1, y));
        if (this._javaSourceProcessor.getLevel(falseValue) == 0 && this._javaSourceProcessor.getLevel(ifCondition) == 0 && this._javaSourceProcessor.getLevel(trueValue) == 0) {
            return new String[]{ifCondition, trueValue, falseValue};
        }
        return null;
    }

    private String _stripQuotesAndMethodParameters(String s) {
        s = this._javaSourceProcessor.stripQuotes(s);
        block0: while (true) {
            int start = -1;
            for (int i = 1; i < s.length(); ++i) {
                String part;
                char c1 = s.charAt(i);
                if (start == -1) {
                    char c2;
                    if (c1 != '(' || !Character.isLetterOrDigit(c2 = s.charAt(i - 1))) continue;
                    start = i;
                    continue;
                }
                if (c1 != ')' || this._javaSourceProcessor.getLevel(part = s.substring(start, i + 1)) != 0) continue;
                s = StringUtil.replace(s, part, "", start);
                continue block0;
            }
            break;
        }
        return s;
    }
}

