/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class DetailASTUtil {
    public static final int ALL_TYPES = -1;

    public static DetailAST findTypeAST(DetailAST methodAST, String name) {
        List<DetailAST> localVariableDefASTList = DetailASTUtil.getAllChildTokens(methodAST, true, 10);
        DetailAST typeAST = DetailASTUtil._findTypeAST(localVariableDefASTList, name);
        if (typeAST != null) {
            return typeAST;
        }
        List<DetailAST> parameterDefASTList = DetailASTUtil.getParameterDefs(methodAST);
        typeAST = DetailASTUtil._findTypeAST(parameterDefASTList, name);
        if (typeAST != null) {
            return typeAST;
        }
        for (DetailAST classAST = methodAST.getParent(); classAST != null; classAST = classAST.getParent()) {
            List<DetailAST> globalVariableDefASTList = DetailASTUtil.getAllChildTokens(classAST, false, 10);
            typeAST = DetailASTUtil._findTypeAST(globalVariableDefASTList, name);
            if (typeAST == null) continue;
            return typeAST;
        }
        return null;
    }

    public static List<DetailAST> getAllChildTokens(DetailAST detailAST, boolean recursive, int ... tokenTypes) {
        return DetailASTUtil._getAllChildTokens(detailAST, recursive, null, tokenTypes);
    }

    public static int getEndLine(DetailAST detailAST) {
        int endLine = detailAST.getLineNo();
        for (DetailAST childAST : DetailASTUtil.getAllChildTokens(detailAST, true, -1)) {
            if (childAST.getLineNo() <= endLine) continue;
            endLine = childAST.getLineNo();
        }
        return endLine;
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String methodName) {
        return DetailASTUtil.getMethodCalls(detailAST, null, methodName);
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String className, String methodName) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            List<DetailAST> nameASTList;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST == null || (nameASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 58)).size() != 2) continue;
            DetailAST classNameAST = nameASTList.get(0);
            DetailAST methodNameAST = nameASTList.get(1);
            String methodCallClassName = classNameAST.getText();
            String methodCallMethodName = methodNameAST.getText();
            if (className != null && !methodCallClassName.equals(className) || !methodCallMethodName.equals(methodName)) continue;
            list.add(methodCallAST);
        }
        return list;
    }

    public static String getMethodName(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return null;
        }
        DetailAST dotAST = detailAST.findFirstToken(59);
        if (dotAST == null) {
            DetailAST nameAST = detailAST.findFirstToken(58);
            return nameAST.getText();
        }
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 58);
        DetailAST methodNameAST = nameASTList.get(nameASTList.size() - 1);
        return methodNameAST.getText();
    }

    public static List<DetailAST> getParameterDefs(DetailAST detailAST) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return list;
        }
        DetailAST parametersAST = detailAST.findFirstToken(20);
        return DetailASTUtil.getAllChildTokens(parametersAST, false, 21);
    }

    public static List<String> getParameterNames(DetailAST detailAST) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (DetailAST parameterDefinitionAST : DetailASTUtil.getParameterDefs(detailAST)) {
            DetailAST identAST = parameterDefinitionAST.findFirstToken(58);
            parameterNames.add(identAST.getText());
        }
        return parameterNames;
    }

    public static int getStartLine(DetailAST detailAST) {
        int startLine = detailAST.getLineNo();
        for (DetailAST childAST : DetailASTUtil.getAllChildTokens(detailAST, true, -1)) {
            if (childAST.getLineNo() >= startLine) continue;
            startLine = childAST.getLineNo();
        }
        return startLine;
    }

    public static boolean hasParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (!ArrayUtil.contains(tokenTypes, parentAST.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollection(DetailAST detailAST) {
        if (detailAST.getType() != 10) {
            return false;
        }
        DetailAST typeAST = detailAST.findFirstToken(13);
        DetailAST typeArgumentsAST = typeAST.findFirstToken(163);
        if (typeArgumentsAST == null) {
            return false;
        }
        DetailAST nameAST = typeAST.findFirstToken(58);
        String name = nameAST.getText();
        return name.matches(".*(Collection|List|Map|Set)");
    }

    private static DetailAST _findTypeAST(List<DetailAST> defASTList, String name) {
        for (DetailAST defAST : defASTList) {
            DetailAST nameAST = defAST.findFirstToken(58);
            String curName = nameAST.getText();
            if (!curName.equals(name)) continue;
            return defAST.findFirstToken(13);
        }
        return null;
    }

    private static List<DetailAST> _getAllChildTokens(DetailAST detailAST, boolean recursive, List<DetailAST> list, int ... tokenTypes) {
        if (list == null) {
            list = new ArrayList<DetailAST>();
        }
        for (DetailAST childAST = detailAST.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (ArrayUtil.contains(tokenTypes, childAST.getType()) || ArrayUtil.contains(tokenTypes, -1)) {
                list.add(childAST);
            }
            if (!recursive) continue;
            list = DetailASTUtil._getAllChildTokens(childAST, recursive, list, tokenTypes);
        }
        return list;
    }
}

