/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessagingConfiguratorRegistry {
    private static final Map<String, List<MessagingConfigurator>> _messagingConfigurators = new ConcurrentHashMap<String, List<MessagingConfigurator>>();

    public static List<MessagingConfigurator> getMessagingConfigurators(String servletContextName) {
        return _messagingConfigurators.get(servletContextName);
    }

    public static void registerMessagingConfigurator(String servletContextName, MessagingConfigurator messagingConfigurator) {
        List<MessagingConfigurator> messagingConfigurators = _messagingConfigurators.get(servletContextName);
        if (messagingConfigurators == null) {
            messagingConfigurators = new ArrayList<MessagingConfigurator>();
            _messagingConfigurators.put(servletContextName, messagingConfigurators);
        }
        messagingConfigurators.add(messagingConfigurator);
    }

    public static void unregisterMessagingConfigurator(String servletContextName, MessagingConfigurator messagingConfigurator) {
        List<MessagingConfigurator> messagingConfigurators = _messagingConfigurators.get(servletContextName);
        if (messagingConfigurators != null) {
            messagingConfigurators.remove(messagingConfigurator);
            if (messagingConfigurators.isEmpty()) {
                _messagingConfigurators.remove(servletContextName);
            }
        }
    }
}

