/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.model.PortletInstance;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class PortletConstants {
    public static final String DEFAULT_PREFERENCES = "<portlet-preferences />";
    @Deprecated
    public static final String FACEBOOK_INTEGRATION_FBML = "fbml";
    @Deprecated
    public static final String FACEBOOK_INTEGRATION_IFRAME = "iframe";
    @Deprecated
    public static final String INSTANCE_SEPARATOR = "_INSTANCE_";
    public static final String LAYOUT_SEPARATOR = "_LAYOUT_";
    public static final String USER_PRINCIPAL_STRATEGY_SCREEN_NAME = "screenName";
    public static final String USER_PRINCIPAL_STRATEGY_USER_ID = "userId";
    @Deprecated
    public static final String USER_SEPARATOR = "_USER_";
    public static final String WAR_SEPARATOR = "_WAR_";

    public static String assemblePortletId(String portletId, long userId) {
        PortletInstance portletInstance = null;
        String rootPortletId = PortletConstants.getRootPortletId(portletId);
        String instanceId = PortletConstants.getInstanceId(portletId);
        portletInstance = new PortletInstance(rootPortletId, userId, instanceId);
        return portletInstance.getPortletInstanceKey();
    }

    public static String assemblePortletId(String portletId, long userId, String instanceId) {
        String rootPortletId = PortletConstants.getRootPortletId(portletId);
        if (Validator.isNull(instanceId)) {
            instanceId = PortletConstants.getInstanceId(portletId);
        }
        PortletInstance portletInstance = new PortletInstance(rootPortletId, userId, instanceId);
        return portletInstance.getPortletInstanceKey();
    }

    public static String assemblePortletId(String portletId, String instanceId) {
        PortletInstance portletInstance = new PortletInstance(portletId, instanceId);
        return portletInstance.getPortletInstanceKey();
    }

    public static String generateInstanceId() {
        return StringUtil.randomString(12);
    }

    public static String getInstanceId(String portletId) {
        PortletInstance portletInstance = PortletInstance.fromPortletInstanceKey(portletId);
        return portletInstance.getInstanceId();
    }

    public static String getRootPortletId(String portletId) {
        PortletInstance portletInstance = PortletInstance.fromPortletInstanceKey(portletId);
        return portletInstance.getPortletName();
    }

    public static long getUserId(String portletId) {
        PortletInstance portletInstance = PortletInstance.fromPortletInstanceKey(portletId);
        return portletInstance.getUserId();
    }

    public static boolean hasIdenticalRootPortletId(String portletId1, String portletId2) {
        PortletInstance portletInstance1 = PortletInstance.fromPortletInstanceKey(portletId1);
        PortletInstance portletInstance2 = PortletInstance.fromPortletInstanceKey(portletId2);
        return portletInstance1.hasIdenticalPortletName(portletInstance2);
    }

    public static boolean hasInstanceId(String portletId) {
        PortletInstance portletInstance = PortletInstance.fromPortletInstanceKey(portletId);
        return portletInstance.hasInstanceId();
    }

    public static boolean hasUserId(String portletId) {
        PortletInstance portletInstance = PortletInstance.fromPortletInstanceKey(portletId);
        return portletInstance.hasUserId();
    }
}

