/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.SettingsLocatorHelperUtil;

public class PortletInstanceSettingsLocator
implements SettingsLocator {
    private final String _configurationPid;
    private Boolean _embeddedPortlet;
    private final Layout _layout;
    private final String _portletInstanceKey;
    private final SettingsLocatorHelper _settingsLocatorHelper = SettingsLocatorHelperUtil.getSettingsLocatorHelper();

    public PortletInstanceSettingsLocator(Layout layout, String portletInstanceKey) {
        this._layout = layout;
        this._portletInstanceKey = portletInstanceKey;
        this._configurationPid = PortletConstants.getRootPortletId(portletInstanceKey);
    }

    public PortletInstanceSettingsLocator(Layout layout, String portletInstanceKey, String configurationPid) {
        this._layout = layout;
        this._portletInstanceKey = portletInstanceKey;
        this._configurationPid = configurationPid;
    }

    @Override
    public Settings getSettings() throws SettingsException {
        long companyId = this.getCompanyId(this._layout.getGroupId());
        Settings portalPropertiesSettings = this._settingsLocatorHelper.getPortalPropertiesSettings();
        Settings configurationBeanSettings = this._settingsLocatorHelper.getConfigurationBeanSettings(this._configurationPid, portalPropertiesSettings);
        Settings portalPreferencesSettings = this._settingsLocatorHelper.getPortalPreferencesSettings(companyId, configurationBeanSettings);
        Settings companyPortletPreferencesSettings = this._settingsLocatorHelper.getCompanyPortletPreferencesSettings(companyId, this._portletInstanceKey, portalPreferencesSettings);
        Settings groupPortletPreferencesSettings = this._settingsLocatorHelper.getGroupPortletPreferencesSettings(this._layout.getGroupId(), this._portletInstanceKey, companyPortletPreferencesSettings);
        return this._settingsLocatorHelper.getPortletInstancePortletPreferencesSettings(this._layout.getCompanyId(), this.getOwnerId(), 3, this.getPlid(), this._portletInstanceKey, groupPortletPreferencesSettings);
    }

    @Override
    public String getSettingsId() {
        return this._portletInstanceKey;
    }

    protected long getCompanyId(long groupId) throws SettingsException {
        try {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            return group.getCompanyId();
        }
        catch (PortalException pe) {
            throw new SettingsException(pe);
        }
    }

    protected long getOwnerId() {
        if (this.isEmbeddedPortlet()) {
            return this._layout.getGroupId();
        }
        return 0L;
    }

    protected long getPlid() {
        if (this.isEmbeddedPortlet()) {
            return 0L;
        }
        return this._layout.getPlid();
    }

    protected boolean isEmbeddedPortlet() {
        if (this._embeddedPortlet != null) {
            return this._embeddedPortlet;
        }
        this._embeddedPortlet = false;
        if (this._layout.isSupportsEmbeddedPortlets()) {
            this._embeddedPortlet = this._layout.isPortletEmbedded(this._portletInstanceKey, this._layout.getGroupId());
        }
        return this._embeddedPortlet;
    }
}

