/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.portal.kernel.executor.CopyThreadLocalCallable;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.layoutconfiguration.util.ParallelRenderThreadLocalBinderUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRenderer {
    private static final String _RENDER_PATH = "/html/portal/load_render_portlet.jsp";
    private final Integer _columnCount;
    private final String _columnId;
    private final Integer _columnPos;
    private final Portlet _portlet;
    private RestrictPortletServletRequest _restrictPortletServletRequest;

    public PortletRenderer(Portlet portlet, String columnId, Integer columnCount, Integer columnPos) {
        this._portlet = portlet;
        this._columnId = columnId;
        this._columnCount = columnCount;
        this._columnPos = columnPos;
    }

    public void finishParallelRender() {
        if (this._restrictPortletServletRequest != null) {
            this._restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    public Callable<StringBundler> getCallable(HttpServletRequest request, HttpServletResponse response) {
        return new PortletRendererCallable(request, response);
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public StringBundler render(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)request, null, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        return this._render(request, response);
    }

    public StringBundler renderAjax(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)request, (String)_RENDER_PATH, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        this._restrictPortletServletRequest = (RestrictPortletServletRequest)request;
        return this._render(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBundler renderError(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)request, null, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        request.setAttribute("PARALLEL_RENDERING_TIMEOUT_ERROR", (Object)Boolean.TRUE);
        this._restrictPortletServletRequest = (RestrictPortletServletRequest)request;
        try {
            StringBundler stringBundler = this._render(request, response);
            return stringBundler;
        }
        finally {
            request.removeAttribute("PARALLEL_RENDERING_TIMEOUT_ERROR");
        }
    }

    private StringBundler _render(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        Object lock = request.getAttribute("PARALLEL_RENDERING_MERGE_LOCK");
        request.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", null);
        Object portletParallelRender = request.getAttribute("PORTLET_PARALLEL_RENDER");
        request.setAttribute("PORTLET_PARALLEL_RENDER", (Object)Boolean.FALSE);
        try {
            PortletContainerUtil.render((HttpServletRequest)request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
            StringBundler stringBundler = bufferCacheServletResponse.getStringBundler();
            return stringBundler;
        }
        catch (IOException ioe) {
            throw new PortletContainerException((Throwable)ioe);
        }
        finally {
            request.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", lock);
            request.setAttribute("PORTLET_PARALLEL_RENDER", portletParallelRender);
        }
    }

    private class PortletRendererCallable
    extends CopyThreadLocalCallable<StringBundler> {
        private final HttpServletRequest _request;
        private final HttpServletResponse _response;

        public PortletRendererCallable(HttpServletRequest request, HttpServletResponse response) {
            super(ParallelRenderThreadLocalBinderUtil.getThreadLocalBinder(), false, true);
            this._request = request;
            this._response = response;
        }

        public StringBundler doCall() throws Exception {
            HttpServletRequest request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)this._request, null, (String)PortletRenderer.this._columnId, (Integer)PortletRenderer.this._columnPos, (Integer)PortletRenderer.this._columnCount);
            PortletRenderer.this._restrictPortletServletRequest = (RestrictPortletServletRequest)request;
            try {
                this._split(this._request, PortletRenderer.this._restrictPortletServletRequest);
                return PortletRenderer.this._render(request, this._response);
            }
            catch (Exception e) {
                Thread currentThread = Thread.currentThread();
                if (!currentThread.isInterrupted()) {
                    throw e;
                }
                return null;
            }
        }

        private void _split(HttpServletRequest request, RestrictPortletServletRequest restrictPortletServletRequest) {
            Enumeration attributeNames = request.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attribute = request.getAttribute(attributeName);
                if (!(attribute instanceof Mergeable) || !RestrictPortletServletRequest.isSharedRequestAttribute((String)attributeName)) continue;
                Mergeable mergeable = (Mergeable)attribute;
                restrictPortletServletRequest.setAttribute(attributeName, mergeable.split());
            }
        }
    }
}

