/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.CompanyBaseImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import java.io.Serializable;
import java.security.Key;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class CompanyImpl
extends CompanyBaseImpl {
    private CompanySecurityBag _companySecurityBag;
    private Key _keyObj;
    private String _virtualHostname;

    @Override
    public int compareTo(Company company) {
        String webId1 = this.getWebId();
        String webId2 = company.getWebId();
        if (webId1.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return -1;
        }
        if (webId2.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return 1;
        }
        return webId1.compareTo(webId2);
    }

    public Account getAccount() throws PortalException {
        return AccountLocalServiceUtil.getAccount((long)this.getCompanyId(), (long)this.getAccountId());
    }

    public String getAdminName() {
        return "Administrator";
    }

    public String getAuthType() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._authType;
    }

    @Override
    public CompanySecurityBag getCompanySecurityBag() {
        if (this._companySecurityBag == null) {
            this._companySecurityBag = new CompanySecurityBag(this);
        }
        return this._companySecurityBag;
    }

    public User getDefaultUser() throws PortalException {
        return UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
    }

    public String getDefaultWebId() {
        return PropsValues.COMPANY_DEFAULT_WEB_ID;
    }

    public String getEmailAddress() {
        return "admin@" + this.getMx();
    }

    public Group getGroup() throws PortalException {
        if (this.getCompanyId() > 0L) {
            return GroupLocalServiceUtil.getCompanyGroup((long)this.getCompanyId());
        }
        return new GroupImpl();
    }

    public long getGroupId() throws PortalException {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    @Override
    public Key getKeyObj() {
        String key;
        if (this._keyObj == null && Validator.isNotNull((String)(key = this.getKey()))) {
            this._keyObj = Encryptor.deserializeKey((String)key);
        }
        return this._keyObj;
    }

    public Locale getLocale() throws PortalException {
        return this.getDefaultUser().getLocale();
    }

    @AutoEscape
    public String getName() throws PortalException {
        return this.getAccount().getName();
    }

    public String getPortalURL(long groupId) throws PortalException {
        LayoutSet layoutSet;
        int portalPort = PortalUtil.getPortalServerPort((boolean)false);
        String portalURL = PortalUtil.getPortalURL((String)this.getVirtualHostname(), (int)portalPort, (boolean)false);
        if (groupId <= 0L) {
            return portalURL;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.hasPublicLayouts()) {
            LayoutSet layoutSet2 = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)false);
            if (Validator.isNotNull((String)layoutSet2.getVirtualHostname())) {
                portalURL = PortalUtil.getPortalURL((String)layoutSet2.getVirtualHostname(), (int)portalPort, (boolean)false);
            }
        } else if (group.hasPrivateLayouts() && Validator.isNotNull((String)(layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)true)).getVirtualHostname())) {
            portalURL = PortalUtil.getPortalURL((String)layoutSet.getVirtualHostname(), (int)portalPort, (boolean)false);
        }
        return portalURL;
    }

    public String getShortName() throws PortalException {
        return this.getName();
    }

    public TimeZone getTimeZone() throws PortalException {
        return this.getDefaultUser().getTimeZone();
    }

    @Override
    public String getVirtualHostname() {
        if (this._virtualHostname != null) {
            return this._virtualHostname;
        }
        VirtualHost virtualHost = null;
        try {
            virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((long)this.getCompanyId(), (long)0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (virtualHost == null) {
            return "";
        }
        this._virtualHostname = virtualHost.getHostname();
        return this._virtualHostname;
    }

    public boolean hasCompanyMx(String emailAddress) {
        int pos = (emailAddress = StringUtil.toLowerCase((String)emailAddress.trim())).indexOf(64);
        if (pos == -1) {
            return false;
        }
        String mx = emailAddress.substring(pos + 1);
        if (mx.equals(this.getMx())) {
            return true;
        }
        String[] mailHostNames = PrefsPropsUtil.getStringArray(this.getCompanyId(), "admin.mail.host.names", "\n", PropsValues.ADMIN_MAIL_HOST_NAMES);
        for (int i = 0; i < mailHostNames.length; ++i) {
            if (!StringUtil.equalsIgnoreCase((String)mx, (String)mailHostNames[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoLogin() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._autoLogin;
    }

    public boolean isSendPassword() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._sendPassword;
    }

    public boolean isSendPasswordResetLink() {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.send.password.reset.link", PropsValues.COMPANY_SECURITY_SEND_PASSWORD_RESET_LINK);
    }

    public boolean isSiteLogo() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._siteLogo;
    }

    public boolean isStrangers() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._strangers;
    }

    public boolean isStrangersVerify() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._strangersVerify;
    }

    public boolean isStrangersWithMx() {
        CompanySecurityBag companySecurityBag = this.getCompanySecurityBag();
        return companySecurityBag._strangersWithMx;
    }

    public void setCompanySecurityBag(Object companySecurityBag) {
        this._companySecurityBag = (CompanySecurityBag)companySecurityBag;
    }

    @Override
    public void setKey(String key) {
        this._keyObj = null;
        super.setKey(key);
    }

    @Override
    public void setKeyObj(Key keyObj) {
        this._keyObj = keyObj;
    }

    @Override
    public void setVirtualHostname(String virtualHostname) {
        this._virtualHostname = virtualHostname;
    }

    private static boolean _getPrefsPropsBoolean(PortletPreferences portletPreferences, Company company, String name, boolean defaultValue) {
        String value = portletPreferences.getValue(name, PropsUtil.get(company, name));
        if (value != null) {
            return GetterUtil.getBoolean((String)value);
        }
        return defaultValue;
    }

    private static String _getPrefsPropsString(PortletPreferences portletPreferences, Company company, String name, String defaultValue) {
        String value = portletPreferences.getValue(name, PropsUtil.get(company, name));
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static class CompanySecurityBag
    implements Serializable {
        private final String _authType;
        private final boolean _autoLogin;
        private final boolean _sendPassword;
        private final boolean _siteLogo;
        private final boolean _strangers;
        private final boolean _strangersVerify;
        private final boolean _strangersWithMx;

        private CompanySecurityBag(Company company) {
            PortletPreferences preferences = PrefsPropsUtil.getPreferences(company.getCompanyId(), true);
            this._authType = CompanyImpl._getPrefsPropsString(preferences, company, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            this._autoLogin = CompanyImpl._getPrefsPropsBoolean(preferences, company, "company.security.auto.login", PropsValues.COMPANY_SECURITY_AUTO_LOGIN);
            this._sendPassword = CompanyImpl._getPrefsPropsBoolean(preferences, company, "company.security.send.password", PropsValues.COMPANY_SECURITY_SEND_PASSWORD);
            this._siteLogo = CompanyImpl._getPrefsPropsBoolean(preferences, company, "company.security.site.logo", PropsValues.COMPANY_SECURITY_SITE_LOGO);
            this._strangers = CompanyImpl._getPrefsPropsBoolean(preferences, company, "company.security.strangers", PropsValues.COMPANY_SECURITY_STRANGERS);
            this._strangersVerify = CompanyImpl._getPrefsPropsBoolean(preferences, company, "company.security.strangers.verify", PropsValues.COMPANY_SECURITY_STRANGERS_VERIFY);
            this._strangersWithMx = CompanyImpl._getPrefsPropsBoolean(preferences, company, "company.security.strangers.with.mx", PropsValues.COMPANY_SECURITY_STRANGERS_WITH_MX);
        }
    }
}

