/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileShortcutException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.util.ArrayList;
import java.util.List;

public class RepositoryProviderImpl
implements RepositoryProvider {
    @BeanReference(type=DLFileEntryLocalService.class)
    protected DLFileEntryLocalService dlFileEntryLocalService;
    @BeanReference(type=DLFileShortcutLocalService.class)
    protected DLFileShortcutLocalService dlFileShortcutLocalService;
    @BeanReference(type=DLFileVersionLocalService.class)
    protected DLFileVersionLocalService dlFileVersionLocalService;
    @BeanReference(type=DLFolderLocalService.class)
    protected DLFolderLocalService dlFolderLocalService;
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @BeanReference(type=RepositoryEntryLocalService.class)
    protected RepositoryEntryLocalService repositoryEntryLocalService;
    @BeanReference(type=RepositoryFactory.class)
    protected RepositoryFactory repositoryFactory;
    @BeanReference(type=RepositoryLocalService.class)
    protected RepositoryLocalService repositoryLocalService;

    public LocalRepository getFileEntryLocalRepository(long fileEntryId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFileEntryRepositoryId(fileEntryId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileEntry exists with the key {fileEntryId=");
            sb.append(fileEntryId);
            sb.append("}");
            throw new NoSuchFileEntryException(sb.toString(), (Throwable)irie);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFileEntryRepository(long fileEntryId) throws PortalException {
        try {
            this.checkFileEntryPermissions(fileEntryId);
            return this.getRepository(this.getFileEntryRepositoryId(fileEntryId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileEntry exists with the key {fileEntryId=");
            sb.append(fileEntryId);
            sb.append("}");
            throw new NoSuchFileEntryException(sb.toString(), (Throwable)irie);
        }
    }

    public LocalRepository getFileShortcutLocalRepository(long fileShortcutId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFileShortcutRepositoryId(fileShortcutId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileShortcut exists with the key {fileShortcutId=");
            sb.append(fileShortcutId);
            sb.append("}");
            throw new NoSuchFileShortcutException(sb.toString(), (Throwable)irie);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFileShortcutRepository(long fileShortcutId) throws PortalException {
        try {
            this.checkFileShortcutPermissions(fileShortcutId);
            return this.getRepository(this.getFileShortcutRepositoryId(fileShortcutId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileShortcut exists with the key {fileShortcutId=");
            sb.append(fileShortcutId);
            sb.append("}");
            throw new NoSuchFileShortcutException(sb.toString(), (Throwable)irie);
        }
    }

    public LocalRepository getFileVersionLocalRepository(long fileVersionId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFileVersionRepositoryId(fileVersionId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileVersion exists with the key {fileVersionId=");
            sb.append(fileVersionId);
            sb.append("}");
            throw new NoSuchFileVersionException(sb.toString(), (Throwable)irie);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFileVersionRepository(long fileVersionId) throws PortalException {
        try {
            this.checkFileVersionPermissions(fileVersionId);
            return this.getRepository(this.getFileVersionRepositoryId(fileVersionId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No FileVersion exists with the key {fileVersionId=");
            sb.append(fileVersionId);
            sb.append("}");
            throw new NoSuchFileVersionException(sb.toString(), (Throwable)irie);
        }
    }

    public LocalRepository getFolderLocalRepository(long folderId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFolderRepositoryId(folderId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Folder exists with the key {folderId=");
            sb.append(folderId);
            sb.append("}");
            throw new NoSuchFolderException(sb.toString(), (Throwable)irie);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFolderRepository(long folderId) throws PortalException {
        try {
            this.checkFolderPermissions(folderId);
            return this.getRepository(this.getFolderRepositoryId(folderId));
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Folder exists with the key {folderId=");
            sb.append(folderId);
            sb.append("}");
            throw new NoSuchFolderException(sb.toString(), (Throwable)irie);
        }
    }

    public List<LocalRepository> getGroupLocalRepositories(long groupId) throws PortalException {
        ArrayList<LocalRepository> localRepositories = new ArrayList<LocalRepository>();
        List<Long> repositoryIds = this.getGroupRepositoryIds(groupId);
        for (long repositoryId : repositoryIds) {
            localRepositories.add(this.getLocalRepository(repositoryId));
        }
        return localRepositories;
    }

    public List<com.liferay.portal.kernel.repository.Repository> getGroupRepositories(long groupId) throws PortalException {
        ArrayList<com.liferay.portal.kernel.repository.Repository> repositories = new ArrayList<com.liferay.portal.kernel.repository.Repository>();
        List<Long> repositoryIds = this.getGroupRepositoryIds(groupId);
        for (long repositoryId : repositoryIds) {
            repositories.add(this.getRepository(repositoryId));
        }
        return repositories;
    }

    public LocalRepository getImageLocalRepository(long imageId) throws PortalException {
        return this.getLocalRepository(this.getImageRepositoryId(imageId));
    }

    public com.liferay.portal.kernel.repository.Repository getImageRepository(long imageId) throws PortalException {
        return this.getRepository(this.getImageRepositoryId(imageId));
    }

    public LocalRepository getLocalRepository(long repositoryId) throws PortalException {
        LocalRepository localRepository = this.repositoryFactory.createLocalRepository(repositoryId);
        this.checkRepository(repositoryId);
        this.checkRepositoryAccess(repositoryId);
        return localRepository;
    }

    public com.liferay.portal.kernel.repository.Repository getRepository(long repositoryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryFactory.createRepository(repositoryId);
        this.checkRepository(repositoryId);
        this.checkRepositoryAccess(repositoryId);
        return repository;
    }

    protected void checkFileEntryPermissions(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFileEntry != null && permissionChecker != null) {
            DLFileEntryPermission.check(permissionChecker, fileEntryId, "VIEW");
        }
    }

    protected void checkFileShortcutPermissions(long fileShortcutId) throws PortalException {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutLocalService.fetchDLFileShortcut(fileShortcutId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFileShortcut != null && permissionChecker != null) {
            DLFileEntryPermission.check(permissionChecker, dlFileShortcut.getToFileEntryId(), "VIEW");
        }
    }

    protected void checkFileVersionPermissions(long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.fetchDLFileVersion(fileVersionId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFileVersion != null && permissionChecker != null) {
            DLFileEntryPermission.check(permissionChecker, dlFileVersion.getFileEntryId(), "VIEW");
        }
    }

    protected void checkFolderPermissions(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(folderId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFolder != null && permissionChecker != null) {
            DLFolderPermission.check(permissionChecker, dlFolder, "VIEW");
        }
    }

    protected void checkRepository(long repositoryId) throws PortalException {
        Group group = this.groupLocalService.fetchGroup(repositoryId);
        if (group != null) {
            return;
        }
        try {
            this.repositoryLocalService.getRepository(repositoryId);
        }
        catch (NoSuchRepositoryException nsre) {
            throw new InvalidRepositoryIdException(nsre.getMessage());
        }
    }

    protected void checkRepositoryAccess(long repositoryId) throws PortalException {
        block5: {
            Group group = this.groupLocalService.fetchGroup(repositoryId);
            if (group != null) {
                return;
            }
            try {
                Repository repository = this.repositoryLocalService.fetchRepository(repositoryId);
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                if (repository == null || permissionChecker == null) break block5;
                try {
                    DLFolderPermission.check(permissionChecker, repository.getGroupId(), repository.getDlFolderId(), "VIEW");
                }
                catch (NoSuchFolderException noSuchFolderException) {
                    // empty catch block
                }
                return;
            }
            catch (NoSuchRepositoryException nsre) {
                throw new InvalidRepositoryIdException(nsre.getMessage());
            }
        }
    }

    protected long getFileEntryRepositoryId(long fileEntryId) {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        if (dlFileEntry != null) {
            return dlFileEntry.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(fileEntryId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with file entry " + fileEntryId);
    }

    protected long getFileShortcutRepositoryId(long fileShortcutId) {
        DLFileShortcut dlFileShortcut = this.dlFileShortcutLocalService.fetchDLFileShortcut(fileShortcutId);
        if (dlFileShortcut != null) {
            return dlFileShortcut.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with file shortcut " + fileShortcutId);
    }

    protected long getFileVersionRepositoryId(long fileVersionId) {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.fetchDLFileVersion(fileVersionId);
        if (dlFileVersion != null) {
            return dlFileVersion.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(fileVersionId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with file version " + fileVersionId);
    }

    protected long getFolderRepositoryId(long folderId) {
        DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(folderId);
        if (dlFolder != null) {
            if (dlFolder.isMountPoint()) {
                return dlFolder.getGroupId();
            }
            return dlFolder.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(folderId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with folder " + folderId);
    }

    protected List<Long> getGroupRepositoryIds(long groupId) {
        List repositories = this.repositoryLocalService.getGroupRepositories(groupId);
        ArrayList<Long> repositoryIds = new ArrayList<Long>(repositories.size() + 1);
        for (Repository repository : repositories) {
            repositoryIds.add(repository.getRepositoryId());
        }
        repositoryIds.add(groupId);
        return repositoryIds;
    }

    protected long getImageRepositoryId(long imageId) throws PortalException {
        DLFileEntry dlFileEntry = DLFileEntryServiceUtil.fetchFileEntryByImageId((long)imageId);
        if (dlFileEntry != null) {
            return dlFileEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with image " + imageId);
    }
}

