/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class IndexableAdvice
extends AnnotationChainableMethodAdvice<Indexable> {
    private static final Log _log = LogFactoryUtil.getLog(IndexableAdvice.class);
    private static final Indexable _nullIndexable = new Indexable(){

        public Class<? extends Annotation> annotationType() {
            return Indexable.class;
        }

        public IndexableType type() {
            return null;
        }
    };

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (result == null) {
            return;
        }
        if (IndexWriterHelperUtil.isIndexReadOnly() || CompanyThreadLocal.isDeleteInProcess()) {
            return;
        }
        Indexable indexable = (Indexable)this.findAnnotation(methodInvocation);
        if (indexable == _nullIndexable) {
            return;
        }
        Method method = methodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (!BaseModel.class.isAssignableFrom(returnType)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(methodInvocation + " does not have a valid return type"));
            }
            return;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)returnType.getName());
        if (indexer == null) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return;
        }
        Object[] arguments = methodInvocation.getArguments();
        for (int i = arguments.length - 1; i >= 0; --i) {
            if (!(arguments[i] instanceof ServiceContext)) continue;
            ServiceContext serviceContext = (ServiceContext)arguments[i];
            if (serviceContext.isIndexingEnabled()) break;
            return;
        }
        if (indexable.type() == IndexableType.DELETE) {
            indexer.delete(result);
        } else {
            indexer.reindex(result);
        }
    }

    @Override
    public Indexable getNullAnnotation() {
        return _nullIndexable;
    }
}

