/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.DuplicateTeamException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.TeamNameException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.TeamLocalServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamLocalServiceImpl
extends TeamLocalServiceBaseImpl {
    @Deprecated
    public Team addTeam(long userId, long groupId, String name, String description) throws PortalException {
        return this.addTeam(userId, groupId, name, description, new ServiceContext());
    }

    public Team addTeam(long userId, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validate(0L, groupId, name);
        long teamId = this.counterLocalService.increment();
        Team team = this.teamPersistence.create(teamId);
        team.setUuid(serviceContext.getUuid());
        team.setUserId(userId);
        team.setCompanyId(user.getCompanyId());
        team.setUserName(user.getFullName());
        team.setGroupId(groupId);
        team.setName(name);
        team.setDescription(description);
        this.teamPersistence.update((BaseModel)team);
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, userId, Team.class.getName(), team.getTeamId(), false, true, true);
        this.roleLocalService.addRole(userId, Team.class.getName(), teamId, String.valueOf(teamId), null, null, 4, null, null);
        return team;
    }

    @Override
    public void addUserGroupTeam(long userGroupId, long teamId) {
        super.addUserGroupTeam(userGroupId, teamId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addUserGroupTeam(long userGroupId, Team team) {
        super.addUserGroupTeam(userGroupId, team);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addUserGroupTeams(long userGroupId, List<Team> teams) {
        super.addUserGroupTeams(userGroupId, teams);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addUserGroupTeams(long userGroupId, long[] teamIds) {
        super.addUserGroupTeams(userGroupId, teamIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addUserTeam(long userId, long teamId) {
        super.addUserTeam(userId, teamId);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void addUserTeam(long userId, Team team) {
        super.addUserTeam(userId, team);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void addUserTeams(long userId, List<Team> teams) {
        super.addUserTeams(userId, teams);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void addUserTeams(long userId, long[] teamIds) {
        super.addUserTeams(userId, teamIds);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void clearUserGroupTeams(long userGroupId) {
        super.clearUserGroupTeams(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void clearUserTeams(long userId) {
        super.clearUserTeams(userId);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public Team deleteTeam(long teamId) throws PortalException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        return this.deleteTeam(team);
    }

    @Override
    public Team deleteTeam(Team team) throws PortalException {
        this.teamPersistence.remove((BaseModel)team);
        this.resourceLocalService.deleteResource(team.getCompanyId(), Team.class.getName(), 4, team.getTeamId());
        Role role = team.getRole();
        this.roleLocalService.deleteRole(role);
        return team;
    }

    public void deleteTeams(long groupId) throws PortalException {
        List teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.deleteTeam(team.getTeamId());
        }
    }

    @Override
    public void deleteUserGroupTeam(long userGroupId, long teamId) {
        super.deleteUserGroupTeam(userGroupId, teamId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUserGroupTeam(long userGroupId, Team team) {
        super.deleteUserGroupTeam(userGroupId, team);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUserGroupTeams(long userGroupId, List<Team> teams) {
        super.deleteUserGroupTeams(userGroupId, teams);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUserGroupTeams(long userGroupId, long[] teamIds) {
        super.deleteUserGroupTeams(userGroupId, teamIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUserTeam(long userId, long teamId) {
        super.deleteUserTeam(userId, teamId);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void deleteUserTeam(long userId, Team team) {
        super.deleteUserTeam(userId, team);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void deleteUserTeams(long userId, List<Team> teams) {
        super.deleteUserTeams(userId, teams);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public void deleteUserTeams(long userId, long[] teamIds) {
        super.deleteUserTeams(userId, teamIds);
        PermissionCacheUtil.clearCache(userId);
    }

    public Team fetchTeam(long groupId, String name) {
        return this.teamPersistence.fetchByG_N(groupId, name);
    }

    public List<Team> getGroupTeams(long groupId) {
        return this.teamPersistence.findByGroupId(groupId);
    }

    public Team getTeam(long groupId, String name) throws PortalException {
        return this.teamPersistence.findByG_N(groupId, name);
    }

    public List<Team> getUserOrUserGroupTeams(long groupId, long userId) {
        return this.teamFinder.findByG_U(groupId, userId, -1, -1, null);
    }

    public List<Team> getUserTeams(long userId, long groupId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersTeams", userId);
        return this.search(groupId, null, null, params, -1, -1, null);
    }

    public List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        return this.teamFinder.findByG_N_D(groupId, name, description, params, start, end, obc);
    }

    public int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.teamFinder.countByG_N_D(groupId, name, description, params);
    }

    public Team updateTeam(long teamId, String name, String description) throws PortalException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        this.validate(teamId, team.getGroupId(), name);
        team.setName(name);
        team.setDescription(description);
        this.teamPersistence.update((BaseModel)team);
        return team;
    }

    protected void validate(long teamId, long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new TeamNameException();
        }
        Team team = this.teamPersistence.fetchByG_N(groupId, name);
        if (team != null && team.getTeamId() != teamId) {
            throw new DuplicateTeamException("{teamId=" + teamId + "}");
        }
    }
}

