/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermission;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;

public class OrganizationPermissionImpl
implements OrganizationPermission {
    public void check(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, organizationId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), organizationId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, organization, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), organization.getOrganizationId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException {
        if (organizationId > 0L) {
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            return this.contains(permissionChecker, organization, actionId);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long[] organizationIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])organizationIds)) {
            return true;
        }
        for (long organizationId : organizationIds) {
            if (this.contains(permissionChecker, organizationId, actionId)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException {
        long groupId = organization.getGroupId();
        if (this.contains(permissionChecker, groupId, organization, actionId)) {
            return true;
        }
        while (!organization.isRoot()) {
            Organization parentOrganization = organization.getParentOrganization();
            groupId = parentOrganization.getGroupId();
            if (this.contains(permissionChecker, groupId, parentOrganization, "MANAGE_SUBORGANIZATIONS")) {
                return true;
            }
            organization = parentOrganization;
        }
        return false;
    }

    protected boolean contains(PermissionChecker permissionChecker, long groupId, Organization organization, String actionId) throws PortalException {
        while (organization != null && organization.getOrganizationId() != 0L) {
            if (actionId.equals("ADD_ORGANIZATION") && (permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), "MANAGE_SUBORGANIZATIONS") || PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_ORGANIZATION"))) {
                return true;
            }
            if (permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), actionId)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }
}

