/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class ParallelUpgradeSchemaUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String ... sqlFileNames) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)ParallelUpgradeSchemaUtil.class.getName());
        ArrayList<NoticeableFuture> futures = new ArrayList<NoticeableFuture>(sqlFileNames.length);
        try {
            for (String sqlFileName : sqlFileNames) {
                futures.add(threadPoolExecutor.submit((Callable)new CallableSQLExecutor(sqlFileName)));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            threadPoolExecutor.shutdown();
        }
    }

    private static class CallableSQLExecutor
    implements Callable<Void> {
        private final String _sqlFileName;

        @Override
        public Void call() throws Exception {
            DB db = DBManagerUtil.getDB();
            try (LoggingTimer loggingTimer = new LoggingTimer(this._sqlFileName);){
                db.runSQLTemplate(this._sqlFileName, false);
            }
            return null;
        }

        private CallableSQLExecutor(String sqlFileName) {
            this._sqlFileName = sqlFileName;
        }
    }
}

