/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradeCamelCasePortletPreferences
extends BaseUpgradePortletPreferences {
    private final Map<String, String> _camelCasePreferenceNames = new HashMap<String, String>();

    public UpgradeCamelCasePortletPreferences() {
        this._camelCasePreferenceNames.put("lfr-app-show-share-with-friends-link", "lfrAppShowShareWithFriendsLink");
        this._camelCasePreferenceNames.put("lfr-facebook-api-key", "lfrFacebookApiKey");
        this._camelCasePreferenceNames.put("lfr-facebook-canvas-page-url", "lfrFacebookCanvasPageUrl");
        this._camelCasePreferenceNames.put("lfr-facebook-show-add-app-link", "lfrFacebookShowAddAppLink");
        this._camelCasePreferenceNames.put("lfr-igoogle-show-add-app-link", "lfrIgoogleShowAddAppLink");
        this._camelCasePreferenceNames.put("lfr-netvibes-show-add-app-link", "lfrNetvibesShowAddAppLink");
        this._camelCasePreferenceNames.put("lfr-scope-type", "lfrScopeType");
        this._camelCasePreferenceNames.put("lfr-scope-uuid", "lfrScopeUuid");
        this._camelCasePreferenceNames.put("lfr-sharing", "lfrSharing");
        this._camelCasePreferenceNames.put("lfr-wap-initial-window-state", "lfrWapInitialWindowState");
        this._camelCasePreferenceNames.put("lfr-wap-title", "lfrWapTitle");
        this._camelCasePreferenceNames.put("lfr-widget-show-add-app-link", "lfrWidgetShowAddAppLink");
        this._camelCasePreferenceNames.put("portlet-setup-css", "portletSetupCss");
        this._camelCasePreferenceNames.put("portlet-setup-link-to-layout-uuid", "portletSetupLinkToLayoutUuid");
        this._camelCasePreferenceNames.put("portlet-setup-show-borders", "portletSetupShowBorders");
        this._camelCasePreferenceNames.put("portlet-setup-use-custom-title", "portletSetupUseCustomTitle");
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        return "";
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Map preferencesMap = portletPreferences.getMap();
        for (Map.Entry entry : preferencesMap.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = this._camelCasePreferenceNames.get(oldName);
            if (Validator.isNull((String)newName)) {
                if (oldName.startsWith("portlet-setup-supported-clients-mobile-devices-")) {
                    newName = StringUtil.replaceFirst((String)oldName, (String)"portlet-setup-supported-clients-mobile-devices-", (String)"portletSetupSupportedClientsMobileDevices_");
                } else if (oldName.startsWith("portlet-setup-title-")) {
                    newName = StringUtil.replaceFirst((String)oldName, (String)"portlet-setup-title-", (String)"portletSetupTitle_");
                }
            }
            if (!Validator.isNotNull((String)newName)) continue;
            String[] values = (String[])entry.getValue();
            portletPreferences.reset(oldName);
            portletPreferences.setValues(newName, values);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

