/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import java.util.Map;

public class VerifyUser
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyUser.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyInactive();
        this.verifyNoContacts();
    }

    protected void verifyInactive() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = null;
            DB db = DBManagerUtil.getDB();
            if (db.getDBType() == DBType.MYSQL) {
                sb = new StringBundler(7);
                sb.append("update Group_ inner join User_ on ");
                sb.append("Group_.companyId = User_.companyId and ");
                sb.append("Group_.classPK = User_.userId set active_ = ");
                sb.append("[$FALSE$] where Group_.classNameId = ");
                sb.append(PortalUtil.getClassNameId(User.class));
                sb.append(" and User_.status = ");
                sb.append(5);
            } else {
                sb = new StringBundler(9);
                sb.append("update Group_ set active_ = [$FALSE$] where ");
                sb.append("groupId in (select Group_.groupId from Group_ ");
                sb.append("inner join User_ on Group_.companyId = ");
                sb.append("User_.companyId and Group_.classPK = User_.userId ");
                sb.append("where Group_.classNameId = ");
                sb.append(PortalUtil.getClassNameId(User.class));
                sb.append(" and User_.status = ");
                sb.append(5);
                sb.append(")");
            }
            this.runSQL(sb.toString());
            EntityCacheUtil.clearCache(UserImpl.class);
            FinderCacheUtil.clearCache((String)UserImpl.class.getName());
        }
    }

    protected void verifyNoContacts() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List users = UserLocalServiceUtil.getNoContacts();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + users.size() + " users with no contacts"));
            }
            for (User user : users) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Creating contact for user " + user.getUserId()));
                }
                long contactId = CounterLocalServiceUtil.increment();
                Contact contact = ContactLocalServiceUtil.createContact((long)contactId);
                Company company = CompanyLocalServiceUtil.getCompanyById((long)user.getCompanyId());
                contact.setCompanyId(user.getCompanyId());
                contact.setUserId(user.getUserId());
                contact.setUserName("");
                contact.setAccountId(company.getAccountId());
                contact.setParentContactId(0L);
                contact.setFirstName(user.getFirstName());
                contact.setMiddleName(user.getMiddleName());
                contact.setLastName(user.getLastName());
                contact.setPrefixId(0L);
                contact.setSuffixId(0L);
                contact.setJobTitle(user.getJobTitle());
                ContactLocalServiceUtil.updateContact((Contact)contact);
                user.setContactId(contactId);
                UserLocalServiceUtil.updateUser((User)user);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Contacts verified for users");
            }
            users = UserLocalServiceUtil.getNoGroups();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + users.size() + " users with no groups"));
            }
            for (User user : users) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Creating group for user " + user.getUserId()));
                }
                GroupLocalServiceUtil.addGroup((long)user.getUserId(), (long)0L, (String)User.class.getName(), (long)user.getUserId(), (long)0L, (Map)null, null, (int)0, (boolean)true, (int)0, (String)("/" + user.getScreenName()), (boolean)false, (boolean)true, null);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Groups verified for users");
            }
        }
    }
}

