/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.PortalPreferencesUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.BasePreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import com.liferay.portlet.PortletPreferencesFactoryImpl;
import com.liferay.portlet.Preference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.portlet.ReadOnlyException;
import org.hibernate.StaleObjectStateException;

public class PortalPreferencesImpl
extends BasePreferencesImpl
implements Cloneable,
PortalPreferences,
Serializable {
    public static final TransactionConfig SUPPORTS_TRANSACTION_CONFIG;
    private static final String _RANDOM_KEY = "r";
    private static final Log _log;
    private com.liferay.portal.kernel.model.PortalPreferences _portalPreferences;
    private boolean _signedIn;
    private long _userId;

    public PortalPreferencesImpl() {
        this(0L, 0, null, Collections.emptyMap(), false);
    }

    public PortalPreferencesImpl(com.liferay.portal.kernel.model.PortalPreferences portalPreferences, boolean signedIn) {
        this(portalPreferences.getOwnerId(), portalPreferences.getOwnerType(), portalPreferences.getPreferences(), PortletPreferencesFactoryImpl.createPreferencesMap(portalPreferences.getPreferences()), signedIn);
        this._portalPreferences = (com.liferay.portal.kernel.model.PortalPreferences)portalPreferences.clone();
    }

    public PortalPreferencesImpl(long ownerId, int ownerType, String xml, Map<String, Preference> preferences, boolean signedIn) {
        super(ownerId, ownerType, xml, preferences);
        this._signedIn = signedIn;
    }

    public PortalPreferencesImpl clone() {
        if (this._portalPreferences == null) {
            return new PortalPreferencesImpl(this.getOwnerId(), this.getOwnerType(), this.getOriginalXML(), new HashMap<String, Preference>(this.getOriginalPreferences()), this.isSignedIn());
        }
        return new PortalPreferencesImpl(this._portalPreferences, this.isSignedIn());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortalPreferencesImpl)) {
            return false;
        }
        PortalPreferencesImpl portalPreferences = (PortalPreferencesImpl)obj;
        return this.getOwnerId() == portalPreferences.getOwnerId() && this.getOwnerType() == portalPreferences.getOwnerType() && this.getPreferences().equals(portalPreferences.getPreferences());
    }

    public long getUserId() {
        return this._userId;
    }

    @Override
    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String namespace, String key, String defaultValue) {
        key = this._encodeKey(namespace, key);
        return super.getValue(key, defaultValue);
    }

    public String[] getValues(String namespace, String key) {
        return this.getValues(namespace, key, null);
    }

    public String[] getValues(String namespace, String key, String[] defaultValue) {
        key = this._encodeKey(namespace, key);
        return super.getValues(key, defaultValue);
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (long)this.getOwnerId());
        hashCode = HashUtil.hash((int)hashCode, (int)this.getOwnerType());
        hashCode = HashUtil.hash((int)hashCode, this.getPreferences());
        return hashCode;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    @Override
    public void reset(final String key) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(key);
        }
        String[] values = super.getValues(key, null);
        if (values == null) {
            return;
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                Map<String, Preference> modifiedPreferences = PortalPreferencesImpl.this.getModifiedPreferences();
                modifiedPreferences.remove(key);
                return null;
            }
        };
        try {
            this.retryableStore(callable, key);
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    public void resetValues(String namespace) {
        Map<String, Preference> preferences = this.getPreferences();
        try {
            for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(namespace) || this.isReadOnly(key)) continue;
                this.reset(key);
            }
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setValue(String namespace, String key, final String value) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        final String encodedKey = this._encodeKey(namespace, key);
        try {
            if (value == null) {
                this.reset(encodedKey);
                return;
            }
            String[] oldValues = super.getValues(encodedKey, null);
            if (oldValues != null && oldValues.length == 1 && value.equals(oldValues[0])) {
                return;
            }
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws ReadOnlyException {
                    PortalPreferencesImpl.super.setValue(encodedKey, value);
                    return null;
                }
            };
            if (this._signedIn) {
                this.retryableStore(callable, encodedKey);
            } else {
                callable.call();
            }
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    public void setValues(String namespace, String key, final String[] values) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        final String encodedKey = this._encodeKey(namespace, key);
        try {
            Set oldValuesSet;
            Set valuesSet;
            if (values == null) {
                this.reset(encodedKey);
                return;
            }
            if (values.length == 1) {
                this.setValue(namespace, key, values[0]);
                return;
            }
            Object[] oldValues = super.getValues(encodedKey, null);
            if (oldValues != null && (valuesSet = SetUtil.fromArray((Object[])values)).equals(oldValuesSet = SetUtil.fromArray((Object[])oldValues))) {
                return;
            }
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws ReadOnlyException {
                    PortalPreferencesImpl.super.setValues(encodedKey, values);
                    return null;
                }
            };
            if (this._signedIn) {
                this.retryableStore(callable, encodedKey);
            } else {
                callable.call();
            }
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    @Override
    public void store() throws IOException {
        try {
            if (this._portalPreferences == null) {
                this._portalPreferences = PortalPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (PortalPreferences)this);
            } else {
                PortalPreferencesWrapperCacheUtil.remove(this.getOwnerId(), this.getOwnerType());
                this._portalPreferences.setPreferences(this.toXML());
                PortalPreferencesLocalServiceUtil.updatePortalPreferences((com.liferay.portal.kernel.model.PortalPreferences)this._portalPreferences);
                this._portalPreferences = this._reload(this.getOwnerId(), this.getOwnerType());
            }
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    protected boolean isCausedByStaleObjectException(Throwable t) {
        Throwable cause = t.getCause();
        while (t != cause) {
            if (t instanceof StaleObjectStateException) {
                return true;
            }
            if (cause == null) {
                return false;
            }
            t = cause;
            cause = t.getCause();
        }
        return false;
    }

    protected void retryableStore(Callable<?> callable, String key) throws Throwable {
        Object[] originalValues = super.getValues(key, null);
        while (true) {
            try {
                callable.call();
                this.store();
                return;
            }
            catch (Exception e) {
                if (this.isCausedByStaleObjectException(e)) {
                    int ownerType;
                    long ownerId = this.getOwnerId();
                    com.liferay.portal.kernel.model.PortalPreferences portalPreferences = this._reload(ownerId, ownerType = this.getOwnerType());
                    if (portalPreferences == null) continue;
                    PortalPreferencesImpl portalPreferencesImpl = new PortalPreferencesImpl(portalPreferences, this.isSignedIn());
                    if (!Arrays.equals(originalValues, portalPreferencesImpl.getValues(key, (String[])null))) {
                        throw new ConcurrentModificationException();
                    }
                    this.reset();
                    this.setOriginalPreferences(portalPreferencesImpl.getOriginalPreferences());
                    this.setOriginalXML(portalPreferences.getPreferences());
                    this._portalPreferences = portalPreferences;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private String _encodeKey(String namespace, String key) {
        if (Validator.isNull((String)namespace)) {
            return key;
        }
        return namespace.concat("#").concat(key);
    }

    private com.liferay.portal.kernel.model.PortalPreferences _reload(final long ownerId, final int ownerType) throws Throwable {
        return (com.liferay.portal.kernel.model.PortalPreferences)TransactionInvokerUtil.invoke((TransactionConfig)SUPPORTS_TRANSACTION_CONFIG, (Callable)new Callable<com.liferay.portal.kernel.model.PortalPreferences>(){

            @Override
            public com.liferay.portal.kernel.model.PortalPreferences call() {
                return PortalPreferencesUtil.fetchByO_O((long)ownerId, (int)ownerType, (boolean)false);
            }
        });
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.SUPPORTS);
        builder.setReadOnly(true);
        builder.setRollbackForClasses(new Class[]{PortalException.class, SystemException.class});
        SUPPORTS_TRANSACTION_CONFIG = builder.build();
        _log = LogFactoryUtil.getLog(PortalPreferencesImpl.class);
    }
}

