/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.persistence.impl;

import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.announcements.kernel.service.persistence.AnnouncementsEntryFinder;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.announcements.model.impl.AnnouncementsEntryImpl;
import com.liferay.portlet.announcements.service.persistence.impl.AnnouncementsEntryFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnouncementsEntryFinderImpl
extends AnnouncementsEntryFinderBaseImpl
implements AnnouncementsEntryFinder {
    public static final String COUNT_BY_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".countByHidden";
    public static final String COUNT_BY_NOT_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".countByNotHidden";
    public static final String FIND_BY_DISPLAY_DATE = AnnouncementsEntryFinder.class.getName() + ".findByDisplayDate";
    public static final String FIND_BY_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".findByHidden";
    public static final String FIND_BY_NOT_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".findByNotHidden";

    public int countByScope(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get((String)COUNT_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace((String)sql, (String)"[$CLASS_PKS$]", (String)this.getClassPKs(classNameId, classPKs));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setClassPKs(qPos, classNameId, classPKs);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            qPos.add(userId);
            qPos.add(2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByScopes(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get((String)COUNT_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace((String)sql, (String)"[$CLASS_PKS$]", (String)this.getClassPKs(scopes));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setClassPKs(qPos, scopes);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            qPos.add(userId);
            qPos.add(2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AnnouncementsEntry> findByDisplayDate(Date displayDateLT, Date displayDateGT) {
        Timestamp displayDateLT_TS = CalendarUtil.getTimestamp((Date)displayDateLT);
        Timestamp displayDateGT_TS = CalendarUtil.getTimestamp((Date)displayDateGT);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_DISPLAY_DATE);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AnnouncementsEntry", AnnouncementsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(displayDateGT_TS);
            qPos.add(displayDateLT_TS);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AnnouncementsEntry> findByScope(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get((String)FIND_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace((String)sql, (String)"[$CLASS_PKS$]", (String)this.getClassPKs(classNameId, classPKs));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AnnouncementsEntry", AnnouncementsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setClassPKs(qPos, classNameId, classPKs);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            qPos.add(userId);
            qPos.add(2);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AnnouncementsEntry> findByScopes(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get((String)FIND_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace((String)sql, (String)"[$CLASS_PKS$]", (String)this.getClassPKs(scopes));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AnnouncementsEntry", AnnouncementsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setClassPKs(qPos, scopes);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            qPos.add(userId);
            qPos.add(2);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getClassPKs(LinkedHashMap<Long, long[]> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(scopes.size() * 4);
        for (Map.Entry<Long, long[]> entry : scopes.entrySet()) {
            Long classNameId = entry.getKey();
            long[] classPKs = entry.getValue();
            sb.append("(");
            sb.append(this.getClassPKs(classNameId, classPKs));
            sb.append(")");
            sb.append(" OR ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    protected String getClassPKs(long classNameId, long[] classPKs) {
        if (classPKs.length == 0) {
            return "(AnnouncementsEntry.classNameId = ?) AND (";
        }
        StringBundler sb = new StringBundler(classPKs.length * 2 + 1);
        sb.append("(AnnouncementsEntry.classNameId = ?) AND (");
        for (int i = 0; i < classPKs.length; ++i) {
            sb.append("(AnnouncementsEntry.classPK = ?)");
            if (i + 1 < classPKs.length) {
                sb.append(" OR ");
                continue;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    protected void setClassPKs(QueryPos qPos, LinkedHashMap<Long, long[]> scopes) {
        if (scopes == null) {
            return;
        }
        for (Map.Entry<Long, long[]> entry : scopes.entrySet()) {
            Long classNameId = entry.getKey();
            long[] classPKs = entry.getValue();
            this.setClassPKs(qPos, classNameId, classPKs);
        }
    }

    protected void setClassPKs(QueryPos qPos, long classNameId, long[] classPKs) {
        qPos.add(classNameId);
        for (int i = 0; i < classPKs.length; ++i) {
            qPos.add(classPKs[i]);
        }
    }

    protected void setDates(QueryPos qPos, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute) {
        Date displayDate = null;
        try {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, null);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        if (displayDate == null) {
            displayDate = new Date();
        }
        Timestamp displayDateTS = CalendarUtil.getTimestamp(displayDate);
        Date expirationDate = null;
        try {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, null);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        if (expirationDate == null) {
            expirationDate = new Date();
        }
        Timestamp expirationDateTS = CalendarUtil.getTimestamp(expirationDate);
        qPos.add(displayDateTS);
        qPos.add(displayDateTS);
        qPos.add(expirationDateTS);
        qPos.add(expirationDateTS);
    }
}

