/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.DuplicateVocabularyException;
import com.liferay.asset.kernel.exception.VocabularyNameException;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.service.base.AssetVocabularyLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyLocalServiceImpl
extends AssetVocabularyLocalServiceBaseImpl {
    public AssetVocabulary addDefaultVocabulary(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(LocaleUtil.getSiteDefault(), PropsValues.ASSET_VOCABULARY_DEFAULT);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        return this.assetVocabularyLocalService.addVocabulary(defaultUserId, groupId, "", titleMap, null, "", serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary addVocabulary(long userId, long groupId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        this.validate(groupId, name);
        long vocabularyId = this.counterLocalService.increment();
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
        vocabulary.setUuid(serviceContext.getUuid());
        vocabulary.setGroupId(groupId);
        vocabulary.setCompanyId(user.getCompanyId());
        vocabulary.setUserId(user.getUserId());
        vocabulary.setUserName(user.getFullName());
        vocabulary.setName(name);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        } else {
            vocabulary.setTitleMap(titleMap);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addVocabularyResources(vocabulary, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addVocabularyResources(vocabulary, serviceContext.getModelPermissions());
        }
        return vocabulary;
    }

    public AssetVocabulary addVocabulary(long userId, long groupId, String title, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, "");
        return this.assetVocabularyLocalService.addVocabulary(userId, groupId, title, titleMap, descriptionMap, null, serviceContext);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), modelPermissions);
    }

    public void deleteVocabularies(long groupId) throws PortalException {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.assetVocabularyLocalService.deleteVocabulary(vocabulary);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public AssetVocabulary deleteVocabulary(AssetVocabulary vocabulary) throws PortalException {
        this.assetVocabularyPersistence.remove((BaseModel)vocabulary);
        this.resourceLocalService.deleteResource(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), 4, vocabulary.getVocabularyId());
        this.assetCategoryLocalService.deleteVocabularyCategories(vocabulary.getVocabularyId());
        return vocabulary;
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        this.assetVocabularyLocalService.deleteVocabulary(vocabulary);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) {
        return this.assetVocabularyPersistence.findByCompanyId(companyId);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) {
        return this.getGroupsVocabularies(groupIds, className, -1L);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className, long classTypePK) {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupIds);
        if (Validator.isNull((String)className)) {
            return vocabularies;
        }
        return AssetUtil.filterVocabularies(vocabularies, className, classTypePK);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException {
        return this.getGroupVocabularies(groupId, true);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean addDefaultVocabulary) throws PortalException {
        ArrayList<AssetVocabulary> vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        if (!vocabularies.isEmpty() || !addDefaultVocabulary) {
            return vocabularies;
        }
        AssetVocabulary vocabulary = this.addDefaultVocabulary(groupId);
        vocabularies = new ArrayList<AssetVocabulary>();
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) {
        return this.assetVocabularyFinder.findByG_N(groupId, name, start, end, obc);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds) {
        return this.assetVocabularyPersistence.findByGroupId(groupIds);
    }

    public int getGroupVocabulariesCount(long[] groupIds) {
        return this.assetVocabularyPersistence.countByGroupId(groupIds);
    }

    public AssetVocabulary getGroupVocabulary(long groupId, String name) throws PortalException {
        return this.assetVocabularyPersistence.findByG_N(groupId, name);
    }

    public List<AssetVocabulary> getVocabularies(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>(documents.size());
        for (Document document : documents) {
            long vocabularyId = GetterUtil.getLong((String)document.get("assetVocabularyId"));
            AssetVocabulary vocabulary = this.fetchAssetVocabulary(vocabularyId);
            if (vocabulary == null) {
                vocabularies = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetVocabulary.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (vocabularies == null) continue;
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }

    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException {
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>();
        for (long vocabularyId : vocabularyIds) {
            AssetVocabulary vocabulary = this.getVocabulary(vocabularyId);
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException {
        return this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
    }

    public BaseModelSearchResult<AssetVocabulary> searchVocabularies(long companyId, long groupId, String title, int start, int end) throws PortalException {
        return this.searchVocabularies(companyId, groupId, title, start, end, null);
    }

    public BaseModelSearchResult<AssetVocabulary> searchVocabularies(long companyId, long groupId, String title, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, title, start, end, sort);
        return this.searchVocabularies(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        if (!vocabulary.getName().equals(name)) {
            this.validate(vocabulary.getGroupId(), name);
        }
        vocabulary.setName(name);
        vocabulary.setTitleMap(titleMap);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        return vocabulary;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, String title, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("title", (Serializable)((Object)title));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(title);
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected boolean hasVocabulary(long groupId, String name) {
        return this.assetVocabularyPersistence.countByG_N(groupId, name) != 0;
    }

    protected BaseModelSearchResult<AssetVocabulary> searchVocabularies(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetVocabulary.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetVocabulary> vocabularies = this.getVocabularies(hits);
            if (vocabularies == null) continue;
            return new BaseModelSearchResult(vocabularies, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new VocabularyNameException("Category vocabulary name cannot be null for group " + groupId);
        }
        if (this.hasVocabulary(groupId, name)) {
            throw new DuplicateVocabularyException("A category vocabulary with the name " + name + " already exists");
        }
    }
}

