/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portlet.exportimport.service.base.StagingServiceBaseImpl;
import java.util.Map;

public class StagingServiceImpl
extends StagingServiceBaseImpl {
    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        this.checkPermission(stagingRequestId);
        this.stagingLocalService.cleanUpStagingRequest(stagingRequestId);
    }

    public long createStagingRequest(long groupId, String checksum) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.stagingLocalService.createStagingRequest(this.getUserId(), groupId, checksum);
    }

    @Deprecated
    public MissingReferences publishStagingRequest(long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, privateLayout, parameterMap);
    }

    public MissingReferences publishStagingRequest(long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, exportImportConfiguration);
    }

    public void updateStagingRequest(long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        this.checkPermission(stagingRequestId);
        this.stagingLocalService.updateStagingRequest(this.getUserId(), stagingRequestId, fileName, bytes);
    }

    @Deprecated
    public MissingReferences validateStagingRequest(long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.validateStagingRequest(this.getUserId(), stagingRequestId, privateLayout, parameterMap);
    }

    protected void checkPermission(long stagingRequestId) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)folder.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
    }
}

