/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class JavadocCheck
extends AbstractCheck {
    public static final String MSG_EMPTY_LINE = "javadoc.empty.line";
    public static final String MSG_INCORRECT_FIRST_LINE = "javadoc.incorrect.first.line";
    public static final String MSG_INCORRECT_LAST_LINE = "javadoc.incorrect.last.line";
    public static final String MSG_MULTIPLE_JAVADOC = "javadoc.multiple";

    public int[] getDefaultTokens() {
        return new int[]{157, 161, 14, 8, 155, 154, 15, 9, 16, 10};
    }

    public void visitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        TextBlock javadoc = fileContents.getJavadocBefore(detailAST.getLineNo());
        if (javadoc == null) {
            return;
        }
        this._checkJavadoc(javadoc);
        javadoc = fileContents.getJavadocBefore(javadoc.getStartLineNo());
        if (javadoc != null) {
            DetailAST nameAST = detailAST.findFirstToken(58);
            this.log(detailAST.getLineNo(), MSG_MULTIPLE_JAVADOC, new Object[]{nameAST.getText()});
        }
    }

    private void _checkJavadoc(TextBlock javadoc) {
        String[] text = javadoc.getText();
        this._checkLine(javadoc, text, 1, "/**", MSG_INCORRECT_FIRST_LINE, true);
        this._checkLine(javadoc, text, 2, "*", MSG_EMPTY_LINE, false);
        this._checkLine(javadoc, text, text.length - 1, "*", MSG_EMPTY_LINE, false);
        this._checkLine(javadoc, text, text.length, "*/", MSG_INCORRECT_LAST_LINE, true);
    }

    private void _checkLine(TextBlock javadoc, String[] text, int lineNumber, String expectedValue, String message, boolean match) {
        String line = StringUtil.trim(text[lineNumber - 1]);
        if (match && !line.equals(expectedValue) || !match && line.equals(expectedValue)) {
            this.log(javadoc.getStartLineNo() + lineNumber - 1, message, new Object[0]);
        }
    }
}

