/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ValidatorIsNullCheck
extends AbstractCheck {
    public static final String MSG_METHOD_INVALID_NAME = "method.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void visitToken(DetailAST detailAST) {
        this._checkMethod(detailAST, "Validator", "isNotNull");
        this._checkMethod(detailAST, "Validator", "isNull");
    }

    private void _checkMethod(DetailAST detailAST, String className, String methodName) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST typeAST;
            DetailAST elistAST = methodCallAST.findFirstToken(34);
            DetailAST expressionAST = elistAST.findFirstToken(28);
            DetailAST child = expressionAST.getFirstChild();
            if (child.getType() == 137) {
                this.log(methodCallAST.getLineNo(), MSG_METHOD_INVALID_NAME, new Object[]{className + "." + methodName + "(long)"});
                continue;
            }
            if (child.getType() != 58 || (typeAST = DetailASTUtil.findTypeAST(detailAST, child.getText())) == null || (child = typeAST.getFirstChild()).getType() != 54 && child.getType() != 56) continue;
            this.log(methodCallAST.getLineNo(), MSG_METHOD_INVALID_NAME, new Object[]{className + "." + methodName + "(long)"});
        }
    }
}

