/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.server;

import com.liferay.portal.fabric.agent.FabricAgentRegistry;
import com.liferay.portal.fabric.netty.codec.serialization.AnnotatedObjectDecoder;
import com.liferay.portal.fabric.netty.codec.serialization.AnnotatedObjectEncoder;
import com.liferay.portal.fabric.netty.fileserver.FileHelperUtil;
import com.liferay.portal.fabric.netty.fileserver.handlers.FileRequestChannelHandler;
import com.liferay.portal.fabric.netty.handlers.NettyFabricAgentRegistrationChannelHandler;
import com.liferay.portal.fabric.netty.rpc.handlers.NettyRPCChannelHandler;
import com.liferay.portal.fabric.netty.server.NettyFabricServerConfig;
import com.liferay.portal.fabric.netty.util.NettyUtil;
import com.liferay.portal.fabric.server.FabricServer;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NettyFabricServer
implements FabricServer {
    private static final Log _log = LogFactoryUtil.getLog(NettyFabricServer.class);
    private final FabricAgentRegistry _fabricAgentRegistry;
    private final NettyFabricServerConfig _nettyFabricServerConfig;
    private volatile Channel _serverChannel;

    public NettyFabricServer(FabricAgentRegistry fabricAgentRegistry, NettyFabricServerConfig nettyFabricServerConfig) {
        this._fabricAgentRegistry = fabricAgentRegistry;
        this._nettyFabricServerConfig = nettyFabricServerConfig;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this._serverChannel != null) {
            throw new IllegalStateException("Netty fabric server was already started");
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Starting Netty fabric server using " + this._nettyFabricServerConfig));
        }
        Files.createDirectories(this._nettyFabricServerConfig.getRepositoryParentPath(), new FileAttribute[0]);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO));
        serverBootstrap.childHandler((ChannelHandler)new ChildChannelInitializer());
        NioEventLoopGroup bossEventLoopGroup = new NioEventLoopGroup(this._nettyFabricServerConfig.getBossGroupThreadCount(), (ThreadFactory)new NamedThreadFactory("Netty Fabric Server/Boss Event Loop Group", 5, null));
        NioEventLoopGroup workerEventLoopGroup = new NioEventLoopGroup(this._nettyFabricServerConfig.getWorkerGroupThreadCount(), (ThreadFactory)new NamedThreadFactory("Netty Fabric Server/Worker Event Loop Group", 5, null));
        NettyUtil.bindShutdown((EventExecutorGroup)bossEventLoopGroup, (EventExecutorGroup)workerEventLoopGroup, this._nettyFabricServerConfig.getShutdownQuietPeriod(), this._nettyFabricServerConfig.getShutdownTimeout());
        serverBootstrap.group((EventLoopGroup)bossEventLoopGroup, (EventLoopGroup)workerEventLoopGroup);
        ChannelFuture channelFuture = serverBootstrap.bind(this._nettyFabricServerConfig.getNettyFabricServerHost(), this._nettyFabricServerConfig.getNettyFabricServerPort());
        this._serverChannel = channelFuture.channel();
        channelFuture.addListener((GenericFutureListener)new PostBindChannelFutureListener());
        channelFuture.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized java.util.concurrent.Future<?> stop() throws InterruptedException {
        if (this._serverChannel == null) {
            throw new IllegalStateException("Netty fabric server is not started");
        }
        EventLoop eventLoop = this._serverChannel.eventLoop();
        EventLoopGroup bossEventLoopGroup = eventLoop.parent();
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        try {
            ChannelFuture channelFuture = this._serverChannel.close();
            channelFuture.sync();
        }
        finally {
            Future future = bossEventLoopGroup.shutdownGracefully(this._nettyFabricServerConfig.getShutdownQuietPeriod(), this._nettyFabricServerConfig.getShutdownTimeout(), TimeUnit.MILLISECONDS);
            future.addListener((GenericFutureListener)new PostShutdownChannelListener((Runnable)defaultNoticeableFuture));
        }
        return defaultNoticeableFuture;
    }

    protected EventExecutorGroup createEventExecutorGroup(int threadCount, String threadPoolName) {
        DefaultEventExecutorGroup eventExecutorGroup = new DefaultEventExecutorGroup(threadCount, (ThreadFactory)new NamedThreadFactory(threadPoolName, 5, null));
        EventLoop eventLoop = this._serverChannel.eventLoop();
        NettyUtil.bindShutdown((EventExecutorGroup)eventLoop.parent(), (EventExecutorGroup)eventExecutorGroup, this._nettyFabricServerConfig.getShutdownQuietPeriod(), this._nettyFabricServerConfig.getShutdownTimeout());
        return eventExecutorGroup;
    }

    protected class PostShutdownChannelListener
    implements FutureListener<Object> {
        protected final Runnable runnable;

        public void operationComplete(Future<Object> future) throws InterruptedException {
            FileHelperUtil.delete(NettyFabricServer.this._nettyFabricServerConfig.getRepositoryParentPath());
            NettyFabricServer.this._serverChannel = null;
            if (!ThreadDeathWatcher.awaitInactivity((long)NettyFabricServer.this._nettyFabricServerConfig.getShutdownTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)) {
                _log.error((Object)"Unable to stop thread death watcher");
            }
            this.runnable.run();
        }

        protected PostShutdownChannelListener(Runnable runnable) {
            this.runnable = runnable;
        }
    }

    protected class PostBindChannelFutureListener
    implements ChannelFutureListener {
        protected PostBindChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture channelFuture) throws InterruptedException {
            Channel channel = channelFuture.channel();
            if (channelFuture.isSuccess()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Started Netty fabric server on " + channel.localAddress()));
                }
                return;
            }
            String serverAddress = NettyFabricServer.this._nettyFabricServerConfig.getNettyFabricServerHost() + ":" + NettyFabricServer.this._nettyFabricServerConfig.getNettyFabricServerPort();
            if (channelFuture.isCancelled()) {
                _log.error((Object)("Cancelled starting Netty fabric server on " + serverAddress));
            } else {
                _log.error((Object)("Unable to start Netty fabric server on " + serverAddress), channelFuture.cause());
            }
            NettyFabricServer.this.stop();
        }
    }

    protected class ChildChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        protected ChildChannelInitializer() {
        }

        protected void initChannel(SocketChannel socketChannel) {
            ChannelPipeline channelPipeline = socketChannel.pipeline();
            channelPipeline.addLast(AnnotatedObjectEncoder.NAME, (ChannelHandler)AnnotatedObjectEncoder.INSTANCE);
            channelPipeline.addLast(AnnotatedObjectDecoder.NAME, (ChannelHandler)new AnnotatedObjectDecoder());
            channelPipeline.addLast(NettyFabricServer.this.createEventExecutorGroup(NettyFabricServer.this._nettyFabricServerConfig.getRPCGroupThreadCount(), "Netty Fabric Server/RPC Event Executor Group"), NettyRPCChannelHandler.NAME, (ChannelHandler)NettyRPCChannelHandler.INSTANCE);
            EventExecutorGroup fileServerEventExecutorGroup = NettyFabricServer.this.createEventExecutorGroup(NettyFabricServer.this._nettyFabricServerConfig.getFileServerGroupThreadCount(), "Netty Fabric Server/File Server Event Executor Group");
            channelPipeline.addLast(fileServerEventExecutorGroup, FileRequestChannelHandler.NAME, (ChannelHandler)new FileRequestChannelHandler(NettyFabricServer.this._nettyFabricServerConfig.getFileServerFolderCompressionLevel()));
            channelPipeline.addLast(NettyFabricServer.this.createEventExecutorGroup(NettyFabricServer.this._nettyFabricServerConfig.getRegistrationGroupThreadCount(), "Netty Fabric Server/Registration Event Executor Group"), new ChannelHandler[]{new NettyFabricAgentRegistrationChannelHandler(NettyFabricServer.this._fabricAgentRegistry, NettyFabricServer.this._nettyFabricServerConfig.getRepositoryParentPath(), fileServerEventExecutorGroup, NettyFabricServer.this._nettyFabricServerConfig.getRepositoryGetFileTimeout(), NettyFabricServer.this._nettyFabricServerConfig.getRPCRelayTimeout(), NettyFabricServer.this._nettyFabricServerConfig.getWorkerStartupTimeout())});
        }
    }
}

