/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;

@ProviderType
public class RepositoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RepositoryServiceHttp.class);
    private static final Class<?>[] _addRepositoryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, UnicodeProperties.class, ServiceContext.class};
    private static final Class<?>[] _checkRepositoryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteRepositoryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRepositoryParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSupportedConfigurationsParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSupportedParametersParameterTypes5 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getSupportedParametersParameterTypes6 = new Class[]{String.class, String.class};
    private static final Class<?>[] _getTypeSettingsPropertiesParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateRepositoryParameterTypes8 = new Class[]{Long.TYPE, String.class, String.class};

    public static Repository addRepository(HttpPrincipal httpPrincipal, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "addRepository", (Class[])_addRepositoryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void checkRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "checkRepository", (Class[])_checkRepositoryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "deleteRepository", (Class[])_deleteRepositoryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Repository getRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getRepository", (Class[])_getRepositoryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String[] getSupportedConfigurations(HttpPrincipal httpPrincipal, long classNameId) {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getSupportedConfigurations", (Class[])_getSupportedConfigurationsParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (String[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String[] getSupportedParameters(HttpPrincipal httpPrincipal, long classNameId, String configuration) {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getSupportedParameters", (Class[])_getSupportedParametersParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId, configuration});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (String[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String[] getSupportedParameters(HttpPrincipal httpPrincipal, String className, String configuration) {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getSupportedParameters", (Class[])_getSupportedParametersParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, configuration});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (String[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static UnicodeProperties getTypeSettingsProperties(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "getTypeSettingsProperties", (Class[])_getTypeSettingsPropertiesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (UnicodeProperties)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateRepository(HttpPrincipal httpPrincipal, long repositoryId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class, "updateRepository", (Class[])_updateRepositoryParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId, name, description});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

