/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.DuplicateGroupException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.GroupInheritContentException;
import com.liferay.portal.kernel.exception.GroupKeyException;
import com.liferay.portal.kernel.exception.GroupParentException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.exception.PendingBackgroundTaskException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.ResourceTypePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.UserPersonalSite;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.RolePermissions;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupIdComparator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.GroupLocalServiceBaseImpl;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class GroupLocalServiceImpl
extends GroupLocalServiceBaseImpl {
    public static final String ORGANIZATION_NAME_SUFFIX = " LFR_ORGANIZATION";
    public static final String ORGANIZATION_STAGING_SUFFIX = " (Staging)";
    protected File publicLARFile;
    private static final Log _log = LogFactoryUtil.getLog(GroupLocalServiceImpl.class);
    private volatile long[] _classNameIds;
    private volatile long[] _complexSQLClassNameIds;
    private final Map<String, Group> _systemGroupsMap = new HashMap<String, Group>();

    public GroupLocalServiceImpl() {
        this.initImportLARFile();
    }

    public Group addGroup(long userId, long parentGroupId, String className, long classPK, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        User screenNameUser;
        User user = this.userPersistence.findByPrimaryKey(userId);
        className = GetterUtil.getString((String)className);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        String groupKey = "";
        String friendlyName = "";
        if (nameMap != null) {
            groupKey = nameMap.get(LocaleUtil.getDefault());
            friendlyName = nameMap.get(LocaleUtil.getDefault());
        }
        long groupId = 0L;
        do {
            groupId = this.counterLocalService.increment();
        } while ((screenNameUser = this.userPersistence.fetchByC_SN(user.getCompanyId(), String.valueOf(groupId))) != null);
        boolean staging = this.isStaging(serviceContext);
        long groupClassNameId = this.classNameLocalService.getClassNameId(Group.class);
        if (classNameId <= 0L || className.equals(Group.class.getName()) || className.equals(Company.class.getName()) && staging) {
            className = Group.class.getName();
            classNameId = groupClassNameId;
            classPK = groupId;
        } else if (className.equals(Organization.class.getName())) {
            groupKey = this.getOrgGroupName(groupKey);
        } else if (!"User Personal Site".equals(groupKey)) {
            groupKey = String.valueOf(classPK);
        }
        if (className.equals(Organization.class.getName()) && staging) {
            classPK = liveGroupId;
        }
        if (className.equals(Layout.class.getName())) {
            Layout layout = this.layoutLocalService.getLayout(classPK);
            parentGroupId = layout.getGroupId();
        }
        friendlyURL = this.getFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyName, friendlyURL);
        if (staging) {
            groupKey = groupKey.concat("-staging");
            for (Map.Entry entry : nameMap.entrySet()) {
                String name = (String)entry.getValue();
                if (Validator.isNull((String)name)) continue;
                nameMap.put((Locale)entry.getKey(), name.concat(ORGANIZATION_STAGING_SUFFIX));
            }
            friendlyURL = this.getFriendlyURL(friendlyURL.concat("-staging"));
        }
        if (parentGroupId == 0L) {
            membershipRestriction = 0;
        }
        if (className.equals(Group.class.getName()) ? !site && liveGroupId == 0L && !groupKey.equals("Control Panel") && !groupKey.equals("Forms") : !className.equals(Company.class.getName()) && !className.equals(Organization.class.getName()) && className.startsWith("com.liferay.portal.kernel.model.") && site) {
            throw new IllegalArgumentException();
        }
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            this.validateGroupKey(groupId, user.getCompanyId(), groupKey, site);
        }
        this.validateInheritContent(parentGroupId, inheritContent);
        this.validateFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyURL);
        this.validateParentGroup(groupId, parentGroupId);
        Group group = this.groupPersistence.create(groupId);
        if (serviceContext != null) {
            group.setUuid(serviceContext.getUuid());
        }
        group.setCompanyId(user.getCompanyId());
        group.setCreatorUserId(userId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setParentGroupId(parentGroupId);
        group.setLiveGroupId(liveGroupId);
        group.setTreePath(group.buildTreePath());
        group.setGroupKey(groupKey);
        group.setNameMap(nameMap);
        group.setDescriptionMap(descriptionMap);
        group.setType(type);
        group.setManualMembership(manualMembership);
        group.setMembershipRestriction(membershipRestriction);
        group.setFriendlyURL(friendlyURL);
        group.setInheritContent(inheritContent);
        group.setSite(site);
        group.setActive(active);
        if (serviceContext != null && classNameId == groupClassNameId && !user.isDefaultUser()) {
            group.setExpandoBridgeAttributes(serviceContext);
        }
        this.groupPersistence.update((BaseModel)group);
        this.layoutSetLocalService.addLayoutSet(groupId, true);
        this.layoutSetLocalService.addLayoutSet(groupId, false);
        this.resourceLocalService.addResources(group.getCompanyId(), 0L, 0L, Group.class.getName(), group.getGroupId(), false, false, false);
        if (classNameId == groupClassNameId && !user.isDefaultUser()) {
            Role role = this.roleLocalService.getRole(group.getCompanyId(), "Site Owner");
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, new long[]{role.getRoleId()});
            this.userLocalService.addGroupUsers(group.getGroupId(), new long[]{userId});
            if (serviceContext != null) {
                this.updateAsset(userId, group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
            }
        }
        this.addPortletDefaultData(group);
        return group;
    }

    public Group addGroup(long userId, long parentGroupId, String className, long classPK, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.addGroup(userId, parentGroupId, className, classPK, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, false, active, serviceContext);
    }

    @Deprecated
    public Group addGroup(long userId, long parentGroupId, String className, long classPK, long liveGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.addGroup(userId, parentGroupId, className, classPK, liveGroupId, this.getLocalizationMap(name), this.getLocalizationMap(description), type, manualMembership, membershipRestriction, friendlyURL, site, false, active, serviceContext);
    }

    @Override
    public void addRoleGroups(long roleId, long[] groupIds) {
        this.rolePersistence.addGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addUserGroups(long userId, long[] groupIds) {
        this.userPersistence.addGroups(userId, groupIds);
        PermissionCacheUtil.clearCache(userId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkCompanyGroup(long companyId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Company.class);
        int count = this.groupPersistence.countByC_C_C(companyId, classNameId, companyId);
        if (count == 0) {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.groupLocalService.addGroup(defaultUserId, 0L, Company.class.getName(), companyId, 0L, this.getLocalizationMap("Global"), null, 0, true, 0, "/global", true, true, null);
        }
    }

    public Group checkScopeGroup(Layout layout, long userId) throws PortalException {
        if (layout.hasScopeGroup()) {
            return layout.getScopeGroup();
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), String.valueOf(layout.getPlid()));
        Group scopeGroup = this.groupLocalService.addGroup(userId, 0L, Layout.class.getName(), layout.getPlid(), 0L, nameMap, null, 0, true, 0, null, false, true, null);
        return scopeGroup;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemGroups(long companyId) throws PortalException {
        String[] systemGroups;
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        for (Group group : this.groupFinder.findBySystem(companyId)) {
            this._systemGroupsMap.put(companyIdHexString.concat(group.getGroupKey()), group);
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        for (String groupKey : systemGroups = PortalUtil.getSystemGroups()) {
            LayoutSet layoutSet;
            String groupCacheKey = companyIdHexString.concat(groupKey);
            Group group = this._systemGroupsMap.get(groupCacheKey);
            if (group == null) {
                group = this.groupPersistence.fetchByC_GK(companyId, groupKey);
            }
            if (group == null) {
                String className = null;
                long classPK = 0L;
                int type = 1;
                String friendlyURL = null;
                boolean site = true;
                if (groupKey.equals("Control Panel")) {
                    type = 3;
                    friendlyURL = "/control_panel";
                    site = false;
                } else if (groupKey.equals("Forms")) {
                    type = 3;
                    friendlyURL = "/forms";
                    site = false;
                } else if (groupKey.equals("Guest")) {
                    friendlyURL = "/guest";
                } else if (groupKey.equals("User Personal Site")) {
                    className = UserPersonalSite.class.getName();
                    classPK = defaultUserId;
                    type = 3;
                    friendlyURL = "/personal_site";
                    site = false;
                }
                group = this.groupLocalService.addGroup(defaultUserId, 0L, className, classPK, 0L, this.getLocalizationMap(groupKey), null, type, true, 0, friendlyURL, site, true, null);
                if (groupKey.equals("User Personal Site")) {
                    this.initUserPersonalSitePermissions(group);
                }
            }
            if (group.isControlPanel() && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), true)).getPageCount() == 0) {
                this.addControlPanelLayouts(group);
            }
            if (group.isGuest() && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), false)).getPageCount() == 0) {
                this.addDefaultGuestPublicLayouts(group);
            }
            this._systemGroupsMap.put(groupCacheKey, group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group deleteGroup(Group group) throws PortalException {
        boolean deleteInProcess = GroupThreadLocal.isDeleteInProcess();
        try {
            ThemeLoader themeLoader;
            GroupThreadLocal.setDeleteInProcess((boolean)true);
            if ((group.isCompany() && !group.isCompanyStagingGroup() || PortalUtil.isSystemGroup((String)group.getGroupKey())) && !CompanyThreadLocal.isDeleteInProcess()) {
                throw new RequiredGroupException.MustNotDeleteSystemGroup(group.getGroupId());
            }
            if (this.groupPersistence.countByC_P_S(group.getCompanyId(), group.getGroupId(), true) > 0) {
                throw new RequiredGroupException.MustNotDeleteGroupThatHasChild(group.getGroupId());
            }
            List backgroundTasks = BackgroundTaskManagerUtil.getBackgroundTasks((long)group.getGroupId(), (int)1);
            if (!backgroundTasks.isEmpty()) {
                throw new PendingBackgroundTaskException("Unable to delete group with pending background tasks");
            }
            BackgroundTaskManagerUtil.deleteGroupBackgroundTasks((long)group.getGroupId());
            this.layoutSetBranchLocalService.deleteLayoutSetBranches(group.getGroupId(), true, true);
            this.layoutSetBranchLocalService.deleteLayoutSetBranches(group.getGroupId(), false, true);
            ServiceContext serviceContext = new ServiceContext();
            try {
                this.layoutSetLocalService.deleteLayoutSet(group.getGroupId(), true, serviceContext);
            }
            catch (NoSuchLayoutSetException noSuchLayoutSetException) {
                // empty catch block
            }
            try {
                this.layoutSetLocalService.deleteLayoutSet(group.getGroupId(), false, serviceContext);
            }
            catch (NoSuchLayoutSetException noSuchLayoutSetException) {
                // empty catch block
            }
            this.membershipRequestLocalService.deleteMembershipRequests(group.getGroupId());
            this.portletPreferencesLocalService.deletePortletPreferences(group.getGroupId(), 2, 0L);
            this.dlAppLocalService.deleteAllRepositories(group.getGroupId());
            this.teamLocalService.deleteTeams(group.getGroupId());
            this.exportImportConfigurationLocalService.deleteExportImportConfigurations(group.getGroupId());
            this.unscheduleStaging(group);
            if (group.hasStagingGroup()) {
                try {
                    this.stagingLocalService.disableStaging(group, serviceContext);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to disable staging for group " + group.getGroupId()));
                }
            }
            if ((themeLoader = ThemeLoaderFactory.getDefaultThemeLoader()) != null) {
                String themePath = themeLoader.getFileStorage() + "/" + group.getGroupId();
                FileUtil.deltree((String)(themePath + "-private"));
                FileUtil.deltree((String)(themePath + "-public"));
            }
            this.deletePortletData(group);
            if (group.isRegularSite()) {
                this.assetEntryLocalService.deleteEntry(Group.class.getName(), group.getGroupId());
            }
            this.assetEntryLocalService.deleteGroupEntries(group.getGroupId());
            this.assetTagLocalService.deleteGroupTags(group.getGroupId());
            this.assetVocabularyLocalService.deleteVocabularies(group.getGroupId());
            this.expandoRowLocalService.deleteRows(group.getGroupId());
            this.socialActivityLocalService.deleteActivities(group.getGroupId());
            this.socialActivitySettingLocalService.deleteActivitySettings(group.getGroupId());
            this.socialRequestLocalService.deleteRequests(this.classNameLocalService.getClassNameId(Group.class), group.getGroupId());
            List resourcePermissions = this.resourcePermissionPersistence.findByC_S_P(group.getCompanyId(), 2, String.valueOf(group.getGroupId()));
            for (Object resourcePermission : resourcePermissions) {
                this.resourcePermissionLocalService.deleteResourcePermission((ResourcePermission)resourcePermission);
            }
            this.trashEntryLocalService.deleteEntries(group.getGroupId());
            List scopeableWorkflowHandlers = WorkflowHandlerRegistryUtil.getScopeableWorkflowHandlers();
            for (WorkflowHandler scopeableWorkflowHandler : scopeableWorkflowHandlers) {
                WorkflowDefinitionLink workflowDefinitionLink;
                if (!scopeableWorkflowHandler.isVisible() || (workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), scopeableWorkflowHandler.getClassName(), 0L, 0L, true)) == null || workflowDefinitionLink.getGroupId() == group.getLiveGroupId()) continue;
                this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
            }
            if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
                group.setSite(false);
                this.groupPersistence.update((BaseModel)group);
                this.userGroupRoleLocalService.deleteUserGroupRoles(group.getGroupId(), 2);
                this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(group.getGroupId(), 2);
            } else {
                block21: {
                    this.userGroupRoleLocalService.deleteUserGroupRolesByGroupId(group.getGroupId());
                    this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByGroupId(group.getGroupId());
                    try {
                        this.resourceLocalService.deleteResource(group.getCompanyId(), Group.class.getName(), 4, group.getGroupId());
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block21;
                        _log.warn((Object)("No resources found for group " + group.getGroupId()));
                    }
                }
                this.groupPersistence.remove((BaseModel)group);
            }
            PermissionCacheUtil.clearCache();
            Group group2 = group;
            return group2;
        }
        finally {
            GroupThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    @Override
    public Group deleteGroup(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return this.deleteGroup(group);
    }

    public synchronized void disableStaging(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        int stagingGroupCount = group.getRemoteStagingGroupCount();
        if (stagingGroupCount > 0) {
            group.setRemoteStagingGroupCount(--stagingGroupCount);
            if (stagingGroupCount == 0) {
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                ArrayList<String> keys = new ArrayList<String>();
                for (String key : typeSettingsProperties.keySet()) {
                    if (!key.startsWith("staged-portlet_")) continue;
                    keys.add(key);
                }
                for (String key : keys) {
                    typeSettingsProperties.remove((Object)key);
                }
                group.setTypeSettingsProperties(typeSettingsProperties);
            }
            this.groupPersistence.update((BaseModel)group);
        }
    }

    public synchronized void enableStaging(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        int stagingGroupCount = group.getRemoteStagingGroupCount() + 1;
        group.setRemoteStagingGroupCount(stagingGroupCount);
        this.groupPersistence.update((BaseModel)group);
    }

    public Group fetchCompanyGroup(long companyId) {
        long classNameId = this.classNameLocalService.getClassNameId(Company.class);
        return this.groupPersistence.fetchByC_C_C(companyId, classNameId, companyId);
    }

    public Group fetchFriendlyURLGroup(long companyId, String friendlyURL) {
        if (Validator.isNull((String)friendlyURL)) {
            return null;
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.fetchByC_F(companyId, friendlyURL);
    }

    @Skip
    public Group fetchGroup(long companyId, String groupKey) {
        Group group = this._systemGroupsMap.get(StringUtil.toHexString((long)companyId).concat(groupKey));
        if (group != null) {
            return group;
        }
        return this.groupLocalService.loadFetchGroup(companyId, groupKey);
    }

    public Group fetchUserGroup(long companyId, long userId) {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        return this.groupPersistence.fetchByC_C_C(companyId, classNameId, userId);
    }

    public Group fetchUserPersonalSiteGroup(long companyId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(UserPersonalSite.class);
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        return this.groupPersistence.fetchByC_C_C(companyId, classNameId, defaultUserId);
    }

    public List<Group> getActiveGroups(long companyId, boolean active) {
        return this.groupPersistence.findByC_A(companyId, active);
    }

    public Group getCompanyGroup(long companyId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Company.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, companyId);
    }

    public List<Group> getCompanyGroups(long companyId, int start, int end) {
        return this.groupPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyGroupsCount(long companyId) {
        return this.groupPersistence.countByCompanyId(companyId);
    }

    public Group getFriendlyURLGroup(long companyId, String friendlyURL) throws PortalException {
        if (Validator.isNull((String)friendlyURL)) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.findByC_F(companyId, friendlyURL);
    }

    @Override
    @ThreadLocalCachable
    public Group getGroup(long groupId) throws PortalException {
        return this.groupPersistence.findByPrimaryKey(groupId);
    }

    @Skip
    public Group getGroup(long companyId, String groupKey) throws PortalException {
        Group group = this._systemGroupsMap.get(StringUtil.toHexString((long)companyId).concat(groupKey));
        if (group != null) {
            return group;
        }
        return this.groupLocalService.loadGetGroup(companyId, groupKey);
    }

    @Deprecated
    public String getGroupDescriptiveName(Group group, Locale locale) throws PortalException {
        return group.getDescriptiveName(locale);
    }

    @Deprecated
    public String getGroupDescriptiveName(long groupId, Locale locale) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return group.getDescriptiveName(locale);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site) {
        if (parentGroupId == -1L) {
            return this.groupPersistence.findByC_S(companyId, site);
        }
        return this.groupPersistence.findByC_P_S(companyId, parentGroupId, site);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site, boolean inheritContent) {
        return this.groupPersistence.findByC_P_S_I(companyId, parentGroupId, site, inheritContent);
    }

    public List<Group> getGroups(long companyId, String className, long parentGroupId) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.groupPersistence.findByC_C_P(companyId, classNameId, parentGroupId);
    }

    public List<Group> getGroups(long companyId, String className, long parentGroupId, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.groupPersistence.findByC_C_P(companyId, classNameId, parentGroupId, start, end);
    }

    public List<Group> getGroups(long[] groupIds) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        for (long groupId : groupIds) {
            Group group = this.getGroup(groupId);
            groups.add(group);
        }
        return groups;
    }

    public int getGroupsCount(long companyId, long parentGroupId, boolean site) {
        if (parentGroupId == -1L) {
            return this.groupPersistence.countByC_S(companyId, site);
        }
        return this.groupPersistence.countByC_P_S(companyId, parentGroupId, site);
    }

    public int getGroupsCount(long companyId, String className, long parentGroupId) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.groupPersistence.countByC_C_P(companyId, classNameId, parentGroupId);
    }

    public Group getLayoutGroup(long companyId, long plid) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Layout.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, plid);
    }

    public Group getLayoutPrototypeGroup(long companyId, long layoutPrototypeId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(LayoutPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutPrototypeId);
    }

    public Group getLayoutSetPrototypeGroup(long companyId, long layoutSetPrototypeId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(LayoutSetPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutSetPrototypeId);
    }

    public List<Group> getLayoutsGroups(long companyId, long parentGroupId, boolean site, int start, int end, OrderByComparator<Group> obc) {
        return this.groupFinder.findByLayouts(companyId, parentGroupId, site, start, end, obc);
    }

    public int getLayoutsGroupsCount(long companyId, long parentGroupId, boolean site) {
        return this.groupFinder.countByLayouts(companyId, parentGroupId, site);
    }

    public List<Group> getLiveGroups() {
        return this.groupFinder.findByLiveGroups();
    }

    public List<Group> getNoLayoutsGroups(String className, boolean privateLayout, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.groupFinder.findByNoLayouts(classNameId, privateLayout, start, end);
    }

    public List<Group> getNullFriendlyURLGroups() {
        return this.groupFinder.findByNullFriendlyURL();
    }

    public Group getOrganizationGroup(long companyId, long organizationId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Organization.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, organizationId);
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            Group group = organization.getGroup();
            organizationGroups.add(group);
        }
        return organizationGroups;
    }

    public List<Group> getOrganizationsRelatedGroups(List<Organization> organizations) {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            List groups = this.organizationPersistence.getGroups(organization.getOrganizationId());
            organizationGroups.addAll(groups);
        }
        return organizationGroups;
    }

    public List<Group> getParentGroups(long groupId) throws PortalException {
        if (groupId == 0L) {
            return new ArrayList<Group>();
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return group.getAncestors();
    }

    public List<Group> getStagedSites() {
        return this.groupFinder.findByL_TS_S_RSGC(0L, "staged=true", true, 0);
    }

    public Group getStagingGroup(long liveGroupId) throws PortalException {
        return this.groupPersistence.findByLiveGroupId(liveGroupId);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userId);
    }

    public Group getUserGroupGroup(long companyId, long userGroupId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userGroupId);
    }

    public List<Group> getUserGroups(long userId, boolean inherit) throws PortalException {
        return this.getUserGroups(userId, inherit, -1, -1);
    }

    public List<Group> getUserGroups(long userId, boolean inherit, int start, int end) throws PortalException {
        if (inherit) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
            groupParams.put("usersGroups", userId);
            return this.search(user.getCompanyId(), null, null, groupParams, start, end);
        }
        return this.userPersistence.getGroups(userId, start, end);
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        for (int i = 0; i < userGroups.size(); ++i) {
            UserGroup userGroup = userGroups.get(i);
            Group group = userGroup.getGroup();
            userGroupGroups.add(group);
        }
        return userGroupGroups;
    }

    public List<Group> getUserGroupsRelatedGroups(List<UserGroup> userGroups) {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        for (int i = 0; i < userGroups.size(); ++i) {
            UserGroup userGroup = userGroups.get(i);
            List groups = this.userGroupPersistence.getGroups(userGroup.getUserGroupId());
            userGroupGroups.addAll(groups);
        }
        return userGroupGroups;
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException {
        ArrayList<Group> userOrgsGroups = new ArrayList<Group>();
        List userOrgs = this.organizationLocalService.getUserOrganizations(userId, start, end);
        for (Organization organization : userOrgs) {
            userOrgsGroups.add(0, organization.getGroup());
            if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
            for (Organization ancestorOrganization : organization.getAncestors()) {
                userOrgsGroups.add(0, ancestorOrganization.getGroup());
            }
        }
        return ListUtil.unique(userOrgsGroups);
    }

    public Group getUserPersonalSiteGroup(long companyId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(UserPersonalSite.class);
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, defaultUserId);
    }

    public List<Group> getUserSitesGroups(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Comparable<Boolean>> groupParams = new LinkedHashMap<String, Comparable<Boolean>>();
        groupParams.put("inherit", Boolean.TRUE);
        groupParams.put("site", Boolean.TRUE);
        groupParams.put("usersGroups", Long.valueOf(userId));
        return this.groupFinder.findByCompanyId(user.getCompanyId(), groupParams, -1, -1, (OrderByComparator)new GroupNameComparator(true));
    }

    public List<Group> getUserSitesGroups(long userId, boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this.getUserSitesGroups(userId);
        }
        HashSet<Group> sites = new HashSet<Group>();
        List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Site Administrator") && !roleName.equals("Site Owner")) continue;
            Group group = userGroupRole.getGroup();
            sites.add(group);
        }
        sites.addAll(this.getUserSitesGroups(userId));
        return new ArrayList<Group>(sites);
    }

    public boolean hasStagingGroup(long liveGroupId) {
        return this.groupPersistence.fetchByLiveGroupId(liveGroupId) != null;
    }

    @Override
    public boolean hasUserGroup(long userId, long groupId) {
        return this.hasUserGroup(userId, groupId, true);
    }

    public boolean hasUserGroup(long userId, long groupId, boolean inherit) {
        return this.groupFinder.countByG_U(groupId, userId, inherit) > 0;
    }

    public Group loadFetchGroup(long companyId, String groupKey) {
        return this.groupPersistence.fetchByC_GK(companyId, groupKey);
    }

    public Group loadGetGroup(long companyId, String groupKey) throws PortalException {
        return this.groupPersistence.findByC_GK(companyId, groupKey);
    }

    public void rebuildTree(long companyId) throws PortalException {
        final long classNameId = this.classNameLocalService.getClassNameId(Group.class);
        TreePathUtil.rebuildTree((long)companyId, (long)0L, (String)"/", (TreeModelTasks)new TreeModelTasksAdapter<Group>(){

            public List<Group> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return GroupLocalServiceImpl.this.groupPersistence.findByG_C_C_P(previousId, companyId, classNameId, parentPrimaryKey, -1, size, (OrderByComparator)new GroupIdComparator(true));
            }
        });
    }

    public List<Group> search(long companyId, LinkedHashMap<String, Object> params, int start, int end) {
        return this.groupFinder.findByCompanyId(companyId, params, start, end, (OrderByComparator)new GroupNameComparator(true));
    }

    public List<Group> search(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, keywords, params, start, end, obc);
    }

    public List<Group> search(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, classNameIds, parentGroupId, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) {
        String[] keywordsArray = this.getSearchNames(companyId, keywords);
        boolean andOperator = false;
        if (Validator.isNull((String)keywords)) {
            andOperator = true;
        }
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.findByC_C_PG_N_D(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator, start, end, obc);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        return this.sort(groups, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, classNameIds, parentGroupId, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) {
        String[] names = this.getSearchNames(companyId, name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.findByC_C_PG_N_D(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator, start, end, obc);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        return this.sort(groups, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, classNameIds, -1L, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) {
        return this.search(companyId, classNameIds, -1L, keywords, params, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, classNameIds, -1L, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) {
        return this.search(companyId, classNameIds, -1L, name, description, params, andOperator, start, end, obc);
    }

    @ThreadLocalCachable
    public List<Group> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), -1L, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) {
        return this.search(companyId, this.getClassNameIds(), -1L, keywords, params, start, end, obc);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.search(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) {
        return this.search(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator, start, end, obc);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params) {
        return this.searchCount(companyId, this.getClassNameIds(), parentGroupId, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.searchCount(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params) {
        String[] keywordsArray = this.getSearchNames(companyId, keywords);
        boolean andOperator = false;
        if (Validator.isNull((String)keywords)) {
            andOperator = true;
        }
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.countByC_C_PG_N_D(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        return groups.size();
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] names = this.getSearchNames(companyId, name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.countByC_C_PG_N_D(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        }
        Collection<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        return groups.size();
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params) {
        return this.searchCount(companyId, classNameIds, -1L, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.searchCount(companyId, classNameIds, -1L, name, description, params, andOperator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        return this.searchCount(companyId, this.getClassNameIds(), -1L, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.searchCount(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator);
    }

    @Override
    public void setRoleGroups(long roleId, long[] groupIds) {
        this.rolePersistence.setGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) {
        this.rolePersistence.removeGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserGroups(long userId, long[] groupIds) {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupIds);
        this.userPersistence.removeGroups(userId, groupIds);
        PermissionCacheUtil.clearCache(userId);
    }

    public void updateAsset(long userId, Group group, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), null, null, Group.class.getName(), group.getGroupId(), null, 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, null, group.getDescriptiveName(), group.getDescription(), null, null, null, 0, 0, null);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isUser()) {
            User user = this.userPersistence.findByPrimaryKey(group.getClassPK());
            friendlyURL = "/" + user.getScreenName();
            if (group.getFriendlyURL().equals(friendlyURL)) {
                return group;
            }
        }
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, group.getClassNameId(), group.getClassPK(), "", friendlyURL);
        this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        group.setFriendlyURL(friendlyURL);
        this.groupPersistence.update((BaseModel)group);
        return group;
    }

    public Group updateGroup(long groupId, long parentGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String className = group.getClassName();
        long classNameId = group.getClassNameId();
        long classPK = group.getClassPK();
        String groupKey = group.getGroupKey();
        if (nameMap != null && Validator.isNotNull((String)nameMap.get(LocaleUtil.getDefault()))) {
            groupKey = nameMap.get(LocaleUtil.getDefault());
        }
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, classNameId, classPK, "", friendlyURL);
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            this.validateGroupKey(group.getGroupId(), group.getCompanyId(), groupKey, group.isSite());
        } else if (className.equals(Organization.class.getName())) {
            Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
            groupKey = this.getOrgGroupName(organization.getName());
        } else if (!"User Personal Site".equals(group.getGroupKey())) {
            groupKey = String.valueOf(classPK);
        }
        if (PortalUtil.isSystemGroup((String)group.getGroupKey()) && !groupKey.equals(group.getGroupKey())) {
            throw new RequiredGroupException.MustNotDeleteSystemGroup(group.getGroupId());
        }
        this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        this.validateParentGroup(group.getGroupId(), parentGroupId);
        group.setParentGroupId(parentGroupId);
        group.setTreePath(group.buildTreePath());
        group.setGroupKey(groupKey);
        group.setNameMap(nameMap);
        group.setDescriptionMap(descriptionMap);
        group.setType(type);
        group.setManualMembership(manualMembership);
        group.setMembershipRestriction(membershipRestriction);
        group.setFriendlyURL(friendlyURL);
        group.setInheritContent(inheritContent);
        group.setActive(active);
        if (serviceContext != null && group.isSite()) {
            group.setExpandoBridgeAttributes(serviceContext);
        }
        this.groupPersistence.update((BaseModel)group);
        if (serviceContext == null || !group.isSite()) {
            return group;
        }
        User user = null;
        user = this.userPersistence.fetchByPrimaryKey(group.getCreatorUserId());
        if (user == null) {
            user = this.userPersistence.fetchByPrimaryKey(serviceContext.getUserId());
        }
        if (user == null) {
            user = this.userLocalService.getDefaultUser(group.getCompanyId());
        }
        this.updateAsset(user.getUserId(), group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return group;
    }

    @Deprecated
    public Group updateGroup(long groupId, long parentGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.updateGroup(groupId, parentGroupId, this.getLocalizationMap(name), this.getLocalizationMap(description), type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        UnicodeProperties oldTypeSettingsProperties = group.getTypeSettingsProperties();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        String newLanguageIds = typeSettingsProperties.getProperty("locales");
        if (Validator.isNotNull((String)newLanguageIds)) {
            String oldLanguageIds = oldTypeSettingsProperties.getProperty("locales", "");
            String defaultLanguageId = typeSettingsProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            this.validateLanguageIds(defaultLanguageId, newLanguageIds);
            if (!Objects.equals(oldLanguageIds, newLanguageIds)) {
                LanguageUtil.resetAvailableGroupLocales((long)groupId);
            }
        }
        group.setTypeSettings(typeSettings);
        this.groupPersistence.update((BaseModel)group);
        return group;
    }

    public Group updateSite(long groupId, boolean site) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (!group.isOrganization()) {
            return group;
        }
        group.setSite(site);
        this.groupPersistence.update((BaseModel)group);
        return group;
    }

    protected void addControlPanelLayouts(Group group) throws PortalException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), true, 0L, PropsValues.CONTROL_PANEL_LAYOUT_NAME, "", "", "control_panel", false, friendlyURL, serviceContext);
    }

    protected void addDefaultGuestPublicLayoutByProperties(Group group) throws PortalException {
        List portlets = this.portletLocalService.getPortlets(group.getCompanyId());
        if (portlets.isEmpty()) {
            return;
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), false, 0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_NAME, "", "", "portlet", false, friendlyURL, serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.guest.public.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
        }
        this.layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            this.layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    protected void addDefaultGuestPublicLayouts(Group group) throws PortalException {
        if (this.publicLARFile != null) {
            this.addDefaultGuestPublicLayoutsByLAR(group, this.publicLARFile);
        } else {
            this.addDefaultGuestPublicLayoutByProperties(group);
        }
    }

    protected void addDefaultGuestPublicLayoutsByLAR(Group group, File larFile) throws PortalException {
        User defaultUser = this.userLocalService.getDefaultUser(group.getCompanyId());
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactory.buildImportLayoutSettingsMap((User)defaultUser, (long)group.getGroupId(), (boolean)false, null, parameterMap);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(defaultUser.getUserId(), 6, importLayoutSettingsMap);
        this.exportImportLocalService.importLayouts(exportImportConfiguration, larFile);
    }

    protected void addPortletDefaultData(Group group) throws PortalException {
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createPreparePortletDataContext((long)group.getCompanyId(), (long)group.getGroupId(), null, null);
        List<PortletDataHandler> portletDataHandlers = this.getPortletDataHandlers(group);
        for (PortletDataHandler portletDataHandler : portletDataHandlers) {
            try {
                portletDataHandler.addDefaultData(portletDataContext, portletDataHandler.getPortletId(), null);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to add default data for portlet " + portletDataHandler.getPortletId() + " in group " + group.getGroupId()));
                if (!portletDataHandler.isRollbackOnException()) continue;
                throw new SystemException((Throwable)e);
            }
        }
    }

    protected void deletePortletData(Group group) throws PortalException {
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createPreparePortletDataContext((long)group.getCompanyId(), (long)group.getGroupId(), null, null);
        List<PortletDataHandler> portletDataHandlers = this.getPortletDataHandlers(group);
        for (PortletDataHandler portletDataHandler : portletDataHandlers) {
            try {
                portletDataHandler.deleteData(portletDataContext, portletDataHandler.getPortletId(), null);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to delete data for portlet " + portletDataHandler.getPortletId() + " in group " + group.getGroupId()));
                if (!portletDataHandler.isRollbackOnException()) continue;
                throw new SystemException((Throwable)e);
            }
        }
    }

    protected Collection<Group> doSearch(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) {
        Long roleId;
        ResourceAction resourceAction;
        boolean parentGroupIdEquals = true;
        if (parentGroupId == -1L) {
            parentGroupIdEquals = false;
        }
        params = new LinkedHashMap<String, Object>(params);
        Boolean active = (Boolean)params.remove("active");
        List excludedGroupIds = (List)params.remove("excludedGroupIds");
        List groupsTree = (List)params.remove("groupsTree");
        Boolean manualMembership = (Boolean)params.remove("manualMembership");
        Integer membershipRestriction = (Integer)params.remove("membershipRestriction");
        Boolean site = (Boolean)params.remove("site");
        List types = (List)params.remove("types");
        HashSet<Group> groups = new HashSet<Group>();
        Long userId = (Long)params.remove("usersGroups");
        for (long classNameId : classNameIds) {
            groups.addAll(this.groupPersistence.findByC_C(companyId, classNameId));
        }
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            long liveGroupId = group.getLiveGroupId();
            if (liveGroupId != 0L) {
                iterator.remove();
                continue;
            }
            long groupParentGroupId = group.getParentGroupId();
            if (parentGroupIdEquals && groupParentGroupId != parentGroupId || !parentGroupIdEquals && groupParentGroupId == parentGroupId) {
                iterator.remove();
                continue;
            }
            String string = group.getGroupKey();
            if (string.equals("Control Panel")) {
                iterator.remove();
                continue;
            }
            boolean containsName = this.matches(group.getNameCurrentValue(), names);
            boolean containsDescription = this.matches(group.getDescriptionCurrentValue(), descriptions);
            if (andOperator && (!containsName || !containsDescription) || !andOperator && !containsName && !containsDescription) {
                iterator.remove();
                continue;
            }
            if (active != null && active.booleanValue() != group.isActive()) {
                iterator.remove();
                continue;
            }
            if (excludedGroupIds != null && excludedGroupIds.contains(group.getGroupId())) {
                iterator.remove();
                continue;
            }
            if (groupsTree != null) {
                String treePath = group.getTreePath();
                boolean matched = false;
                for (Group groupTree : groupsTree) {
                    String groupTreePath = StringUtil.quote((String)String.valueOf(groupTree.getGroupId()), (String)"/");
                    if (!treePath.contains(groupTreePath)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    iterator.remove();
                    continue;
                }
            }
            if (manualMembership != null && manualMembership.booleanValue() != group.isManualMembership()) {
                iterator.remove();
                continue;
            }
            if (membershipRestriction != null && membershipRestriction.intValue() != group.getMembershipRestriction()) {
                iterator.remove();
                continue;
            }
            if (site != null && site.booleanValue() != group.isSite()) {
                iterator.remove();
                continue;
            }
            int type = group.getType();
            if (type == 4) {
                iterator.remove();
                continue;
            }
            if (types == null || types.contains(type)) continue;
            iterator.remove();
        }
        RolePermissions rolePermissions = (RolePermissions)params.remove("rolePermissions");
        if (rolePermissions != null && (resourceAction = this.resourceActionLocalService.fetchResourceAction(rolePermissions.getName(), rolePermissions.getActionId())) != null) {
            HashSet<Group> rolePermissionsGroups = new HashSet<Group>();
            if (this.resourceBlockLocalService.isSupported(rolePermissions.getName())) {
                List resourceTypePermissions = this.resourceTypePermissionPersistence.findByRoleId(rolePermissions.getRoleId());
                for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
                    Group group;
                    if (resourceTypePermission.getCompanyId() != companyId || !Objects.equals(rolePermissions.getName(), resourceTypePermission.getName()) || !resourceTypePermission.hasAction(resourceAction) || (group = this.groupPersistence.fetchByPrimaryKey(resourceTypePermission.getGroupId())) == null) continue;
                    rolePermissionsGroups.add(group);
                }
            } else {
                List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, rolePermissions.getName(), rolePermissions.getScope());
                for (ResourcePermission resourcePermission : resourcePermissions) {
                    Group group;
                    if (resourcePermission.getRoleId() != rolePermissions.getRoleId() || !resourcePermission.hasAction(resourceAction) || (group = this.groupPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)resourcePermission.getPrimKey()))) == null) continue;
                    rolePermissionsGroups.add(group);
                }
            }
            groups.retainAll(rolePermissionsGroups);
        }
        if ((roleId = (Long)params.remove("groupsRoles")) != null) {
            groups.retainAll(this.rolePersistence.getGroups(roleId.longValue()));
        }
        if (userId == null) {
            return groups;
        }
        HashSet<Group> joinedGroups = new HashSet<Group>(this.userPersistence.getGroups(userId.longValue()));
        boolean inherit = GetterUtil.getBoolean(params.remove("inherit"), (boolean)true);
        if (inherit) {
            long[] lArray;
            long[] organizationIds;
            for (long organizationId : organizationIds = this.userPersistence.getOrganizationPrimaryKeys(userId.longValue())) {
                for (Group group : groups) {
                    if (organizationId != group.getClassPK()) continue;
                    joinedGroups.add(group);
                }
            }
            for (long organizationId : organizationIds) {
                joinedGroups.addAll(this.organizationPersistence.getGroups(organizationId));
            }
            for (long userGroupId : lArray = this.userPersistence.getUserGroupPrimaryKeys(userId.longValue())) {
                joinedGroups.addAll(this.userGroupPersistence.getGroups(userGroupId));
            }
        }
        if (_log.isDebugEnabled() && !params.isEmpty()) {
            _log.debug((Object)("Unprocessed parameters " + MapUtil.toString(params)));
        }
        if (joinedGroups.size() > groups.size()) {
            groups.retainAll(joinedGroups);
            return groups;
        }
        joinedGroups.retainAll(groups);
        return joinedGroups;
    }

    protected long[] getClassNameIds() {
        if (this._classNameIds == null) {
            this._classNameIds = new long[]{this.classNameLocalService.getClassNameId(Group.class), this.classNameLocalService.getClassNameId(Organization.class)};
        }
        return this._classNameIds;
    }

    protected String getFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyName, String friendlyURL) throws PortalException {
        if (Validator.isNotNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            return friendlyURL;
        }
        String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(friendlyName);
        int i = 1;
        while (true) {
            try {
                this.validateFriendlyURL(companyId, groupId, classNameId, classPK, friendlyURL);
            }
            catch (GroupFriendlyURLException gfurle) {
                int type = gfurle.getType();
                if (type != 6) {
                    friendlyURL = "/" + classPK;
                    break;
                }
                friendlyURL = originalFriendlyURL + i;
                ++i;
                continue;
            }
            break;
        }
        return friendlyURL;
    }

    protected String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    protected String getOrgGroupName(String name) {
        return name + ORGANIZATION_NAME_SUFFIX;
    }

    protected List<PortletDataHandler> getPortletDataHandlers(Group group) {
        List portlets = this.portletLocalService.getPortlets(group.getCompanyId());
        ArrayList<PortletDataHandler> portletDataHandlers = new ArrayList<PortletDataHandler>(portlets.size());
        for (Portlet portlet : portlets) {
            PortletDataHandler portletDataHandler;
            if (!portlet.isActive() || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || portletDataHandler.isDataPortalLevel()) continue;
            portletDataHandlers.add(portletDataHandler);
        }
        return portletDataHandlers;
    }

    protected String[] getSearchNames(long companyId, String name) {
        if (Validator.isNull((String)name)) {
            return new String[]{null};
        }
        Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company == null) {
            return CustomSQLUtil.keywords((String)name);
        }
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            return CustomSQLUtil.keywords((String)name);
        }
        String companyName = account.getName();
        if (StringUtil.wildcardMatches((String)companyName, (String)name, (char)'_', (char)'%', (char)'\\', (boolean)false)) {
            Object[] searchNames = CustomSQLUtil.keywords((String)name);
            String guestName = StringUtil.quote((String)StringUtil.toLowerCase((String)"Guest"), (String)"%");
            return (String[])ArrayUtil.append((Object[])searchNames, (Object)guestName);
        }
        return CustomSQLUtil.keywords((String)name);
    }

    protected void initImportLARFile() {
        String publicLARFileName = PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected void initUserPersonalSitePermissions(Group group) throws PortalException {
        Role role = this.roleLocalService.getRole(group.getCompanyId(), "User");
        this.setRolePermissions(group, role, Layout.class.getName(), new String[]{"VIEW"});
        role = this.roleLocalService.getRole(group.getCompanyId(), "Power User");
        this.setRolePermissions(group, role, Group.class.getName(), new String[]{"MANAGE_LAYOUTS", "VIEW_SITE_ADMINISTRATION"});
    }

    protected boolean isParentGroup(long parentGroupId, long groupId) throws PortalException {
        if (groupId == 0L) {
            return false;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String treePath = group.getTreePath();
        return treePath.contains("/" + parentGroupId + "/");
    }

    protected boolean isStaging(ServiceContext serviceContext) {
        if (serviceContext != null) {
            return ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"staging");
        }
        return false;
    }

    protected boolean isUseComplexSQL(long[] classNameIds) {
        if (ArrayUtil.isEmpty((long[])classNameIds)) {
            return true;
        }
        if (this._complexSQLClassNameIds == null) {
            String[] complexSQLClassNames = PropsValues.GROUPS_COMPLEX_SQL_CLASS_NAMES;
            long[] complexSQLClassNameIds = new long[complexSQLClassNames.length];
            for (int i = 0; i < complexSQLClassNames.length; ++i) {
                String complexSQLClassName = complexSQLClassNames[i];
                complexSQLClassNameIds[i] = this.classNameLocalService.getClassNameId(complexSQLClassName);
            }
            this._complexSQLClassNameIds = complexSQLClassNameIds;
        }
        for (long classNameId : classNameIds) {
            if (!ArrayUtil.contains((long[])this._complexSQLClassNameIds, (long)classNameId)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(String s, String[] keywords) {
        if (keywords == null || keywords.length == 1 && keywords[0] == null) {
            return true;
        }
        for (String keyword : keywords) {
            if (!StringUtil.wildcardMatches((String)s, (String)keyword, (char)'_', (char)'%', (char)'\\', (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void setCompanyPermissions(Role role, String name, String[] actionIds) throws PortalException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.resourceBlockLocalService.setCompanyScopePermissions(role.getCompanyId(), name, role.getRoleId(), Arrays.asList(actionIds));
        } else {
            this.resourcePermissionLocalService.setResourcePermissions(role.getCompanyId(), name, 1, String.valueOf(role.getCompanyId()), role.getRoleId(), actionIds);
        }
    }

    protected void setRolePermissions(Group group, Role role, String name) throws PortalException {
        List actions = ResourceActionsUtil.getModelResourceActions((String)name);
        this.setRolePermissions(group, role, name, actions.toArray(new String[actions.size()]));
    }

    protected void setRolePermissions(Group group, Role role, String name, String[] actionIds) throws PortalException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.resourceBlockLocalService.setGroupScopePermissions(role.getCompanyId(), group.getGroupId(), name, role.getRoleId(), Arrays.asList(actionIds));
        } else {
            this.resourcePermissionLocalService.setResourcePermissions(group.getCompanyId(), name, 2, String.valueOf(group.getGroupId()), role.getRoleId(), actionIds);
        }
    }

    protected List<Group> sort(Collection<Group> groups, int start, int end, OrderByComparator<Group> obc) {
        if (obc == null) {
            obc = new GroupNameComparator(true);
        }
        ArrayList<Group> groupList = null;
        groupList = groups instanceof List ? (ArrayList<Group>)groups : new ArrayList<Group>(groups);
        Collections.sort(groupList, obc);
        return Collections.unmodifiableList(ListUtil.subList(groupList, (int)start, (int)end));
    }

    protected void unscheduleStaging(Group group) {
        try {
            String groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_remote_publisher", (long)group.getGroupId());
            SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
            long liveGroupId = 0L;
            long stagingGroupId = 0L;
            if (group.isStagingGroup()) {
                liveGroupId = group.getLiveGroupId();
                stagingGroupId = group.getGroupId();
            } else if (group.hasStagingGroup()) {
                liveGroupId = group.getGroupId();
                stagingGroupId = group.getStagingGroup().getGroupId();
            }
            if (liveGroupId != 0L && stagingGroupId != 0L) {
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)liveGroupId);
                SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)stagingGroupId);
                SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to unschedule events for group: " + group.getGroupId()));
        }
    }

    protected void validateFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyURL) throws PortalException {
        long userClassNameId;
        long groupClassNameId;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem()) {
            return;
        }
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new GroupFriendlyURLException(exceptionType);
        }
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null && group.getGroupId() != groupId) {
            GroupFriendlyURLException gfurle = new GroupFriendlyURLException(6);
            gfurle.setDuplicateClassPK(group.getGroupId());
            gfurle.setDuplicateClassName(Group.class.getName());
            throw gfurle;
        }
        String groupIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)groupIdFriendlyURL) && (classNameId != (groupClassNameId = this.classNameLocalService.getClassNameId(Group.class)) && !groupIdFriendlyURL.equals(String.valueOf(classPK)) && !PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC || classNameId == groupClassNameId && !groupIdFriendlyURL.equals(String.valueOf(groupId)))) {
            GroupFriendlyURLException gfurle = new GroupFriendlyURLException(8);
            gfurle.setKeywordConflict(groupIdFriendlyURL);
            throw gfurle;
        }
        String screenName = friendlyURL.substring(1);
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null && (classNameId != (userClassNameId = this.classNameLocalService.getClassNameId(User.class)) || classPK != user.getUserId())) {
            GroupFriendlyURLException gfurle = new GroupFriendlyURLException(6);
            gfurle.setDuplicateClassPK(user.getUserId());
            gfurle.setDuplicateClassName(User.class.getName());
            throw gfurle;
        }
        if (StringUtil.count((String)friendlyURL, (char)'/') > 1) {
            throw new GroupFriendlyURLException(9);
        }
    }

    protected void validateGroupKey(long groupId, long companyId, String groupKey, boolean site) throws PortalException {
        Company company;
        if (Validator.isNull((String)groupKey) || Validator.isNumber((String)groupKey) || groupKey.contains("*") || groupKey.contains(ORGANIZATION_NAME_SUFFIX)) {
            throw new GroupKeyException();
        }
        try {
            Group group = this.groupFinder.findByC_GK(companyId, groupKey);
            if (groupId <= 0L || group.getGroupId() != groupId) {
                throw new DuplicateGroupException("{groupId=" + groupId + "}");
            }
        }
        catch (NoSuchGroupException group) {
            // empty catch block
        }
        if (site && groupKey.equals((company = this.companyLocalService.getCompany(companyId)).getName())) {
            throw new DuplicateGroupException();
        }
    }

    protected void validateInheritContent(long parentGroupId, boolean inheritContent) throws GroupInheritContentException {
        if (!inheritContent) {
            return;
        }
        if (parentGroupId == 0L) {
            throw new GroupInheritContentException();
        }
        Group parentGroup = this.groupPersistence.fetchByPrimaryKey(parentGroupId);
        if (parentGroup.isInheritContent()) {
            throw new GroupInheritContentException();
        }
    }

    protected void validateLanguageIds(String defaultLanguageId, String languageIds) throws PortalException {
        Object[] languageIdsArray;
        for (String string : languageIdsArray = StringUtil.split((String)languageIds)) {
            if (LanguageUtil.isAvailableLocale((Locale)LocaleUtil.fromLanguageId((String)string))) continue;
            LocaleException le = new LocaleException(1);
            le.setSourceAvailableLocales((Collection)LanguageUtil.getAvailableLocales());
            le.setTargetAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])languageIdsArray)));
            throw le;
        }
        if (!ArrayUtil.contains((Object[])languageIdsArray, (Object)defaultLanguageId)) {
            LocaleException le = new LocaleException(4);
            le.setSourceAvailableLocales((Collection)LanguageUtil.getAvailableLocales());
            le.setTargetAvailableLocales(Arrays.asList(LocaleUtil.fromLanguageIds((String[])languageIdsArray)));
            throw le;
        }
    }

    protected void validateParentGroup(long groupId, long parentGroupId) throws PortalException {
        long stagingGroupId;
        if (parentGroupId == 0L) {
            return;
        }
        if (groupId == parentGroupId) {
            throw new GroupParentException.MustNotBeOwnParent(groupId);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group == null) {
            return;
        }
        if (groupId > 0L && parentGroupId != 0L && this.isParentGroup(groupId, parentGroupId)) {
            throw new GroupParentException.MustNotHaveChildParent(groupId, parentGroupId);
        }
        Group parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId);
        if (group.isStagingGroup() && groupId == (stagingGroupId = parentGroup.getStagingGroup().getGroupId())) {
            throw new GroupParentException.MustNotHaveStagingParent(groupId, stagingGroupId);
        }
    }
}

