/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class PortletPreferencesLocalServiceStagingAdvice
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return methodInvocation.proceed();
        }
        try {
            Object[] arguments = methodInvocation.getArguments();
            if (arguments == null) {
                return methodInvocation.proceed();
            }
            Method method = methodInvocation.getMethod();
            String methodName = method.getName();
            if (methodName.equals("getPortletPreferences") && (arguments.length == 2 || arguments.length == 3 || arguments.length == 4)) {
                return this.getPortletPreferences(methodInvocation);
            }
            if (methodName.equals("getPortletPreferencesCount") && (arguments.length == 3 || arguments.length == 5)) {
                return this.getPortletPreferencesCount(methodInvocation);
            }
            if (methodName.equals("getPreferences")) {
                return this.getPreferences(methodInvocation);
            }
            if (methodName.equals("getStrictPreferences")) {
                return this.getPreferences(methodInvocation);
            }
            if (methodName.equals("updatePreferences")) {
                return this.updatePreferences(methodInvocation);
            }
            return methodInvocation.proceed();
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected LayoutRevision getLayoutRevision(long plid) {
        if (plid <= 0L) {
            return null;
        }
        LayoutRevision layoutRevision = LayoutRevisionUtil.fetchByPrimaryKey((long)plid);
        if (layoutRevision != null) {
            return layoutRevision;
        }
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        if (layout == null) {
            return null;
        }
        if (!LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return null;
        }
        return LayoutStagingUtil.getLayoutRevision((Layout)layout);
    }

    protected Object getPortletPreferences(MethodInvocation methodInvocation) throws Throwable {
        LayoutRevision layoutRevision;
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        int index = -1;
        if (arguments.length == 2 && arguments[0] instanceof Long && arguments[1] instanceof String) {
            index = 0;
        } else if (arguments.length == 3 && arguments[0] instanceof Integer && arguments[1] instanceof Long && arguments[2] instanceof String) {
            index = 1;
        } else if ((arguments.length == 3 || arguments.length == 4) && arguments[2] instanceof Long) {
            index = 2;
        }
        long plid = 0L;
        if (index >= 0) {
            plid = (Long)arguments[index];
        }
        if ((layoutRevision = this.getLayoutRevision(plid)) == null) {
            return methodInvocation.proceed();
        }
        arguments[index] = layoutRevision.getLayoutRevisionId();
        return method.invoke(methodInvocation.getThis(), arguments);
    }

    protected Object getPortletPreferencesCount(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        long plid = 0L;
        plid = arguments.length == 3 ? ((Long)arguments[1]).longValue() : ((Long)arguments[2]).longValue();
        LayoutRevision layoutRevision = this.getLayoutRevision(plid);
        if (layoutRevision == null) {
            return methodInvocation.proceed();
        }
        if (arguments.length == 3) {
            arguments[1] = layoutRevision.getLayoutRevisionId();
        } else {
            arguments[2] = layoutRevision.getLayoutRevisionId();
        }
        return method.invoke(methodInvocation.getThis(), arguments);
    }

    protected Object getPreferences(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        long plid = 0L;
        if (arguments.length == 1) {
            PortletPreferencesIds portletPreferencesIds = (PortletPreferencesIds)arguments[0];
            plid = portletPreferencesIds.getPlid();
        } else {
            plid = (Long)arguments[3];
        }
        LayoutRevision layoutRevision = this.getLayoutRevision(plid);
        if (layoutRevision == null) {
            return methodInvocation.proceed();
        }
        User user = UserLocalServiceUtil.fetchUser((long)PrincipalThreadLocal.getUserId());
        plid = user == null || user.isDefaultUser() ? layoutRevision.getLayoutRevisionId() : StagingUtil.getRecentLayoutRevisionId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid());
        if (arguments.length == 1) {
            PortletPreferencesIds portletPreferencesIds = (PortletPreferencesIds)arguments[0];
            arguments[0] = new PortletPreferencesIds(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), plid, portletPreferencesIds.getPortletId());
        } else {
            arguments[3] = plid;
        }
        return method.invoke(methodInvocation.getThis(), arguments);
    }

    protected Object updatePreferences(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        long plid = (Long)arguments[2];
        LayoutRevision layoutRevision = this.getLayoutRevision(plid);
        if (layoutRevision == null) {
            return methodInvocation.proceed();
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return methodInvocation.proceed();
        }
        boolean exporting = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"exporting");
        if (exporting) {
            return methodInvocation.proceed();
        }
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        layoutRevision = LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        arguments[2] = layoutRevision.getLayoutRevisionId();
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
        return method.invoke(methodInvocation.getThis(), arguments);
    }
}

