/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.upgrade.v7_0_0.util.GroupTable;
import java.sql.PreparedStatement;
import java.util.Locale;

public class UpgradeGroup
extends UpgradeProcess {
    protected void createIndex() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("create index IX_8257E37B on Group_ (classNameId, classPK)");
        }
    }

    protected void doUpgrade() throws Exception {
        this.alter(GroupTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "STRING null")});
        this.createIndex();
        this.updateGlobalGroupName();
    }

    protected void updateGlobalGroupName() throws Exception {
        LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            localizedValuesMap.put(locale, LanguageUtil.get((Locale)locale, (String)"global"));
        }
        String nameXML = LocalizationUtil.getXml((LocalizedValuesMap)localizedValuesMap, (String)"global");
        try (PreparedStatement ps = this.connection.prepareStatement("update Group_ set name = ? where friendlyURL = '/global'");){
            ps.setString(1, nameXML);
            ps.executeUpdate();
        }
    }
}

