/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.welder.socket;

import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.welder.BaseWelder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SocketUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class SocketWelder
extends BaseWelder {
    protected final int bufferSize = Configuration.bufferSize;
    protected final boolean keepAlive = Configuration.keepAlive;
    protected final boolean reuseAddress = Configuration.reuseAddress;
    protected final int serverPort;
    protected final transient ServerSocketChannel serverSocketChannel;
    protected transient SocketChannel socketChannel;
    protected final int soLinger = Configuration.soLinger;
    protected final int soTimeout = Configuration.soTimeout;
    protected final boolean tcpNoDelay = Configuration.tcpNoDelay;

    public SocketWelder() throws IOException {
        this.serverSocketChannel = SocketUtil.createServerSocketChannel(InetAddressUtil.getLoopbackInetAddress(), Configuration.serverStartPort, new SocketWelderServerSocketConfigurator());
        ServerSocket serverSocket = this.serverSocketChannel.socket();
        this.serverPort = serverSocket.getLocalPort();
    }

    @Override
    protected void doDestroy() throws IOException {
        this.socketChannel.close();
    }

    @Override
    protected RegistrationReference weldClient(Intraband intraband) throws IOException {
        this.socketChannel = SocketChannel.open();
        this._configureSocket(this.socketChannel.socket());
        this.socketChannel.connect(new InetSocketAddress(InetAddressUtil.getLoopbackInetAddress(), this.serverPort));
        return intraband.registerChannel(this.socketChannel);
    }

    @Override
    protected RegistrationReference weldServer(Intraband intraband) throws IOException {
        this.socketChannel = this.serverSocketChannel.accept();
        this.serverSocketChannel.close();
        this._configureSocket(this.socketChannel.socket());
        return intraband.registerChannel(this.socketChannel);
    }

    private void _configureSocket(Socket socket) throws SocketException {
        socket.setKeepAlive(this.keepAlive);
        socket.setReceiveBufferSize(this.bufferSize);
        socket.setReuseAddress(this.reuseAddress);
        socket.setSendBufferSize(this.bufferSize);
        if (this.soLinger <= 0) {
            socket.setSoLinger(false, this.soLinger);
        } else {
            socket.setSoLinger(true, this.soLinger);
        }
        socket.setSoTimeout(this.soTimeout);
        socket.setTcpNoDelay(this.tcpNoDelay);
    }

    protected class SocketWelderServerSocketConfigurator
    implements SocketUtil.ServerSocketConfigurator {
        protected SocketWelderServerSocketConfigurator() {
        }

        @Override
        public void configure(ServerSocket serverSocket) throws SocketException {
            serverSocket.setReceiveBufferSize(SocketWelder.this.bufferSize);
            serverSocket.setReuseAddress(SocketWelder.this.reuseAddress);
            serverSocket.setSoTimeout(SocketWelder.this.soTimeout);
        }
    }

    protected static class Configuration {
        protected static final int bufferSize = GetterUtil.getInteger(PropsUtil.get("intraband.welder.socket.buffer.size"));
        protected static final boolean keepAlive = GetterUtil.getBoolean(PropsUtil.get("intraband.welder.socket.keep.alive"));
        protected static final boolean reuseAddress = GetterUtil.getBoolean(PropsUtil.get("intraband.welder.socket.reuse.address"));
        protected static final int serverStartPort = GetterUtil.getInteger(PropsUtil.get("intraband.welder.socket.server.start.port"));
        protected static final int soLinger = GetterUtil.getInteger(PropsUtil.get("intraband.welder.socket.so.linger"));
        protected static final int soTimeout = GetterUtil.getInteger(PropsUtil.get("intraband.welder.socket.so.timeout"));
        protected static final boolean tcpNoDelay = GetterUtil.getBoolean(PropsUtil.get("intraband.welder.socket.tcp.no.delay"));

        protected Configuration() {
        }
    }
}

